/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.ICustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.proxy.IProxy;

public class ItemManasteelArmor
extends class_1738
implements ICustomDamageItem,
IPhantomInkable {
    private static final int MANA_PER_DAMAGE = 70;
    private static final String TAG_PHANTOM_INK = "phantomInk";
    public final class_1304 type;
    private static final Supplier<class_1799[]> armorSet = Suppliers.memoize(() -> new class_1799[]{new class_1799((class_1935)ModItems.manasteelHelm), new class_1799((class_1935)ModItems.manasteelChest), new class_1799((class_1935)ModItems.manasteelLegs), new class_1799((class_1935)ModItems.manasteelBoots)});

    public ItemManasteelArmor(class_1304 type, class_1792.class_1793 props) {
        this(type, BotaniaAPI.instance().getManasteelArmorMaterial(), props);
    }

    public ItemManasteelArmor(class_1304 type, class_1741 mat, class_1792.class_1793 props) {
        super(mat, type, props);
        this.type = type;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.onArmorTick(stack, world, player);
        }
    }

    public void onArmorTick(class_1799 stack, class_1937 world, class_1657 player) {
        if (!world.field_9236 && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, 140, true)) {
            stack.method_7974(stack.method_7919() - 1);
        }
    }

    @Override
    public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible(stack, amount, entity, 70);
    }

    @Nonnull
    public final String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String type) {
        return this.hasPhantomInk(stack) ? "botania:textures/model/armor_invisible.png" : this.getArmorTextureAfterInk(stack, slot);
    }

    public String getArmorTextureAfterInk(class_1799 stack, class_1304 slot) {
        return "botania:textures/model/armor_manasteel.png";
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
        TooltipHandler.addOnShift(list, () -> this.addInformationAfterShift(stack, world, list, flags));
    }

    public void addInformationAfterShift(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
        class_1799[] stacks;
        class_1657 player = IProxy.INSTANCE.getClientPlayer();
        list.add(this.getArmorSetTitle(player));
        this.addArmorSetDescription(stack, list);
        for (class_1799 armor : stacks = this.getArmorSetStacks()) {
            class_5250 cmp = new class_2585(" - ").method_10852(armor.method_7964());
            class_1304 slot = ((class_1738)armor.method_7909()).method_7685();
            cmp.method_27692(this.hasArmorSetItem(player, slot) ? class_124.field_1060 : class_124.field_1080);
            list.add((class_2561)cmp);
        }
        if (this.hasPhantomInk(stack)) {
            list.add((class_2561)new class_2588("botaniamisc.hasPhantomInk").method_27692(class_124.field_1080));
        }
    }

    public class_1799[] getArmorSetStacks() {
        return armorSet.get();
    }

    public boolean hasArmorSet(class_1657 player) {
        return this.hasArmorSetItem(player, class_1304.field_6169) && this.hasArmorSetItem(player, class_1304.field_6174) && this.hasArmorSetItem(player, class_1304.field_6172) && this.hasArmorSetItem(player, class_1304.field_6166);
    }

    public boolean hasArmorSetItem(class_1657 player, class_1304 slot) {
        if (player == null || player.method_31548() == null || player.method_31548().field_7548 == null) {
            return false;
        }
        class_1799 stack = player.method_6118(slot);
        if (stack.method_7960()) {
            return false;
        }
        return switch (slot) {
            case class_1304.field_6169 -> stack.method_31574(ModItems.manasteelHelm);
            case class_1304.field_6174 -> stack.method_31574(ModItems.manasteelChest);
            case class_1304.field_6172 -> stack.method_31574(ModItems.manasteelLegs);
            case class_1304.field_6166 -> stack.method_31574(ModItems.manasteelBoots);
            default -> false;
        };
    }

    private int getSetPiecesEquipped(class_1657 player) {
        int pieces = 0;
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178 || !this.hasArmorSetItem(player, slot)) continue;
            ++pieces;
        }
        return pieces;
    }

    public class_5250 getArmorSetName() {
        return new class_2588("botania.armorset.manasteel.name");
    }

    private class_2561 getArmorSetTitle(class_1657 player) {
        class_5250 end = this.getArmorSetName().method_27693(" (" + this.getSetPiecesEquipped(player) + "/" + this.getArmorSetStacks().length + ")").method_27692(class_124.field_1080);
        return new class_2588("botaniamisc.armorset").method_27693(" ").method_10852((class_2561)end);
    }

    public void addArmorSetDescription(class_1799 stack, List<class_2561> list) {
        list.add((class_2561)new class_2588("botania.armorset.manasteel.desc").method_27692(class_124.field_1080));
    }

    @Override
    public boolean hasPhantomInk(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(class_1799 stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }
}

