/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ItemManaTablet
extends class_1792
implements IManaItem {
    public static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_CREATIVE = "creative";
    private static final String TAG_ONE_USE = "oneUse";

    public ItemManaTablet(class_1792.class_1793 props) {
        super(props);
    }

    public void method_7850(@Nonnull class_1761 tab, @Nonnull class_2371<class_1799> stacks) {
        if (this.method_7877(tab)) {
            stacks.add((Object)new class_1799((class_1935)this));
            class_1799 fullPower = new class_1799((class_1935)this);
            ItemManaTablet.setMana(fullPower, 500000);
            stacks.add((Object)fullPower);
            class_1799 creative = new class_1799((class_1935)this);
            ItemManaTablet.setMana(creative, 500000);
            ItemManaTablet.setStackCreative(creative);
            stacks.add((Object)creative);
        }
    }

    @Nonnull
    public class_1814 method_7862(@Nonnull class_1799 stack) {
        return ItemManaTablet.isStackCreative(stack) ? class_1814.field_8904 : super.method_7862(stack);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
        if (ItemManaTablet.isStackCreative(stack)) {
            stacks.add((class_2561)new class_2588("botaniamisc.creative").method_27692(class_124.field_1080));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    public static void setMana(class_1799 stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    public static void setStackCreative(class_1799 stack) {
        ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
    }

    public static boolean isStackCreative(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
    }

    @Override
    public int getMana(class_1799 stack) {
        if (ItemManaTablet.isStackCreative(stack)) {
            return this.getMaxMana(stack);
        }
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0) * stack.method_7947();
    }

    @Override
    public int getMaxMana(class_1799 stack) {
        return (ItemManaTablet.isStackCreative(stack) ? 501000 : 500000) * stack.method_7947();
    }

    @Override
    public void addMana(class_1799 stack, int mana) {
        if (!ItemManaTablet.isStackCreative(stack)) {
            ItemManaTablet.setMana(stack, Math.min(this.getMana(stack) + mana, this.getMaxMana(stack)) / stack.method_7947());
        }
    }

    @Override
    public boolean canReceiveManaFromPool(class_1799 stack, class_2586 pool) {
        return !ItemNBTHelper.getBoolean(stack, TAG_ONE_USE, false);
    }

    @Override
    public boolean canReceiveManaFromItem(class_1799 stack, class_1799 otherStack) {
        return !ItemManaTablet.isStackCreative(stack);
    }

    @Override
    public boolean canExportManaToPool(class_1799 stack, class_2586 pool) {
        return true;
    }

    @Override
    public boolean canExportManaToItem(class_1799 stack, class_1799 otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(class_1799 stack) {
        return false;
    }

    public boolean method_31567(class_1799 stack) {
        return !ItemManaTablet.isStackCreative(stack);
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(this, stack));
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)(ManaBarTooltip.getFractionForDisplay(this, stack) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

