/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.impl;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.ICorporeaNodeDetector;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.subtile.functional.SubTileSolegnolia;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.relic.ItemLokiRing;

public class BotaniaAPIImpl
implements BotaniaAPI {
    private static final Supplier<class_1814> RELIC_RARITY = Suppliers.memoize(() -> class_1814.field_8904);
    private final Map<class_2960, Function<class_1767, class_2248>> paintableBlocks = new ConcurrentHashMap<class_2960, Function<class_1767, class_2248>>();

    @Override
    public int apiVersion() {
        return 2;
    }

    @Override
    public class_2378<Brew> getBrewRegistry() {
        return ModBrews.registry;
    }

    @Override
    public class_1741 getManasteelArmorMaterial() {
        return ArmorMaterial.MANASTEEL;
    }

    @Override
    public class_1741 getElementiumArmorMaterial() {
        return ArmorMaterial.ELEMENTIUM;
    }

    @Override
    public class_1741 getManaweaveArmorMaterial() {
        return ArmorMaterial.MANAWEAVE;
    }

    @Override
    public class_1741 getTerrasteelArmorMaterial() {
        return ArmorMaterial.TERRASTEEL;
    }

    @Override
    public class_1832 getManasteelItemTier() {
        return ItemTier.MANASTEEL;
    }

    @Override
    public class_1832 getElementiumItemTier() {
        return ItemTier.ELEMENTIUM;
    }

    @Override
    public class_1832 getTerrasteelItemTier() {
        return ItemTier.TERRASTEEL;
    }

    @Override
    public class_1814 getRelicRarity() {
        return RELIC_RARITY.get();
    }

    @Override
    public IManaNetwork getManaNetworkInstance() {
        return ManaNetworkHandler.instance;
    }

    @Override
    public class_1263 getAccessoriesInventory(class_1657 player) {
        return EquipmentHandler.getAllWorn((class_1309)player);
    }

    @Override
    public void breakOnAllCursors(class_1657 player, class_1799 stack, class_2338 pos, class_2350 side) {
        ItemLokiRing.breakOnAllCursors(player, stack, pos, side);
    }

    @Override
    public boolean hasSolegnoliaAround(class_1297 e) {
        return SubTileSolegnolia.hasSolegnoliaAround(e);
    }

    @Override
    public void sparkleFX(class_1937 world, double x, double y, double z, float r, float g, float b, float size, int m) {
        SparkleParticleData data = SparkleParticleData.sparkle(size, r, g, b, m);
        world.method_8406((class_2394)data, x, y, z, 0.0, 0.0, 0.0);
    }

    @Override
    public Map<class_2960, Function<class_1767, class_2248>> getPaintableBlocks() {
        return Collections.unmodifiableMap(this.paintableBlocks);
    }

    @Override
    public void registerPaintableBlock(class_2960 block, Function<class_1767, class_2248> transformer) {
        this.paintableBlocks.put(block, transformer);
    }

    @Override
    public void registerCorporeaNodeDetector(ICorporeaNodeDetector detector) {
        CorporeaNodeDetectors.register(detector);
    }

    private static enum ArmorMaterial implements class_1741
    {
        MANASTEEL("manasteel", 16, new int[]{2, 5, 6, 2}, 18, () -> ModSounds.equipManasteel, () -> ModItems.manaSteel, 0.0f),
        MANAWEAVE("manaweave", 5, new int[]{1, 2, 2, 1}, 18, () -> ModSounds.equipManaweave, () -> ModItems.manaweaveCloth, 0.0f),
        ELEMENTIUM("elementium", 18, new int[]{2, 5, 6, 2}, 18, () -> ModSounds.equipElementium, () -> ModItems.elementium, 0.0f),
        TERRASTEEL("terrasteel", 34, new int[]{3, 6, 8, 3}, 26, () -> ModSounds.equipTerrasteel, () -> ModItems.terrasteel, 3.0f);

        private final String name;
        private final int durabilityMultiplier;
        private final int[] damageReduction;
        private final int enchantability;
        private final Supplier<class_3414> equipSound;
        private final Supplier<class_1792> repairItem;
        private final float toughness;
        private static final int[] MAX_DAMAGE_ARRAY;

        private ArmorMaterial(String name, int durabilityMultiplier, int[] damageReduction, int enchantability, Supplier<class_3414> equipSound, Supplier<class_1792> repairItem, float toughness) {
            this.name = name;
            this.durabilityMultiplier = durabilityMultiplier;
            this.damageReduction = damageReduction;
            this.enchantability = enchantability;
            this.equipSound = equipSound;
            this.repairItem = repairItem;
            this.toughness = toughness;
        }

        public int method_7696(class_1304 slot) {
            return this.durabilityMultiplier * MAX_DAMAGE_ARRAY[slot.method_5927()];
        }

        public int method_7697(class_1304 slot) {
            return this.damageReduction[slot.method_5927()];
        }

        public int method_7699() {
            return this.enchantability;
        }

        @Nonnull
        public class_3414 method_7698() {
            return this.equipSound.get();
        }

        @Nonnull
        public class_1856 method_7695() {
            return class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)this.repairItem.get()});
        }

        @Nonnull
        public String method_7694() {
            return this.name;
        }

        public float method_7700() {
            return this.toughness;
        }

        public float method_24355() {
            return 0.0f;
        }

        static {
            MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
        }
    }

    private static enum ItemTier implements class_1832
    {
        MANASTEEL(300, 6.2f, 2.0f, 3, 20, () -> ModItems.manaSteel),
        ELEMENTIUM(720, 6.2f, 2.0f, 3, 20, () -> ModItems.elementium),
        TERRASTEEL(2300, 9.0f, 3.0f, 4, 26, () -> ModItems.terrasteel);

        private final int maxUses;
        private final float efficiency;
        private final float attackDamage;
        private final int harvestLevel;
        private final int enchantability;
        private final Supplier<class_1792> repairItem;

        private ItemTier(int maxUses, float efficiency, float attackDamage, int harvestLevel, int enchantability, Supplier<class_1792> repairItem) {
            this.maxUses = maxUses;
            this.efficiency = efficiency;
            this.attackDamage = attackDamage;
            this.harvestLevel = harvestLevel;
            this.enchantability = enchantability;
            this.repairItem = repairItem;
        }

        public int method_8025() {
            return this.maxUses;
        }

        public float method_8027() {
            return this.efficiency;
        }

        public float method_8028() {
            return this.attackDamage;
        }

        public int method_8024() {
            return this.harvestLevel;
        }

        public int method_8026() {
            return this.enchantability;
        }

        public class_1856 method_8023() {
            return class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)this.repairItem.get()});
        }
    }
}

