/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;

public final class ItemNBTHelper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public static void set(class_1799 stack, String tag, class_2520 nbt) {
        stack.method_7948().method_10566(tag, nbt);
    }

    public static void setBoolean(class_1799 stack, String tag, boolean b) {
        stack.method_7948().method_10556(tag, b);
    }

    public static void setByte(class_1799 stack, String tag, byte b) {
        stack.method_7948().method_10567(tag, b);
    }

    public static void setShort(class_1799 stack, String tag, short s) {
        stack.method_7948().method_10575(tag, s);
    }

    public static void setInt(class_1799 stack, String tag, int i) {
        stack.method_7948().method_10569(tag, i);
    }

    public static void setIntArray(class_1799 stack, String tag, int[] val) {
        stack.method_7948().method_10539(tag, val);
    }

    public static void setLong(class_1799 stack, String tag, long l) {
        stack.method_7948().method_10544(tag, l);
    }

    public static void setFloat(class_1799 stack, String tag, float f) {
        stack.method_7948().method_10548(tag, f);
    }

    public static void setDouble(class_1799 stack, String tag, double d) {
        stack.method_7948().method_10549(tag, d);
    }

    public static void setCompound(class_1799 stack, String tag, class_2487 cmp) {
        if (!tag.equalsIgnoreCase("ench")) {
            stack.method_7948().method_10566(tag, (class_2520)cmp);
        }
    }

    public static void setString(class_1799 stack, String tag, String s) {
        stack.method_7948().method_10582(tag, s);
    }

    public static void setList(class_1799 stack, String tag, class_2499 list) {
        stack.method_7948().method_10566(tag, (class_2520)list);
    }

    public static void removeEntry(class_1799 stack, String tag) {
        stack.method_7948().method_10551(tag);
    }

    public static boolean verifyExistance(class_1799 stack, String tag) {
        return !stack.method_7960() && stack.method_7985() && stack.method_7948().method_10545(tag);
    }

    @Nullable
    public static class_2520 get(class_1799 stack, String tag) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10580(tag) : null;
    }

    public static boolean getBoolean(class_1799 stack, String tag, boolean defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10577(tag) : defaultExpected;
    }

    public static byte getByte(class_1799 stack, String tag, byte defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10571(tag) : defaultExpected;
    }

    public static short getShort(class_1799 stack, String tag, short defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10568(tag) : defaultExpected;
    }

    public static int getInt(class_1799 stack, String tag, int defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10550(tag) : defaultExpected;
    }

    public static int[] getIntArray(class_1799 stack, String tag) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10561(tag) : EMPTY_INT_ARRAY;
    }

    public static long getLong(class_1799 stack, String tag, long defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10537(tag) : defaultExpected;
    }

    public static float getFloat(class_1799 stack, String tag, float defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10583(tag) : defaultExpected;
    }

    public static double getDouble(class_1799 stack, String tag, double defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10574(tag) : defaultExpected;
    }

    public static class_2487 getCompound(class_1799 stack, String tag, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10562(tag) : (nullifyOnFail ? null : new class_2487());
    }

    public static String getString(class_1799 stack, String tag, String defaultExpected) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10558(tag) : defaultExpected;
    }

    public static class_2499 getList(class_1799 stack, String tag, int objtype, boolean nullifyOnFail) {
        return ItemNBTHelper.verifyExistance(stack, tag) ? stack.method_7948().method_10554(tag, objtype) : (nullifyOnFail ? null : new class_2499());
    }

    public static JsonObject serializeStack(class_1799 stack) {
        class_2487 nbt = stack.method_7953(new class_2487());
        byte c = nbt.method_10571("Count");
        if (c != 1) {
            nbt.method_10567("count", c);
        }
        nbt.method_10551("Count");
        ItemNBTHelper.renameTag(nbt, "id", "item");
        ItemNBTHelper.renameTag(nbt, "tag", "nbt");
        Dynamic dyn = new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static boolean matchTag(@Nullable class_2520 template, @Nullable class_2520 target) {
        if (template instanceof class_2487) {
            class_2487 templateCompound = (class_2487)template;
            if (target instanceof class_2487) {
                class_2487 targetCompound = (class_2487)target;
                return ItemNBTHelper.matchTagCompound(templateCompound, targetCompound);
            }
        }
        if (template instanceof class_2499) {
            class_2499 templateList = (class_2499)template;
            if (target instanceof class_2499) {
                class_2499 targetList = (class_2499)target;
                return ItemNBTHelper.matchTagList(templateList, targetList);
            }
        }
        return template == null || target != null && target.equals(template);
    }

    private static boolean matchTagCompound(class_2487 template, class_2487 target) {
        if (template.method_10546() > target.method_10546()) {
            return false;
        }
        for (String key : template.method_10541()) {
            if (ItemNBTHelper.matchTag(template.method_10580(key), target.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean matchTagList(class_2499 template, class_2499 target) {
        if (template.size() > target.size()) {
            return false;
        }
        for (int i = 0; i < template.size(); ++i) {
            if (ItemNBTHelper.matchTag(template.method_10534(i), target.method_10534(i))) continue;
            return false;
        }
        return true;
    }

    public static void renameTag(class_2487 nbt, String oldName, String newName) {
        class_2520 tag = nbt.method_10580(oldName);
        if (tag != null) {
            nbt.method_10551(oldName);
            nbt.method_10566(newName, tag);
        }
    }
}

