/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class RecipeManaInfusion
implements IManaInfusionRecipe {
    private final class_2960 id;
    private final class_1799 output;
    private final class_1856 input;
    private final int mana;
    @Nullable
    private final StateIngredient catalyst;
    private final String group;

    public RecipeManaInfusion(class_2960 id, class_1799 output, class_1856 input, int mana, @Nullable String group, @Nullable StateIngredient catalyst) {
        Preconditions.checkArgument((mana > 0 ? 1 : 0) != 0, (Object)"Mana cost must be positive");
        Preconditions.checkArgument((mana <= 1000001 ? 1 : 0) != 0, (Object)"Mana cost must be at most a pool");
        this.id = id;
        this.output = output;
        this.input = input;
        this.mana = mana;
        this.group = group == null ? "" : group;
        this.catalyst = catalyst;
    }

    @Deprecated
    public RecipeManaInfusion(class_2960 id, class_1799 output, class_1856 input, int mana, @Nullable String group, @Nullable class_2680 catalystState) {
        this(id, output, input, mana, group, StateIngredientHelper.of(catalystState));
    }

    @Nonnull
    public final class_2960 method_8114() {
        return this.id;
    }

    @Nonnull
    public class_1865<RecipeManaInfusion> method_8119() {
        return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
    }

    @Override
    public boolean matches(class_1799 stack) {
        return this.input.method_8093(stack);
    }

    @Override
    public StateIngredient getRecipeCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getManaToConsume() {
        return this.mana;
    }

    @Override
    @Nonnull
    public class_1799 method_8110() {
        return this.output;
    }

    @Nonnull
    public class_2371<class_1856> method_8117() {
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.input});
    }

    @Nonnull
    public String method_8112() {
        return this.group;
    }

    @Nonnull
    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.manaPool);
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeManaInfusion> {
        @Nonnull
        public RecipeManaInfusion fromJson(@Nonnull class_2960 id, @Nonnull JsonObject json) {
            JsonElement input = Objects.requireNonNull(json.get("input"));
            class_1856 ing = class_1856.method_8102((JsonElement)input);
            class_1799 output = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"output"));
            int mana = class_3518.method_15260((JsonObject)json, (String)"mana");
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            StateIngredient catalyst = null;
            if (json.has("catalyst")) {
                JsonElement element = json.get("catalyst");
                if (!element.isJsonObject() || !element.getAsJsonObject().has("type")) {
                    throw new JsonParseException("Legacy mana infusion catalyst syntax used");
                }
                catalyst = StateIngredientHelper.deserialize(element.getAsJsonObject());
            }
            return new RecipeManaInfusion(id, output, ing, mana, group, catalyst);
        }

        @Nullable
        public RecipeManaInfusion fromNetwork(@Nonnull class_2960 id, @Nonnull class_2540 buf) {
            class_1856 input = class_1856.method_8086((class_2540)buf);
            class_1799 output = buf.method_10819();
            int mana = buf.method_10816();
            StateIngredient catalyst = null;
            if (buf.readBoolean()) {
                catalyst = StateIngredientHelper.read(buf);
            }
            String group = buf.method_19772();
            return new RecipeManaInfusion(id, output, input, mana, group, catalyst);
        }

        public void toNetwork(@Nonnull class_2540 buf, @Nonnull RecipeManaInfusion recipe) {
            ((class_1856)recipe.method_8117().get(0)).method_8088(buf);
            buf.method_10793(recipe.method_8110());
            buf.method_10804(recipe.getManaToConsume());
            boolean hasCatalyst = recipe.getRecipeCatalyst() != null;
            buf.writeBoolean(hasCatalyst);
            if (hasCatalyst) {
                recipe.getRecipeCatalyst().write(buf);
            }
            buf.method_10814(recipe.method_8112());
        }
    }
}

