/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class RecipeBrew
implements IBrewRecipe {
    private final class_2960 id;
    private final Brew brew;
    private final class_2371<class_1856> inputs;

    public RecipeBrew(class_2960 id, Brew brew, class_1856 ... inputs) {
        this.id = id;
        this.brew = brew;
        this.inputs = class_2371.method_10212((Object)class_1856.field_9017, (Object[])inputs);
    }

    public boolean method_8115(class_1263 inv, @Nonnull class_1937 world) {
        class_1799 stack;
        ArrayList<class_1856> inputsMissing = new ArrayList<class_1856>((Collection<class_1856>)this.inputs);
        for (int i = 0; i < inv.method_5439() && !(stack = inv.method_5438(i)).method_7960(); ++i) {
            if (stack.method_7909() instanceof IBrewContainer) continue;
            boolean matchedOne = false;
            Iterator iter = inputsMissing.iterator();
            while (iter.hasNext()) {
                class_1856 input = (class_1856)iter.next();
                if (!input.method_8093(stack)) continue;
                iter.remove();
                matchedOne = true;
                break;
            }
            if (matchedOne) continue;
            return false;
        }
        return inputsMissing.isEmpty();
    }

    @Nonnull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    @Nonnull
    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.brewery);
    }

    @Nonnull
    public class_2960 method_8114() {
        return this.id;
    }

    @Nonnull
    public class_1865<?> method_8119() {
        return ModRecipeTypes.BREW_SERIALIZER;
    }

    @Override
    public Brew getBrew() {
        return this.brew;
    }

    @Override
    public int getManaUsage() {
        return this.brew.getManaCost();
    }

    @Override
    public class_1799 getOutput(class_1799 stack) {
        class_1792 class_17922;
        if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof IBrewContainer)) {
            return new class_1799((class_1935)class_1802.field_8469);
        }
        IBrewContainer container = (IBrewContainer)class_17922;
        return container.getItemForBrew(this.brew, stack);
    }

    public int hashCode() {
        return 31 * this.brew.hashCode() ^ this.inputs.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RecipeBrew && this.brew == ((RecipeBrew)o).brew && this.inputs.equals(((RecipeBrew)o).inputs);
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeBrew> {
        @Nonnull
        public RecipeBrew fromJson(@Nonnull class_2960 id, @Nonnull JsonObject json) {
            String brewStr = class_3518.method_15265((JsonObject)json, (String)"brew");
            class_2960 brewId = class_2960.method_12829((String)brewStr);
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().method_17966(brewId).orElseThrow(() -> new JsonParseException("Unknown brew " + brewStr));
            JsonArray ingrs = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            ArrayList<class_1856> inputs = new ArrayList<class_1856>();
            for (JsonElement e : ingrs) {
                inputs.add(class_1856.method_8102((JsonElement)e));
            }
            return new RecipeBrew(id, brew, inputs.toArray(new class_1856[0]));
        }

        public RecipeBrew fromNetwork(@Nonnull class_2960 id, @Nonnull class_2540 buf) {
            class_2960 brewId = buf.method_10810();
            Brew brew = (Brew)BotaniaAPI.instance().getBrewRegistry().method_10223(brewId);
            class_1856[] inputs = new class_1856[buf.method_10816()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = class_1856.method_8086((class_2540)buf);
            }
            return new RecipeBrew(id, brew, inputs);
        }

        public void toNetwork(@Nonnull class_2540 buf, @Nonnull RecipeBrew recipe) {
            class_2960 brewId = BotaniaAPI.instance().getBrewRegistry().method_10221((Object)recipe.getBrew());
            buf.method_10812(brewId);
            buf.method_10804(recipe.method_8117().size());
            for (class_1856 input : recipe.method_8117()) {
                input.method_8088(buf);
            }
        }
    }
}

