/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockSavedData;
import vazkii.botania.common.world.SkyblockWorldEvents;

public class SkyblockCommand {
    private static final SimpleCommandExceptionType NOT_SKYBLOCK_WORLD = new SimpleCommandExceptionType((Message)new class_2588("botaniamisc.command.skyblock.world"));
    private static final SimpleCommandExceptionType NO_ISLAND = new SimpleCommandExceptionType((Message)new class_2588("botaniamisc.command.skyblock.noisland"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder commandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"botania-skyblock").requires(s -> s.method_9259(2))).then(class_2170.method_9247((String)"help").executes(SkyblockCommand::printHelp))).then(class_2170.method_9247((String)"island").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(SkyblockCommand::createIsland)))).then(class_2170.method_9247((String)"spawn").executes(SkyblockCommand::teleportToSpawn))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"visit").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> SkyblockCommand.teleportToIsland((CommandContext<class_2168>)ctx, (class_1657)class_2186.method_9315((CommandContext)ctx, (String)"player"))))).then(class_2170.method_9244((String)"playerUuid", (ArgumentType)class_5242.method_27643()).suggests((ctx, builder) -> class_2172.method_9264(SkyblockSavedData.get((class_3218)((class_2168)ctx.getSource()).method_9225()).skyblocks.values().stream().map(UUID::toString), (SuggestionsBuilder)builder)).executes(ctx -> SkyblockCommand.teleportToIsland((CommandContext<class_2168>)ctx, class_5242.method_27645((CommandContext)ctx, (String)"playerUuid")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"regen-island").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(ctx -> SkyblockCommand.rebuildIsland((CommandContext<class_2168>)ctx, class_2186.method_9315((CommandContext)ctx, (String)"player"))))).then(class_2170.method_9244((String)"playerUuid", (ArgumentType)class_5242.method_27643()).suggests((ctx, builder) -> class_2172.method_9264(SkyblockSavedData.get((class_3218)((class_2168)ctx.getSource()).method_9225()).skyblocks.values().stream().map(UUID::toString), (SuggestionsBuilder)builder)).executes(ctx -> SkyblockCommand.rebuildIsland((CommandContext<class_2168>)ctx, class_5242.method_27645((CommandContext)ctx, (String)"playerUuid")))));
        LiteralCommandNode command = dispatcher.register(commandBuilder);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"gardenofglass").redirect((CommandNode)command));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"gog").redirect((CommandNode)command));
    }

    private static int printHelp(CommandContext<class_2168> ctx) {
        for (int i = 0; i < 5; ++i) {
            ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("botaniamisc.command.skyblock.help." + i), false);
        }
        return 1;
    }

    private static int doTeleportToIsland(CommandContext<class_2168> ctx, UUID owner, class_2561 feedback) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        return SkyblockCommand.doTeleportToIsland(ctx, player, owner, feedback);
    }

    private static int doTeleportToIsland(CommandContext<class_2168> ctx, class_3222 player, UUID owner, class_2561 feedback) throws CommandSyntaxException {
        class_3218 world = SkyblockCommand.getSkyblockWorld(ctx);
        IslandPos pos = SkyblockCommand.getIslandForUUID(owner, SkyblockSavedData.get(world));
        class_2338 blockPos = pos.getCenter();
        player.method_14251(world, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
        ((class_2168)ctx.getSource()).method_9226(feedback, true);
        return 1;
    }

    private static int createIsland(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(ctx, (String)"player");
        SkyblockSavedData data = SkyblockSavedData.get(SkyblockCommand.getSkyblockWorld(ctx));
        UUID uuid = player.method_5667();
        if (data.skyblocks.containsValue((Object)uuid)) {
            SkyblockCommand.doTeleportToIsland(ctx, player, uuid, (class_2561)new class_2588("botaniamisc.command.skyblock.island.teleported", new Object[]{((class_2168)ctx.getSource()).method_9223()}));
            return 1;
        }
        SkyblockWorldEvents.spawnPlayer((class_1657)player, data.create(uuid));
        ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("botaniamisc.command.skyblock.island.success", new Object[]{player.method_5476()}), true);
        return 1;
    }

    private static int doRebuildIsland(CommandContext<class_2168> ctx, UUID player, class_2561 feedback) throws CommandSyntaxException {
        class_3218 world = SkyblockCommand.getSkyblockWorld(ctx);
        IslandPos pos = SkyblockCommand.getIslandForUUID(player, SkyblockSavedData.get(world));
        SkyblockWorldEvents.createSkyblock(world, pos.getCenter());
        ((class_2168)ctx.getSource()).method_9226(feedback, true);
        return 1;
    }

    private static IslandPos getIslandForUUID(UUID player, SkyblockSavedData data) throws CommandSyntaxException {
        IslandPos pos = (IslandPos)data.skyblocks.inverse().get((Object)player);
        if (pos == null) {
            throw NO_ISLAND.create();
        }
        return pos;
    }

    private static class_3218 getSkyblockWorld(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        if (!SkyblockChunkGenerator.isWorldSkyblock((class_1937)world)) {
            throw NOT_SKYBLOCK_WORLD.create();
        }
        return world;
    }

    private static int teleportToIsland(CommandContext<class_2168> ctx, class_1657 owner) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, owner.method_5667(), (class_2561)new class_2588("botaniamisc.command.skyblock.teleport.success", new Object[]{((class_2168)ctx.getSource()).method_9223(), owner.method_5477()}));
    }

    private static int teleportToIsland(CommandContext<class_2168> ctx, UUID owner) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, owner, (class_2561)new class_2588("botaniamisc.command.skyblock.teleport.success", new Object[]{((class_2168)ctx.getSource()).method_9223(), owner}));
    }

    private static int teleportToSpawn(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return SkyblockCommand.doTeleportToIsland(ctx, class_156.field_25140, (class_2561)new class_2588("botaniamisc.command.skyblock.spawn.success", new Object[]{((class_2168)ctx.getSource()).method_9223()}));
    }

    private static int rebuildIsland(CommandContext<class_2168> ctx, class_3222 owner) throws CommandSyntaxException {
        return SkyblockCommand.doRebuildIsland(ctx, owner.method_5667(), (class_2561)new class_2588("botaniamisc.command.skyblock.regenisland.success", new Object[]{owner.method_5476()}));
    }

    private static int rebuildIsland(CommandContext<class_2168> ctx, UUID owner) throws CommandSyntaxException {
        return SkyblockCommand.doRebuildIsland(ctx, owner, (class_2561)new class_2588("botaniamisc.command.skyblock.regenisland.success", new Object[]{owner}));
    }
}

