/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IManaDissolvable;
import vazkii.botania.api.mana.IKeyLocked;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.IThrottledPacket;
import vazkii.botania.common.block.tile.mana.TileBellows;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.proxy.IProxy;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class TilePool
extends TileMod
implements IManaPool,
IKeyLocked,
ISparkAttachable,
IThrottledPacket,
IWandable {
    public static final int PARTICLE_COLOR = 50943;
    public static final int MAX_MANA = 1000000;
    private static final int MAX_MANA_DILLUTED = 10000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_OUTPUTTING = "outputting";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA_CAP = "manaCap";
    private static final String TAG_CAN_ACCEPT = "canAccept";
    private static final String TAG_CAN_SPARE = "canSpare";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    private boolean outputting = false;
    private class_1767 color = class_1767.field_7952;
    private int mana;
    public int manaCap = -1;
    private int soundTicks = 0;
    private boolean canAccept = true;
    private boolean canSpare = true;
    boolean isDoingTransfer = false;
    int ticksDoingTransfer = 0;
    private String inputKey = "";
    private final String outputKey = "";
    private int ticks = 0;
    private boolean sendPacket = false;

    public TilePool(class_2338 pos, class_2680 state) {
        super(ModTiles.POOL, pos, state);
    }

    @Override
    public boolean isFull() {
        class_2680 stateBelow = this.field_11863.method_8320(this.field_11867.method_10074());
        return !stateBelow.method_27852(ModBlocks.manaVoid) && this.getCurrentMana() >= this.manaCap;
    }

    @Override
    public void receiveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.manaCap));
        if (old != this.mana) {
            this.method_5431();
            this.markDispatchable();
        }
    }

    public void method_11012() {
        super.method_11012();
        IXplatAbstractions.INSTANCE.fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
    }

    public static int calculateComparatorLevel(int mana, int max) {
        int val = (int)((double)mana / (double)max * 15.0);
        if (mana > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    public static List<IManaInfusionRecipe> manaInfusionRecipes(class_1937 world) {
        return ModRecipeTypes.getRecipes(world, ModRecipeTypes.MANA_INFUSION_TYPE).values().stream().filter(r -> r instanceof IManaInfusionRecipe).map(r -> (IManaInfusionRecipe)r).collect(Collectors.toList());
    }

    public IManaInfusionRecipe getMatchingRecipe(@Nonnull class_1799 stack, @Nonnull class_2680 state) {
        ArrayList<IManaInfusionRecipe> matchingNonCatRecipes = new ArrayList<IManaInfusionRecipe>();
        ArrayList<IManaInfusionRecipe> matchingCatRecipes = new ArrayList<IManaInfusionRecipe>();
        for (IManaInfusionRecipe recipe : TilePool.manaInfusionRecipes(this.field_11863)) {
            if (!recipe.matches(stack)) continue;
            if (recipe.getRecipeCatalyst() == null) {
                matchingNonCatRecipes.add(recipe);
                continue;
            }
            if (!recipe.getRecipeCatalyst().test(state)) continue;
            matchingCatRecipes.add(recipe);
        }
        return !matchingCatRecipes.isEmpty() ? (IManaInfusionRecipe)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (IManaInfusionRecipe)matchingNonCatRecipes.get(0) : null);
    }

    public boolean collideEntityItem(class_1542 item) {
        if (this.field_11863.field_9236 || !item.method_5805() || item.method_6983().method_7960()) {
            return false;
        }
        class_1799 stack = item.method_6983();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IManaDissolvable) {
            IManaDissolvable dissolvable = (IManaDissolvable)class_17922;
            dissolvable.onDissolveTick(this, stack, item);
        }
        if (IXplatAbstractions.INSTANCE.itemFlagsComponent(item).getManaInfusionCooldown() > 0) {
            return false;
        }
        IManaInfusionRecipe recipe = this.getMatchingRecipe(stack, this.field_11863.method_8320(this.field_11867.method_10074()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.receiveMana(-mana);
                class_1799 output = recipe.getRecipeOutput(stack);
                stack.method_7934(1);
                item.method_24830(false);
                class_1542 outputItem = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, output);
                IXplatAbstractions.INSTANCE.itemFlagsComponent(outputItem).markNewlyInfused();
                this.field_11863.method_8649((class_1297)outputItem);
                this.craftingFanciness();
                return true;
            }
        }
        return false;
    }

    private void craftingFanciness() {
        if (this.soundTicks == 0) {
            this.field_11863.method_8396(null, this.field_11867, ModSounds.manaPoolCraft, class_3419.field_15245, 1.0f, 1.0f);
            this.soundTicks = 6;
        }
        this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 0, 0);
    }

    public boolean method_11004(int event, int param) {
        switch (event) {
            case 0: {
                if (this.field_11863.field_9236) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_11863.method_8406((class_2394)data, (double)this.field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.field_11867.method_10264() + 0.75, (double)this.field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
            case 1: {
                if (this.field_11863.field_9236 && BotaniaConfig.common().chargingAnimationEnabled()) {
                    boolean outputting = param == 1;
                    class_243 itemVec = class_243.method_24954((class_2382)this.field_11867).method_1031(0.5, 0.5 + Math.random() * 0.3, 0.5);
                    class_243 tileVec = class_243.method_24954((class_2382)this.field_11867).method_1031(0.2 + Math.random() * 0.6, 0.0, 0.2 + Math.random() * 0.6);
                    IProxy.INSTANCE.lightningFX(outputting ? tileVec : itemVec, outputting ? itemVec : tileVec, 80.0f, this.field_11863.field_9229.nextLong(), 1140881820, 1140901631);
                }
                return true;
            }
        }
        return super.method_11004(event, param);
    }

    private void initManaCapAndNetwork() {
        if (this.manaCap == -1) {
            int n = this.manaCap = ((BlockPool)this.method_11010().method_26204()).variant == BlockPool.Variant.DILUTED ? 10000 : 1000000;
        }
        if (!ManaNetworkHandler.instance.isPoolIn(this) && !this.method_11015()) {
            IXplatAbstractions.INSTANCE.fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, TilePool self) {
        self.initManaCapAndNetwork();
        double particleChance = 1.0 - (double)self.getCurrentMana() / (double)self.manaCap * 0.1;
        if (Math.random() > particleChance) {
            float red = 0.0f;
            float green = 0.7764706f;
            float blue = 1.0f;
            WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, red, green, blue, 2.0f);
            level.method_8406((class_2394)data, (double)worldPosition.method_10263() + 0.3 + Math.random() * 0.5, (double)worldPosition.method_10264() + 0.6 + Math.random() * 0.25, (double)worldPosition.method_10260() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
        }
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, TilePool self) {
        self.initManaCapAndNetwork();
        boolean wasDoingTransfer = self.isDoingTransfer;
        self.isDoingTransfer = false;
        if (self.soundTicks > 0) {
            --self.soundTicks;
        }
        if (self.sendPacket && self.ticks % 10 == 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            self.sendPacket = false;
        }
        List items = level.method_18467(class_1542.class, new class_238(worldPosition, worldPosition.method_10069(1, 1, 1)));
        for (class_1542 item : items) {
            class_1792 class_17922;
            class_1799 stack;
            if (!item.method_5805() || (stack = item.method_6983()).method_7960() || !((class_17922 = stack.method_7909()) instanceof IManaItem)) continue;
            IManaItem mana = (IManaItem)class_17922;
            if ((!self.outputting || !mana.canReceiveManaFromPool(stack, self)) && (self.outputting || !mana.canExportManaToPool(stack, self))) continue;
            boolean didSomething = false;
            int bellowCount = 0;
            if (self.outputting) {
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                    TileBellows bellows;
                    class_2586 tile = level.method_8321(worldPosition.method_10093(dir));
                    if (!(tile instanceof TileBellows) || (bellows = (TileBellows)tile).getLinkedTile() != self) continue;
                    ++bellowCount;
                }
            }
            int transfRate = 1000 * (bellowCount + 1);
            if (self.outputting) {
                if (self.canSpare) {
                    if (self.getCurrentMana() > 0 && mana.getMana(stack) < mana.getMaxMana(stack)) {
                        didSomething = true;
                    }
                    int manaVal = Math.min(transfRate, Math.min(self.getCurrentMana(), mana.getMaxMana(stack) - mana.getMana(stack)));
                    mana.addMana(stack, manaVal);
                    self.receiveMana(-manaVal);
                }
            } else if (self.canAccept) {
                int manaVal;
                if (mana.getMana(stack) > 0 && !self.isFull()) {
                    didSomething = true;
                }
                if ((manaVal = Math.min(transfRate, Math.min(self.manaCap - self.getCurrentMana(), mana.getMana(stack)))) == 0 && self.field_11863.method_8320(worldPosition.method_10074()).method_27852(ModBlocks.manaVoid)) {
                    manaVal = Math.min(transfRate, mana.getMana(stack));
                }
                mana.addMana(stack, -manaVal);
                self.receiveMana(manaVal);
            }
            if (!didSomething) continue;
            if (BotaniaConfig.common().chargingAnimationEnabled() && level.field_9229.nextInt(20) == 0) {
                level.method_8427(worldPosition, state.method_26204(), 1, self.outputting ? 1 : 0);
            }
            self.isDoingTransfer = self.outputting;
        }
        if (self.isDoingTransfer) {
            ++self.ticksDoingTransfer;
        } else {
            self.ticksDoingTransfer = 0;
            if (wasDoingTransfer) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        }
        ++self.ticks;
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_MANA, this.mana);
        cmp.method_10556(TAG_OUTPUTTING, this.outputting);
        cmp.method_10569(TAG_COLOR, this.color.method_7789());
        cmp.method_10569(TAG_MANA_CAP, this.manaCap);
        cmp.method_10556(TAG_CAN_ACCEPT, this.canAccept);
        cmp.method_10556(TAG_CAN_SPARE, this.canSpare);
        cmp.method_10582(TAG_INPUT_KEY, this.inputKey);
        cmp.method_10582(TAG_OUTPUT_KEY, "");
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.mana = cmp.method_10550(TAG_MANA);
        this.outputting = cmp.method_10577(TAG_OUTPUTTING);
        this.color = class_1767.method_7791((int)cmp.method_10550(TAG_COLOR));
        if (cmp.method_10545(TAG_MANA_CAP)) {
            this.manaCap = cmp.method_10550(TAG_MANA_CAP);
        }
        if (cmp.method_10545(TAG_CAN_ACCEPT)) {
            this.canAccept = cmp.method_10577(TAG_CAN_ACCEPT);
        }
        if (cmp.method_10545(TAG_CAN_SPARE)) {
            this.canSpare = cmp.method_10577(TAG_CAN_SPARE);
        }
        if (cmp.method_10545(TAG_INPUT_KEY)) {
            this.inputKey = cmp.method_10558(TAG_INPUT_KEY);
        }
        if (cmp.method_10545(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.method_10558(TAG_OUTPUT_KEY);
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (player == null || player.method_5715()) {
            this.outputting = !this.outputting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public int getCurrentMana() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof BlockPool) {
            BlockPool pool = (BlockPool)class_22482;
            return pool.variant == BlockPool.Variant.CREATIVE ? 1000000 : this.mana;
        }
        return 0;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canAttachSpark(class_1799 stack) {
        return true;
    }

    @Override
    public IManaSpark getAttachedSpark() {
        List sparks = this.field_11863.method_8390(class_1297.class, new class_238(this.field_11867.method_10084(), this.field_11867.method_10084().method_10069(1, 1, 1)), (Predicate)Predicates.instanceOf(IManaSpark.class));
        if (sparks.size() == 1) {
            class_1297 e = (class_1297)sparks.get(0);
            return (IManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int getAvailableSpaceForMana() {
        int space = Math.max(0, this.manaCap - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        if (this.field_11863.method_8320(this.field_11867.method_10074()).method_27852(ModBlocks.manaVoid)) {
            return this.manaCap;
        }
        return 0;
    }

    @Override
    public class_1767 getColor() {
        return this.color;
    }

    @Override
    public void setColor(class_1767 color) {
        this.color = color;
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
    }

    @Override
    public void markDispatchable() {
        this.sendPacket = true;
    }

    public static class WandHud
    implements IWandHUD {
        private final TilePool pool;

        public WandHud(TilePool pool) {
            this.pool = pool;
        }

        @Override
        public void renderHUD(class_4587 ms, class_310 mc) {
            class_1799 poolStack = new class_1799((class_1935)this.pool.method_11010().method_26204());
            String name = poolStack.method_7964().getString();
            int color = 0x4444FF;
            BotaniaAPIClient.instance().drawSimpleManaHUD(ms, color, this.pool.getCurrentMana(), this.pool.manaCap, name);
            int x = class_310.method_1551().method_22683().method_4486() / 2 - 11;
            int y = class_310.method_1551().method_22683().method_4502() / 2 + 30;
            int u = this.pool.outputting ? 22 : 0;
            int v = 38;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShaderTexture((int)0, (class_2960)HUDHandler.manaBar);
            RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_1799 tablet = new class_1799((class_1935)ModItems.manaTablet);
            ItemManaTablet.setStackCreative(tablet);
            mc.method_1480().method_4023(tablet, x - 20, y);
            mc.method_1480().method_4023(poolStack, x + 26, y);
            RenderSystem.disableBlend();
        }
    }
}

