/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaResult;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.ModStats;
import vazkii.botania.common.advancements.CorporeaRequestTrigger;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileCorporeaIndex
extends TileCorporeaBase
implements ICorporeaRequestor {
    public static final double RADIUS = 2.5;
    public static final int MAX_REQUEST = 65536;
    private static InputHandler input;
    private static final Set<TileCorporeaIndex> serverIndexes;
    private static final Set<TileCorporeaIndex> clientIndexes;
    private static final Map<Pattern, IRegexStacker> patterns;
    public int ticksWithCloseby = 0;
    public float closeby = 0.0f;
    public boolean hasCloseby;

    public TileCorporeaIndex(class_2338 pos, class_2680 state) {
        super(ModTiles.CORPOREA_INDEX, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileCorporeaIndex self) {
        double x = (double)worldPosition.method_10263() + 0.5;
        double y = (double)worldPosition.method_10264() + 0.5;
        double z = (double)worldPosition.method_10260() + 0.5;
        List players = level.method_18467(class_1657.class, new class_238(x - 2.5, y - 2.5, z - 2.5, x + 2.5, y + 2.5, z + 2.5));
        self.hasCloseby = false;
        for (class_1657 player : players) {
            if (!TileCorporeaIndex.isInRangeOfIndex(player, self)) continue;
            self.hasCloseby = true;
            break;
        }
        float step = 0.2f;
        if (self.hasCloseby) {
            ++self.ticksWithCloseby;
            if (self.closeby < 1.0f) {
                self.closeby += step;
            }
        } else if (self.closeby > 0.0f) {
            self.closeby -= step;
        }
        if (!self.method_11015()) {
            TileCorporeaIndex.addIndex(self);
        }
    }

    public void method_11012() {
        super.method_11012();
        TileCorporeaIndex.removeIndex(this);
    }

    @Override
    public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
        this.doRequest(request, count, spark);
    }

    private ICorporeaResult doRequest(ICorporeaRequestMatcher matcher, int count, ICorporeaSpark spark) {
        ICorporeaResult result = CorporeaHelper.instance().requestItem(matcher, count, spark, true);
        List<class_1799> stacks = result.getStacks();
        spark.onItemsRequested(stacks);
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, stack);
            this.field_11863.method_8649((class_1297)item);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInRangeOfIndex(class_1657 player, TileCorporeaIndex index) {
        if (player.field_6002.method_27983() != index.field_11863.method_27983()) return false;
        if (!((double)MathHelper.pointDistancePlane((double)index.method_11016().method_10263() + 0.5, (double)index.method_11016().method_10260() + 0.5, player.method_23317(), player.method_23321()) < 2.5)) return false;
        double d = (double)index.method_11016().method_10264() + 0.5 - player.method_23318();
        double d2 = player.field_6002.field_9236 ? 0.0 : 1.6;
        if (!(Math.abs(d + d2) < 5.0)) return false;
        return true;
    }

    public static void addPattern(String pattern, IRegexStacker stacker) {
        patterns.put(Pattern.compile(pattern), stacker);
    }

    public static int i(Matcher m, int g) {
        try {
            int i = Math.abs(Integer.parseInt(m.group(g)));
            return i;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static InputHandler getInputHandler() {
        if (input == null) {
            input = new InputHandler();
        }
        return input;
    }

    private static void addIndex(TileCorporeaIndex index) {
        Set<TileCorporeaIndex> set = index.field_11863.field_9236 ? clientIndexes : serverIndexes;
        set.add(index);
    }

    private static void removeIndex(TileCorporeaIndex index) {
        Set<TileCorporeaIndex> set = index.field_11863.field_9236 ? clientIndexes : serverIndexes;
        set.remove(index);
    }

    public static void clearIndexCache() {
        clientIndexes.clear();
        serverIndexes.clear();
    }

    public void performPlayerRequest(class_3222 player, ICorporeaRequestMatcher request, int count) {
        if (!IXplatAbstractions.INSTANCE.fireCorporeaIndexRequestEvent(player, request, count, this.getSpark())) {
            ICorporeaResult res = this.doRequest(request, count, this.getSpark());
            player.method_9203((class_2561)new class_2588("botaniamisc.requestMsg", new Object[]{count, request.getRequestName(), res.getMatchedCount(), res.getExtractedCount()}).method_27692(class_124.field_1076), class_156.field_25140);
            player.method_7339(ModStats.CORPOREA_ITEMS_REQUESTED, res.getExtractedCount());
            CorporeaRequestTrigger.INSTANCE.trigger(player, player.method_14220(), this.method_11016(), res.getExtractedCount());
        }
    }

    static {
        serverIndexes = Collections.newSetFromMap(new WeakHashMap());
        clientIndexes = Collections.newSetFromMap(new WeakHashMap());
        patterns = new LinkedHashMap<Pattern, IRegexStacker>();
        TileCorporeaIndex.addPattern("(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("a??n?? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 1;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?stack (?:(?:and)|(?:\\+)) (\\d+)(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 + TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? stacks? (?:(?:and)|(?:\\+)) (\\d+)x?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 64 * TileCorporeaIndex.i(m, 1) + TileCorporeaIndex.i(m, 2);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(3);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?half (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 32;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?quarter (?:of )?(?:a )?stack(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 16;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?dozen(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? dozens?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 12 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:all|every) (?:(?:of|the) )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 65536;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:the )?answer to life,? the universe and everything (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 42;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(?:a )?nice (?:of )?(.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
        TileCorporeaIndex.addPattern("(\\d+)x?? nices?(?: of)? (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 69 * TileCorporeaIndex.i(m, 1);
            }

            @Override
            public String getName(Matcher m) {
                return m.group(2);
            }
        });
        TileCorporeaIndex.addPattern("(?:count|show|display|tell) (.+)", new IRegexStacker(){

            @Override
            public int getCount(Matcher m) {
                return 0;
            }

            @Override
            public String getName(Matcher m) {
                return m.group(1);
            }
        });
    }

    public static final class InputHandler {
        public boolean onChatMessage(class_3222 player, String message) {
            if (player.method_7325()) {
                return false;
            }
            List<TileCorporeaIndex> nearbyIndexes = InputHandler.getNearbyIndexes((class_1657)player);
            if (!nearbyIndexes.isEmpty()) {
                String msg = message.toLowerCase(Locale.ROOT).trim();
                for (TileCorporeaIndex index : nearbyIndexes) {
                    class_1799 stack;
                    ICorporeaSpark spark = index.getSpark();
                    if (spark == null) continue;
                    String name = "";
                    int count = 0;
                    for (Pattern pattern : patterns.keySet()) {
                        Matcher matcher = pattern.matcher(msg);
                        if (!matcher.matches()) continue;
                        IRegexStacker stacker = patterns.get(pattern);
                        count = Math.min(65536, stacker.getCount(matcher));
                        name = stacker.getName(matcher).toLowerCase(Locale.ROOT).trim();
                    }
                    if (name.equals("this") && !(stack = player.method_6047()).method_7960()) {
                        name = stack.method_7964().getString().toLowerCase(Locale.ROOT).trim();
                    }
                    index.performPlayerRequest(player, CorporeaHelper.instance().createMatcher(name), count);
                }
                return true;
            }
            return false;
        }

        public static List<TileCorporeaIndex> getNearbyIndexes(class_1657 player) {
            return (player.field_6002.field_9236 ? clientIndexes : serverIndexes).stream().filter(i -> TileCorporeaIndex.isInRangeOfIndex(player, i)).collect(Collectors.toList());
        }
    }

    public static interface IRegexStacker {
        public int getCount(Matcher var1);

        public String getName(Matcher var1);
    }
}

