/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileAltar
extends TileSimpleInventory
implements IPetalApothecary {
    private static final Pattern SEED_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)seed)|(?:(?:[a-z-_.:]|^)Seed))(?:[sA-Z-_.:]|$)");
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int CRAFT_EFFECT_EVENT = 1;
    public static final String ITEM_TAG_APOTHECARY_SPAWNED = "ApothecarySpawned";
    private List<class_1799> lastRecipe = null;
    private int recipeKeepTicks = 0;

    public TileAltar(class_2338 pos, class_2680 state) {
        super(ModTiles.ALTAR, pos, state);
    }

    public boolean collideEntityItem(class_1542 item) {
        class_1799 stack = item.method_6983();
        if (this.field_11863.field_9236 || stack.method_7960() || !item.method_5805()) {
            return false;
        }
        if (this.method_11010().method_27852(ModBlocks.defaultAltar) && stack.method_31574(class_2246.field_10597.method_8389())) {
            class_2487 tmp = new class_2487();
            this.writePacketNBT(tmp);
            stack.method_7934(1);
            this.field_11863.method_8501(this.method_11016(), ModBlocks.mossyAltar.method_9564());
            class_2586 newAltar = this.field_11863.method_8321(this.method_11016());
            if (newAltar instanceof TileAltar) {
                TileAltar altar = (TileAltar)newAltar;
                altar.readPacketNBT(tmp);
            }
            return true;
        }
        if (this.getFluid() == IPetalApothecary.State.EMPTY) {
            class_1785 bucketItem;
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof class_1785 && IXplatAbstractions.INSTANCE.getBucketFluid((class_1755)(bucketItem = (class_1785)class_17922)) == class_3612.field_15910) {
                this.setFluid(IPetalApothecary.State.WATER);
                bucketItem.method_7728(null, this.field_11863, stack, this.method_11016().method_10084());
                item.method_6979(new class_1799((class_1935)class_1802.field_8550));
                return true;
            }
            if (IXplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (class_3611)class_3612.field_15910)) {
                this.setFluid(IPetalApothecary.State.WATER);
                return true;
            }
            if (IXplatAbstractions.INSTANCE.extractFluidFromItemEntity(item, (class_3611)class_3612.field_15908)) {
                this.setFluid(IPetalApothecary.State.LAVA);
                return true;
            }
            return false;
        }
        if (this.getFluid() == IPetalApothecary.State.LAVA) {
            item.method_5639(100);
            return true;
        }
        if (SEED_PATTERN.matcher(stack.method_7922()).find()) {
            Optional maybeRecipe = this.field_11863.method_8433().method_8132(ModRecipeTypes.PETAL_TYPE, this.getItemHandler(), this.field_11863);
            maybeRecipe.ifPresent(recipe -> {
                this.saveLastRecipe();
                class_1799 output = recipe.method_8116(this.getItemHandler());
                for (int i = 0; i < this.inventorySize(); ++i) {
                    this.getItemHandler().method_5447(i, class_1799.field_8037);
                }
                stack.method_7934(1);
                class_1542 outputItem = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, output);
                IXplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)outputItem).apothecarySpawned = true;
                this.field_11863.method_8649((class_1297)outputItem);
                this.setFluid(IPetalApothecary.State.EMPTY);
                this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 1, 0);
            });
            return maybeRecipe.isPresent();
        }
        if (!IXplatAbstractions.INSTANCE.isFluidContainer(item) && !IXplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).apothecarySpawned) {
            if (!this.getItemHandler().method_5438(this.inventorySize() - 1).method_7960()) {
                return false;
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                if (!this.getItemHandler().method_5438(i).method_7960()) continue;
                this.getItemHandler().method_5447(i, stack.method_7971(1));
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14737, class_3419.field_15245, 0.1f, 10.0f);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private ICustomApothecaryColor getFlowerComponent(class_1799 stack) {
        ICustomApothecaryColor c = null;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ICustomApothecaryColor) {
            ICustomApothecaryColor color;
            c = color = (ICustomApothecaryColor)class_17922;
        }
        return c;
    }

    public void saveLastRecipe() {
        class_1799 stack;
        this.lastRecipe = new ArrayList<class_1799>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().method_5438(i)).method_7960(); ++i) {
            this.lastRecipe.add(stack.method_7972());
        }
        this.recipeKeepTicks = 400;
        this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 0, 400);
    }

    public void trySetLastRecipe(class_1657 player) {
        TileAltar.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe);
        if (!this.isEmpty()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public static void tryToSetLastRecipe(class_1657 player, class_1263 inv, List<class_1799> lastRecipe) {
        if (lastRecipe == null || lastRecipe.isEmpty() || player.field_6002.field_9236) {
            return;
        }
        int index = 0;
        boolean didAny = false;
        block0: for (class_1799 stack : lastRecipe) {
            if (stack.method_7960()) continue;
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 pstack = player.method_31548().method_5438(i);
                if (!player.method_7337() && (pstack.method_7960() || !pstack.method_7962(stack) || !class_1799.method_7975((class_1799)stack, (class_1799)pstack))) continue;
                inv.method_5447(index, player.method_7337() ? stack.method_7972() : pstack.method_7971(1));
                didAny = true;
                ++index;
                continue block0;
            }
        }
        if (didAny) {
            player.field_6002.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14737, class_3419.field_15245, 0.1f, 10.0f);
            class_3222 mp = (class_3222)player;
            mp.field_7498.method_7623();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    private void tickRecipeKeep() {
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileAltar self) {
        List items = level.method_18467(class_1542.class, new class_238(worldPosition.method_10080(0.0, 1.25, 0.0), worldPosition.method_10080(1.0, 2.0, 1.0)));
        boolean didChange = false;
        for (class_1542 item : items) {
            didChange = self.collideEntityItem(item) || didChange;
        }
        if (didChange) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
        }
        self.tickRecipeKeep();
    }

    public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileAltar self) {
        class_1799 stackAt;
        for (int i = 0; i < self.inventorySize() && !(stackAt = self.getItemHandler().method_5438(i)).method_7960(); ++i) {
            if (!(Math.random() >= 0.97)) continue;
            ICustomApothecaryColor comp = self.getFlowerComponent(stackAt);
            int color = comp == null ? 0x888888 : comp.getParticleColor(stackAt);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() >= 0.75) {
                level.method_8396(null, worldPosition, class_3417.field_14737, class_3419.field_15245, 0.1f, 10.0f);
            }
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
            level.method_8406((class_2394)data, (double)worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)worldPosition.method_10264() + 1.2, (double)worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
        }
        if (self.getFluid() == IPetalApothecary.State.LAVA) {
            level.method_8406((class_2394)class_2398.field_11251, (double)worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.method_10264() + 1), (double)worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.05, 0.0);
            if (Math.random() > 0.9) {
                level.method_8406((class_2394)class_2398.field_11239, (double)worldPosition.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(worldPosition.method_10264() + 1), (double)worldPosition.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.01, 0.0);
            }
        }
        self.tickRecipeKeep();
    }

    public boolean method_11004(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                if (this.field_11863.field_9236) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_11863.method_8406((class_2394)data, (double)this.field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), ModSounds.altarCraft, class_3419.field_15245, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.method_11004(id, param);
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(16){

            public int method_5444() {
                return 1;
            }
        };
    }

    @Override
    public void setFluid(IPetalApothecary.State fluid) {
        this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(BlockAltar.FLUID, (Comparable)((Object)fluid)));
    }

    @Override
    public IPetalApothecary.State getFluid() {
        return (IPetalApothecary.State)((Object)this.method_11010().method_11654(BlockAltar.FLUID));
    }

    public static class Hud {
        public static void render(TileAltar altar, class_4587 ms, class_310 mc) {
            int xc = mc.method_22683().method_4486() / 2;
            int yc = mc.method_22683().method_4502() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().method_5438(i).method_7960(); ++i) {
                ++amt;
            }
            if (amt > 0) {
                float anglePer = 360.0f / (float)amt;
                Optional maybeRecipe = altar.field_11863.method_8433().method_8132(ModRecipeTypes.PETAL_TYPE, altar.getItemHandler(), altar.field_11863);
                maybeRecipe.ifPresent(recipe -> {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.setShaderTexture((int)0, (class_2960)HUDHandler.manaBar);
                    RenderHelper.drawTexturedModalRect(ms, xc + radius + 9, yc - 8, 0, 8, 22, 15);
                    class_1799 stack = recipe.method_8116(altar.getItemHandler());
                    mc.method_1480().method_4010(stack, xc + radius + 32, yc - 8);
                    mc.method_1480().method_4010(new class_1799((class_1935)class_1802.field_8317), xc + radius + 16, yc + 6);
                    mc.field_1772.method_1729(ms, "+", (float)(xc + radius + 14), (float)(yc + 10), 0xFFFFFF);
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    class_4587 pose = RenderSystem.getModelViewStack();
                    pose.method_22903();
                    pose.method_22904(xPos, yPos, 0.0);
                    RenderSystem.applyModelViewMatrix();
                    mc.method_1480().method_4010(altar.getItemHandler().method_5438(i), 0, 0);
                    pose.method_22909();
                    RenderSystem.applyModelViewMatrix();
                    angle += anglePer;
                }
            } else if (altar.recipeKeepTicks > 0 && altar.getFluid() == IPetalApothecary.State.WATER) {
                String s = class_1074.method_4662((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                mc.field_1772.method_1729(ms, s, (float)(xc - mc.field_1772.method_1727(s) / 2), (float)(yc + 10), 0xFFFFFF);
                s = class_1074.method_4662((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                mc.field_1772.method_1729(ms, s, (float)(xc - mc.field_1772.method_1727(s) / 2), (float)(yc + 20), 0xFFFFFF);
            }
        }
    }
}

