/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.helper.MathHelper;

public class SubTileTangleberrie
extends TileEntityFunctionalFlower {
    private static final double RANGE = 7.0;
    private static final double MAXDISTANCE = 6.0;
    private static final double RANGE_MINI = 3.0;
    private static final double MAXDISTANCE_MINI = 2.0;

    public SubTileTangleberrie(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SubTileTangleberrie(class_2338 pos, class_2680 state) {
        this(ModSubtiles.TANGLEBERRIE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.getMana() > 0) {
            double x1 = (double)this.getEffectivePos().method_10263() + 0.5;
            double y1 = (double)this.getEffectivePos().method_10264() + 0.5;
            double z1 = (double)this.getEffectivePos().method_10260() + 0.5;
            double maxDist = this.getMaxDistance();
            double range = this.getRange();
            class_238 boundingBox = new class_238(x1 - range, y1 - range, z1 - range, x1 + range + 1.0, y1 + range + 1.0, z1 + range + 1.0);
            List entities = this.method_10997().method_18467(class_1309.class, boundingBox);
            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 0.5f, 0.5f, 0.5f, 3);
            for (class_1309 entity : entities) {
                double z2;
                double y2;
                double x2;
                float distance;
                if (entity instanceof class_1657 || !entity.method_5822() || !((double)(distance = MathHelper.pointDistanceSpace(x1, y1, z1, x2 = entity.method_23317(), y2 = entity.method_23318(), z2 = entity.method_23321())) > maxDist) || !((double)distance < range)) continue;
                MathHelper.setEntityMotionFromVector((class_1297)entity, new class_243(x1, y1, z1), this.getMotionVelocity(entity));
                if (this.method_10997().field_9229.nextInt(3) != 0) continue;
                this.field_11863.method_8406((class_2394)data, x2 + Math.random() * (double)entity.method_17681(), y2 + Math.random() * (double)entity.method_17682(), z2 + Math.random() * (double)entity.method_17681(), 0.0, 0.0, 0.0);
            }
            if (this.ticksExisted % 4 == 0) {
                this.addMana(-1);
                this.sync();
            }
        }
    }

    double getMaxDistance() {
        return 6.0;
    }

    double getRange() {
        return 7.0;
    }

    float getMotionVelocity(class_1309 entity) {
        return Math.max(entity.method_6029() / 2.0f, 0.05f);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        if (this.getMaxDistance() == this.getRange()) {
            return null;
        }
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.getMaxDistance());
    }

    @Override
    public int getColor() {
        return 4946300;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    public static class Mini
    extends SubTileTangleberrie {
        public Mini(class_2338 pos, class_2680 state) {
            super(ModSubtiles.TANGLEBERRIE_CHIBI, pos, state);
        }

        @Override
        public double getMaxDistance() {
            return 2.0;
        }

        @Override
        public double getRange() {
            return 3.0;
        }
    }
}

