/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.subtile.functional.SubTileSpectranthemum;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.xplat.IXplatAbstractions;

public class SubTileHopperhock
extends TileEntityFunctionalFlower
implements IWandable {
    private static final String TAG_FILTER_TYPE = "filterType";
    private static final int RANGE_MANA = 10;
    private static final int RANGE = 6;
    private static final int RANGE_MANA_MINI = 2;
    private static final int RANGE_MINI = 1;
    private int filterType = 0;

    protected SubTileHopperhock(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public SubTileHopperhock(class_2338 pos, class_2680 state) {
        this(ModSubtiles.HOPPERHOCK, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236 || this.redstoneSignal > 0) {
            return;
        }
        boolean pulledAny = false;
        int range = this.getRange();
        class_2338 pos = this.getEffectivePos();
        List items = this.method_10997().method_18467(class_1542.class, new class_238(pos.method_10069(-range, -range, -range), pos.method_10069(range + 1, range + 1, range + 1)));
        for (class_1542 item : items) {
            if (!DelayHelper.canInteractWith(this, item) || IXplatAbstractions.INSTANCE.itemFlagsComponent(item).getManaInfusionCooldown() > 20) continue;
            class_1799 stack = item.method_6983();
            boolean priorityInv = false;
            int amountToPutIn = 0;
            class_2350 direction = null;
            for (class_2350 dir : class_2350.values()) {
                boolean priority;
                class_2350 sideOfInventory;
                class_2338 inventoryPos = pos.method_10093(dir);
                if (!IXplatAbstractions.INSTANCE.hasInventory(this.field_11863, inventoryPos, sideOfInventory = dir.method_10153())) continue;
                List<class_1799> filter = SubTileHopperhock.getFilterForInventory(this.method_10997(), inventoryPos, true);
                boolean canAccept = SubTileHopperhock.canAcceptItem(stack, filter, this.filterType);
                class_1799 simulate = IXplatAbstractions.INSTANCE.insertToInventory(this.field_11863, inventoryPos, sideOfInventory, stack, true);
                int inserted = stack.method_7947() - simulate.method_7947();
                boolean bl = canAccept = canAccept && inserted > 0;
                if (!canAccept) continue;
                boolean bl2 = priority = !filter.isEmpty();
                if (priorityInv && !priority) continue;
                priorityInv = priority;
                amountToPutIn = inserted;
                direction = dir;
            }
            if (direction == null || !item.method_5805()) continue;
            SubTileSpectranthemum.spawnExplosionParticles((class_1297)item, 3);
            InventoryHelper.checkEmpty(IXplatAbstractions.INSTANCE.insertToInventory(this.field_11863, pos.method_10093(direction), direction.method_10153(), stack.method_7971(amountToPutIn), false));
            item.method_6979(stack);
            pulledAny = true;
        }
        if (pulledAny && this.getMana() > 0) {
            this.addMana(-1);
        }
    }

    public static boolean canAcceptItem(class_1799 stack, List<class_1799> filter, int filterType) {
        if (stack.method_7960()) {
            return false;
        }
        if (filter.isEmpty()) {
            return true;
        }
        switch (filterType) {
            case 0: {
                boolean anyFilter = false;
                for (class_1799 filterEntry : filter) {
                    if (filterEntry == null || filterEntry.method_7960()) continue;
                    anyFilter = true;
                    if (!SubTileHopperhock.matches(stack, filterEntry)) continue;
                    return true;
                }
                return !anyFilter;
            }
            case 1: {
                return !SubTileHopperhock.canAcceptItem(stack, filter, 0);
            }
        }
        return true;
    }

    public static boolean matches(class_1799 stack, class_1799 filter) {
        class_1792 item = stack.method_7909();
        if (item != filter.method_7909()) {
            return false;
        }
        if (item instanceof IManaItem) {
            IManaItem manaItem = (IManaItem)item;
            return SubTileHopperhock.getFullness(manaItem, stack) == SubTileHopperhock.getFullness(manaItem, filter);
        }
        return class_1799.method_7975((class_1799)filter, (class_1799)stack);
    }

    public static int getFullness(IManaItem item, class_1799 stack) {
        int fuzz;
        int mana = item.getMana(stack);
        return mana <= (fuzz = 10) ? 0 : (mana + fuzz < item.getMaxMana(stack) ? 1 : 2);
    }

    public static List<class_1799> getFilterForInventory(class_1937 level, class_2338 pos, boolean recursiveForDoubleChests) {
        class_2338 other;
        class_2745 type;
        class_2680 chest;
        ArrayList<class_1799> filter = new ArrayList<class_1799>();
        if (recursiveForDoubleChests && (chest = level.method_8320(pos)).method_28498((class_2769)class_2281.field_10770) && (type = (class_2745)chest.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569 && level.method_8320(other = pos.method_10093(class_2281.method_9758((class_2680)chest))).method_27852(chest.method_26204())) {
            filter.addAll(SubTileHopperhock.getFilterForInventory(level, other, false));
        }
        for (class_2350 dir : class_2350.values()) {
            class_238 aabb = new class_238(pos.method_10093(dir));
            List frames = level.method_18467(class_1533.class, aabb);
            for (class_1533 frame : frames) {
                if (frame.method_5735() != dir) continue;
                filter.add(frame.method_6940());
            }
        }
        return filter;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 wand, class_2350 side) {
        if (player == null || player.method_5715()) {
            this.filterType = this.filterType == 2 ? 0 : this.filterType + 1;
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return this.getMana() > 0 ? 10 : 6;
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_FILTER_TYPE, this.filterType);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.filterType = cmp.method_10550(TAG_FILTER_TYPE);
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 0x3F3F3F;
    }

    public static class Mini
    extends SubTileHopperhock {
        public Mini(class_2338 pos, class_2680 state) {
            super(ModSubtiles.HOPPERHOCK_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return this.getMana() > 0 ? 2 : 1;
        }
    }

    public static class WandHud
    extends TileEntityFunctionalFlower.FunctionalWandHud<SubTileHopperhock> {
        public WandHud(SubTileHopperhock flower) {
            super(flower);
        }

        @Override
        public void renderHUD(class_4587 ms, class_310 mc) {
            super.renderHUD(ms, mc);
            String filter = class_1074.method_4662((String)("botaniamisc.filter" + ((SubTileHopperhock)this.flower).filterType), (Object[])new Object[0]);
            int x = mc.method_22683().method_4486() / 2 - mc.field_1772.method_1727(filter) / 2;
            int y = mc.method_22683().method_4502() / 2 + 30;
            mc.field_1772.method_1720(ms, filter, (float)x, (float)y, class_124.field_1080.method_532().intValue());
        }
    }
}

