/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.entity.EntityManaBurst;

public class BlockPool
extends BlockModWaterloggable
implements class_2343 {
    private static final class_265 REAL_SHAPE;
    private static final class_265 BURST_SHAPE;
    public final Variant variant;

    public BlockPool(Variant v, class_4970.class_2251 builder) {
        super(builder);
        this.variant = v;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, world, tooltip, flag);
        if (this.variant == Variant.CREATIVE) {
            for (int i = 0; i < 2; ++i) {
                tooltip.add((class_2561)new class_2588("botaniamisc.creativePool" + i).method_27692(class_124.field_1080));
            }
        }
    }

    @Nonnull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
        return REAL_SHAPE;
    }

    @Nonnull
    public class_1269 method_9534(@Nonnull class_2680 state, class_1937 world, @Nonnull class_2338 pos, class_1657 player, @Nonnull class_1268 hand, @Nonnull class_3965 hit) {
        class_2586 te = world.method_8321(pos);
        class_1799 stack = player.method_5998(hand);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dye = (class_1769)class_17922;
            if (te instanceof TilePool) {
                TilePool pool = (TilePool)te;
                class_1767 color = dye.method_7802();
                if (color != pool.getColor()) {
                    pool.setColor(color);
                    stack.method_7934(1);
                    return class_1269.field_5812;
                }
            }
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_3727 econtext;
        if (context instanceof class_3727 && (econtext = (class_3727)context).method_32480() instanceof EntityManaBurst) {
            return BURST_SHAPE;
        }
        return super.method_9549(state, world, pos, context);
    }

    @Nonnull
    public class_2586 method_10123(@Nonnull class_2338 pos, @Nonnull class_2680 state) {
        return new TilePool(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return BlockPool.createTickerHelper(type, ModTiles.POOL, level.field_9236 ? TilePool::clientTick : TilePool::serverTick);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            TilePool tile = (TilePool)world.method_8321(pos);
            tile.collideEntityItem(item);
        }
    }

    @Nonnull
    public class_2464 method_9604(class_2680 state) {
        if (this.variant == Variant.FABULOUS) {
            return class_2464.field_11456;
        }
        return class_2464.field_11458;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        TilePool pool = (TilePool)world.method_8321(pos);
        return TilePool.calculateComparatorLevel(pool.getCurrentMana(), pool.manaCap);
    }

    static {
        class_265 slab = BlockPool.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        class_265 cutout = BlockPool.method_9541((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        class_265 cutoutBurst = BlockPool.method_9541((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
        BURST_SHAPE = class_259.method_1072((class_265)slab, (class_265)cutoutBurst, (class_247)class_247.field_16886);
        REAL_SHAPE = class_259.method_1072((class_265)slab, (class_265)cutout, (class_247)class_247.field_16886);
    }

    public static enum Variant {
        DEFAULT,
        CREATIVE,
        DILUTED,
        FABULOUS;

    }
}

