/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.xplat;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.IPacket;

public interface IClientXplatAbstractions {
    public static final ResourceLocation FLOATING_FLOWER_MODEL_LOADER_ID = ResourceLocationHelper.prefix("floating_flower");
    public static final IClientXplatAbstractions INSTANCE = IClientXplatAbstractions.find();

    public void fireRenderTinyPotato(BlockEntity var1, Component var2, float var3, PoseStack var4, MultiBufferSource var5, int var6, int var7);

    public void sendToServer(IPacket var1);

    @Nullable
    public IWandHUD findWandHud(Level var1, BlockPos var2, BlockState var3, @Nullable BlockEntity var4);

    public BakedModel wrapPlatformModel(BakedModel var1);

    public void setFilterSave(AbstractTexture var1, boolean var2, boolean var3);

    public void restoreLastFilter(AbstractTexture var1);

    private static IClientXplatAbstractions find() {
        List<ServiceLoader.Provider<IClientXplatAbstractions>> providers = ServiceLoader.load(IClientXplatAbstractions.class).stream().toList();
        if (providers.size() != 1) {
            String names = providers.stream().map(p -> p.type().getName()).collect(Collectors.joining(",", "[", "]"));
            throw new IllegalStateException("There should be exactly one IClientXplatAbstractions implementation on the classpath. Found: " + names);
        }
        ServiceLoader.Provider<IClientXplatAbstractions> provider = providers.get(0);
        BotaniaAPI.LOGGER.debug("Instantiating client xplat impl: " + provider.type().getName());
        return provider.get();
    }
}

