/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.integration.corporea;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import vazkii.botania.api.corporea.ICorporeaRequest;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class ForgeCapCorporeaNode
extends AbstractCorporeaNode {
    protected final IItemHandler inv;

    public ForgeCapCorporeaNode(Level world, BlockPos pos, IItemHandler inv, ICorporeaSpark spark) {
        super(world, pos, spark);
        this.inv = inv;
    }

    @Override
    public List<ItemStack> countItems(ICorporeaRequest request) {
        return this.iterateOverSlots(request, false);
    }

    @Override
    public List<ItemStack> extractItems(ICorporeaRequest request) {
        return this.iterateOverSlots(request, true);
    }

    protected List<ItemStack> iterateOverSlots(ICorporeaRequest request, boolean doit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = this.inv.getSlots() - 1; i >= 0; --i) {
            ItemStack stackAt = this.inv.getStackInSlot(i);
            if (!request.getMatcher().test(stackAt)) continue;
            request.trackFound(stackAt.m_41613_());
            int rem = Math.min(stackAt.m_41613_(), request.getStillNeeded() == -1 ? stackAt.m_41613_() : request.getStillNeeded());
            if (rem <= 0) continue;
            request.trackSatisfied(rem);
            if (doit) {
                ItemStack copy = stackAt.m_41777_();
                builder.addAll(ForgeCapCorporeaNode.breakDownBigStack(this.inv.extractItem(i, rem, this.getSpark().isCreative())));
                this.getSpark().onItemExtracted(copy);
                request.trackExtracted(rem);
                continue;
            }
            builder.add((Object)this.inv.extractItem(i, rem, true));
        }
        return builder.build();
    }
}

