/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.client;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TilePlatform;

public class ForgePlatformModel
extends BakedModelWrapper<BakedModel> {
    public static final ModelProperty<TilePlatform.PlatformData> PROPERTY = new ModelProperty();

    public ForgePlatformModel(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public IModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TilePlatform) {
            TilePlatform platform = (TilePlatform)blockEntity;
            return new ModelDataMap.Builder().withInitial(PROPERTY, (Object)new TilePlatform.PlatformData(platform)).build();
        }
        return tileData;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        TilePlatform.PlatformData data = (TilePlatform.PlatformData)extraData.getData(PROPERTY);
        if (state == null || !(state.m_60734_() instanceof BlockPlatform) || data == null) {
            return Minecraft.m_91087_().m_91289_().m_110907_().m_110881_().m_119409_().getQuads(state, side, rand, extraData);
        }
        BlockState heldState = data.state();
        if (heldState == null) {
            return super.getQuads(state, side, rand, extraData);
        }
        if (heldState.m_60713_(ModBlocks.manaGlass)) {
            return Collections.emptyList();
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(heldState);
        return model.getQuads(heldState, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }
}

