/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.xplat.IClientXplatAbstractions;

public class FloatingFlowerModelProvider
implements DataProvider {
    private final DataGenerator generator;

    public FloatingFlowerModelProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache cache) throws IOException {
        ArrayList<Tuple> jsons = new ArrayList<Tuple>();
        for (Block b : Registry.f_122824_) {
            ResourceLocation id = Registry.f_122824_.m_7981_((Object)b);
            if (!"botania".equals(id.m_135827_()) || !(b instanceof BlockFloatingFlower)) continue;
            String name = id.m_135815_();
            String nonFloat = name.endsWith("_floating_flower") ? name.replace("_floating_flower", "_mystical_flower") : name.replace("floating_", "");
            JsonObject obj = new JsonObject();
            obj.addProperty("parent", "minecraft:block/block");
            obj.addProperty("loader", IClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID.toString());
            JsonObject flower = new JsonObject();
            flower.addProperty("parent", "botania:block/" + nonFloat);
            obj.add("flower", (JsonElement)flower);
            jsons.add(new Tuple((Object)name, (Object)obj));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (Tuple pair : jsons) {
            Path blockPath = this.generator.m_123916_().resolve("assets/botania/models/block/" + (String)pair.m_14418_() + ".json");
            Path itemPath = this.generator.m_123916_().resolve("assets/botania/models/item/" + (String)pair.m_14418_() + ".json");
            DataProvider.m_123920_((Gson)gson, (HashCache)cache, (JsonElement)((JsonElement)pair.m_14419_()), (Path)blockPath);
            DataProvider.m_123920_((Gson)gson, (HashCache)cache, (JsonElement)((JsonElement)pair.m_14419_()), (Path)itemPath);
        }
    }

    @Nonnull
    public String m_6055_() {
        return "Botania floating flower models";
    }
}

