/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.PlayerHelper;

public class ItemDirtRod
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_dirt.png");
    static final int COST = 75;

    public ItemDirtRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        return ItemDirtRod.place(ctx, Blocks.f_50493_, 75, 0.35f, 0.2f, 0.05f);
    }

    public static InteractionResult place(UseOnContext ctx, Block block, int cost, float r, float g, float b) {
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        Direction side = ctx.m_43719_();
        BlockPos pos = ctx.m_8083_();
        if (player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, false)) {
            InteractionResult result;
            int entities = world.m_45976_(LivingEntity.class, new AABB(pos.m_142300_(side), pos.m_142300_(side).m_142082_(1, 1, 1))).size();
            if (entities == 0 && (result = PlayerHelper.substituteUse(ctx, new ItemStack((ItemLike)block))).m_19077_()) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true);
                SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, g, b, 5);
                for (int i = 0; i < 6; ++i) {
                    world.m_7106_((ParticleOptions)data, (double)(pos.m_123341_() + side.m_122429_()) + Math.random(), (double)(pos.m_123342_() + side.m_122430_()) + Math.random(), (double)(pos.m_123343_() + side.m_122431_()) + Math.random(), 0.0, 0.0, 0.0);
                }
                return result;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static class AvatarBehavior
    implements IAvatarWieldable {
        @Override
        public void onAvatarUpdate(IAvatarTile tile) {
            BlockPos pos;
            BlockState state;
            BlockEntity te = tile.tileEntity();
            Level world = te.m_58904_();
            if (!world.f_46443_ && tile.getCurrentMana() >= 75 && tile.getElapsedFunctionalTicks() % 4 == 0 && world.f_46441_.nextInt(8) == 0 && tile.isEnabled() && (state = world.m_8055_(pos = ((BlockEntity)tile).m_58899_().m_142300_(tile.getAvatarFacing()))).m_60795_()) {
                world.m_46597_(pos, Blocks.f_50493_.m_49966_());
                world.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_50493_.m_49966_()));
                tile.receiveMana(-75);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(IAvatarTile tile) {
            return avatarOverlay;
        }
    }

    public static class BlockProvider
    implements IBlockProvider {
        private final ItemStack stack;

        public BlockProvider(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            if (block == Blocks.f_50493_) {
                return doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, true) || !doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, false);
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            if (block == Blocks.f_50493_) {
                return ManaItemHandler.instance().getInvocationCountForTool(requestor, player, 75);
            }
            return 0;
        }
    }
}

