/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.advancements.ManaGunTrigger;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.proxy.IProxy;

public class ItemManaGun
extends Item {
    private static final String TAG_LENS = "lens";
    private static final String TAG_CLIP = "clip";
    private static final String TAG_CLIP_POS = "clipPos";
    private static final String TAG_COOLDOWN = "cooldown";
    private static final int CLIP_SLOTS = 6;
    private static final int COOLDOWN = 30;

    public ItemManaGun(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int effCd = 30;
        MobEffectInstance effect = player.m_21124_(MobEffects.f_19598_);
        if (effect != null) {
            effCd = Math.max(2, 30 - (effect.m_19564_() + 1) * 8);
        }
        if (player.m_6144_() && ItemManaGun.hasClip(stack)) {
            ItemManaGun.rotatePos(stack);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.manaBlasterCycle, SoundSource.PLAYERS, 0.6f, (1.0f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.2f) * 0.7f);
            if (!world.f_46443_) {
                ItemStack lens = ItemManaGun.getLens(stack);
                ItemsRemainingRenderHandler.send(player, lens, -2);
                this.setCooldown(stack, effCd);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
        }
        if (this.getCooldown(stack) <= 0) {
            EntityManaBurst burst = this.getBurst(player, stack, true, hand);
            if (burst != null && ManaItemHandler.instance().requestManaExact(stack, player, burst.getMana(), true)) {
                if (!world.f_46443_) {
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.manaBlaster, SoundSource.PLAYERS, 1.0f, 1.0f);
                    world.m_7967_((Entity)burst);
                    ManaGunTrigger.INSTANCE.trigger((ServerPlayer)player, stack);
                    this.setCooldown(stack, effCd);
                } else {
                    player.m_20256_(player.m_20184_().m_82546_(burst.m_20184_().m_82542_(0.1, 0.3, 0.1)));
                }
            } else if (!world.f_46443_) {
                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ModSounds.manaBlasterMisfire, SoundSource.PLAYERS, 0.6f, (1.0f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.2f) * 0.7f);
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static boolean isSugoiKawaiiDesuNe(ItemStack stack) {
        return stack.m_41786_().getString().equalsIgnoreCase("desu gun");
    }

    @Nonnull
    public BurstProperties getBurstProps(Player player, ItemStack stack, boolean request, InteractionHand hand) {
        int maxMana = 120;
        int color = 0x20FF20;
        int ticksBeforeManaLoss = 60;
        float manaLossPerTick = 4.0f;
        float motionModifier = 5.0f;
        float gravity = 0.0f;
        BurstProperties props = new BurstProperties(maxMana, ticksBeforeManaLoss, manaLossPerTick, gravity, motionModifier, color);
        ItemStack lens = ItemManaGun.getLens(stack);
        if (!lens.m_41619_()) {
            ((ILens)lens.m_41720_()).apply(lens, props, player.f_19853_);
        }
        return props;
    }

    private EntityManaBurst getBurst(Player player, ItemStack stack, boolean request, InteractionHand hand) {
        EntityManaBurst burst = new EntityManaBurst(player);
        BurstProperties props = this.getBurstProps(player, stack, request, hand);
        burst.setSourceLens(ItemManaGun.getLens(stack));
        if (!request || ManaItemHandler.instance().requestManaExact(stack, player, props.maxMana, false)) {
            burst.setColor(props.color);
            burst.setMana(props.maxMana);
            burst.setStartingMana(props.maxMana);
            burst.setMinManaLoss(props.ticksBeforeManaLoss);
            burst.setManaLossPerTick(props.manaLossPerTick);
            burst.setGravity(props.gravity);
            burst.m_20256_(burst.m_20184_().m_82490_((double)props.motionModifier));
            return burst;
        }
        return null;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        boolean clip = ItemManaGun.hasClip(stack);
        if (clip) {
            TooltipHandler.addOnShift(tooltip, () -> this.appendHoverTextImpl(stack, tooltip));
        } else {
            this.appendHoverTextImpl(stack, tooltip);
        }
    }

    private void appendHoverTextImpl(ItemStack stack, List<Component> tooltip) {
        List lensTip;
        boolean clip = ItemManaGun.hasClip(stack);
        if (clip && !Screen.m_96638_()) {
            tooltip.add(TooltipHandler.getShiftInfoTooltip());
            return;
        }
        ItemStack lens = ItemManaGun.getLens(stack);
        if (!lens.m_41619_() && (lensTip = lens.m_41651_(IProxy.INSTANCE.getClientPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL)).size() > 1) {
            tooltip.addAll(lensTip.subList(1, lensTip.size()));
        }
        if (clip) {
            int pos = ItemManaGun.getClipPos(stack);
            tooltip.add((Component)new TranslatableComponent("botaniamisc.hasClip"));
            for (int i = 0; i < 6; ++i) {
                ItemStack lensAt = ItemManaGun.getLensAtPos(stack, i);
                Object name = lensAt.m_41619_() ? new TranslatableComponent("botaniamisc.clipEmpty") : lensAt.m_41786_();
                MutableComponent tip = new TextComponent(" - ").m_7220_(name);
                tip.m_130940_(i == pos ? ChatFormatting.GREEN : ChatFormatting.GRAY);
                tooltip.add((Component)tip);
            }
        }
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        ItemStack lens = ItemManaGun.getLens(stack);
        MutableComponent cmp = super.m_7626_(stack).m_6881_();
        if (!lens.m_41619_()) {
            cmp.m_130946_(" (");
            cmp.m_7220_((Component)lens.m_41786_().m_6881_().m_130940_(ChatFormatting.GREEN));
            cmp.m_130946_(")");
        }
        return cmp;
    }

    public static boolean hasClip(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CLIP, false);
    }

    public static void setClip(ItemStack stack, boolean clip) {
        ItemNBTHelper.setBoolean(stack, TAG_CLIP, clip);
    }

    public static int getClipPos(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_CLIP_POS, 0);
    }

    public static void setClipPos(ItemStack stack, int pos) {
        ItemNBTHelper.setInt(stack, TAG_CLIP_POS, pos);
    }

    public static void rotatePos(ItemStack stack) {
        int currPos = ItemManaGun.getClipPos(stack);
        boolean acceptEmpty = !ItemManaGun.getLensAtPos(stack, currPos).m_41619_();
        int[] slots = new int[5];
        int index = 0;
        int i = currPos + 1;
        while (i < 6) {
            slots[index] = i++;
            ++index;
        }
        i = 0;
        while (i < currPos) {
            slots[index] = i++;
            ++index;
        }
        for (int i2 : slots) {
            ItemStack lensAt = ItemManaGun.getLensAtPos(stack, i2);
            if (!acceptEmpty && lensAt.m_41619_()) continue;
            ItemManaGun.setClipPos(stack, i2);
            return;
        }
    }

    public static ItemStack getLensAtPos(ItemStack stack, int pos) {
        CompoundTag cmp = ItemNBTHelper.getCompound(stack, TAG_LENS + pos, true);
        if (cmp != null) {
            return ItemStack.m_41712_((CompoundTag)cmp);
        }
        return ItemStack.f_41583_;
    }

    public static void setLensAtPos(ItemStack stack, ItemStack lens, int pos) {
        CompoundTag cmp = new CompoundTag();
        if (lens != null) {
            cmp = lens.m_41739_(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS + pos, cmp);
    }

    public static void setLens(ItemStack stack, ItemStack lens) {
        if (ItemManaGun.hasClip(stack)) {
            ItemManaGun.setLensAtPos(stack, lens, ItemManaGun.getClipPos(stack));
        }
        CompoundTag cmp = new CompoundTag();
        if (!lens.m_41619_()) {
            cmp = lens.m_41739_(cmp);
        }
        ItemNBTHelper.setCompound(stack, TAG_LENS, cmp);
    }

    public static ItemStack getLens(ItemStack stack) {
        if (ItemManaGun.hasClip(stack)) {
            return ItemManaGun.getLensAtPos(stack, ItemManaGun.getClipPos(stack));
        }
        CompoundTag cmp = ItemNBTHelper.getCompound(stack, TAG_LENS, true);
        if (cmp != null) {
            return ItemStack.m_41712_((CompoundTag)cmp);
        }
        return ItemStack.f_41583_;
    }

    public static List<ItemStack> getAllLens(ItemStack stack) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            ret.add(ItemManaGun.getLensAtPos(stack, i));
        }
        return ret;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (this.getCooldown(stack) > 0) {
            this.setCooldown(stack, this.getCooldown(stack) - 1);
        }
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return this.getCooldown(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)this.getCooldown(stack) / 30.0f));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)((1.0f - (float)this.getCooldown(stack) / 30.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    private int getCooldown(ItemStack stack) {
        return stack.m_41784_().m_128451_(TAG_COOLDOWN);
    }

    private void setCooldown(ItemStack stack, int cooldown) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_COOLDOWN, cooldown);
    }
}

