/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.helper;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public final class PlayerHelper {
    public static boolean hasAnyHeldItem(Player player) {
        return !player.m_21205_().m_41619_() || !player.m_21206_().m_41619_();
    }

    public static boolean hasHeldItem(Player player, Item item) {
        return !player.m_21205_().m_41619_() && player.m_21205_().m_150930_(item) || !player.m_21206_().m_41619_() && player.m_21206_().m_150930_(item);
    }

    public static boolean hasHeldItemClass(Player player, Item template) {
        return PlayerHelper.hasHeldItemClass(player, template.getClass());
    }

    public static boolean hasHeldItemClass(Player player, Class<?> template) {
        return !player.m_21205_().m_41619_() && template.isAssignableFrom(player.m_21205_().m_41720_().getClass()) || !player.m_21206_().m_41619_() && template.isAssignableFrom(player.m_21206_().m_41720_().getClass());
    }

    public static ItemStack getFirstHeldItem(LivingEntity living, Item item) {
        return PlayerHelper.getFirstHeldItem(living, (ItemStack s) -> s.m_150930_(item));
    }

    public static ItemStack getFirstHeldItem(LivingEntity living, Predicate<ItemStack> pred) {
        ItemStack main = living.m_21205_();
        ItemStack offhand = living.m_21206_();
        if (!main.m_41619_() && pred.test(main)) {
            return main;
        }
        if (!offhand.m_41619_() && pred.test(offhand)) {
            return offhand;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getFirstHeldItemClass(Player player, Class<?> template) {
        return PlayerHelper.getFirstHeldItem((LivingEntity)player, (ItemStack s) -> template.isAssignableFrom(s.m_41720_().getClass()));
    }

    public static ItemStack getAmmo(Player player, Predicate<ItemStack> ammoFunc) {
        if (ammoFunc.test(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (ammoFunc.test(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!ammoFunc.test(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasAmmo(Player player, Predicate<ItemStack> ammoFunc) {
        return !PlayerHelper.getAmmo(player, ammoFunc).m_41619_();
    }

    public static void consumeAmmo(Player player, Predicate<ItemStack> ammoFunc) {
        ItemStack ammo = PlayerHelper.getAmmo(player, ammoFunc);
        if (!ammo.m_41619_()) {
            ammo.m_41774_(1);
        }
    }

    public static boolean hasItem(Player player, Predicate<ItemStack> itemFunc) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!itemFunc.test(player.m_150109_().m_8020_(i))) continue;
            return true;
        }
        return false;
    }

    public static void grantCriterion(ServerPlayer player, ResourceLocation advancementId, String criterion) {
        PlayerAdvancements advancements = player.m_8960_();
        ServerAdvancementManager manager = player.m_183503_().m_142572_().m_129889_();
        Advancement advancement = manager.m_136041_(advancementId);
        if (advancement != null && !advancements.m_135996_(advancement).m_8193_()) {
            advancements.m_135988_(advancement, criterion);
        }
    }

    public static InteractionResult substituteUse(UseOnContext ctx, ItemStack toUse) {
        return (InteractionResult)PlayerHelper.substituteUseTrackPos(ctx, toUse).getFirst();
    }

    public static Pair<InteractionResult, BlockPos> substituteUseTrackPos(UseOnContext ctx, ItemStack toUse) {
        ItemUseContextWithNullPlayer newCtx;
        ItemStack save = ItemStack.f_41583_;
        BlockHitResult hit = new BlockHitResult(ctx.m_43720_(), ctx.m_43719_(), ctx.m_8083_(), ctx.m_43721_());
        if (ctx.m_43723_() != null) {
            save = ctx.m_43723_().m_21120_(ctx.m_43724_());
            ctx.m_43723_().m_21008_(ctx.m_43724_(), toUse);
            newCtx = new UseOnContext(ctx.m_43723_(), ctx.m_43724_(), hit);
        } else {
            newCtx = new ItemUseContextWithNullPlayer(ctx.m_43725_(), ctx.m_43724_(), toUse, hit);
        }
        BlockPos finalPos = new BlockPlaceContext((UseOnContext)newCtx).m_8083_();
        InteractionResult result = toUse.m_41661_((UseOnContext)newCtx);
        if (ctx.m_43723_() != null) {
            ctx.m_43723_().m_21008_(ctx.m_43724_(), save);
        }
        return Pair.of((Object)result, (Object)finalPos);
    }

    private PlayerHelper() {
    }

    private static class ItemUseContextWithNullPlayer
    extends UseOnContext {
        public ItemUseContextWithNullPlayer(Level world, InteractionHand hand, ItemStack stack, BlockHitResult rayTraceResult) {
            super(world, null, hand, stack, rayTraceResult);
        }
    }
}

