/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.helper.VecHelper;

public class EntityMagicMissile
extends ThrowableProjectile {
    private static final String TAG_TIME = "time";
    private static final EntityDataAccessor<Boolean> EVIL = SynchedEntityData.m_135353_(EntityMagicMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.m_135353_(EntityMagicMissile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    double lockX;
    double lockY = -2.147483648E9;
    double lockZ;
    int time = 0;

    public EntityMagicMissile(EntityType<EntityMagicMissile> type, Level world) {
        super(type, world);
    }

    public EntityMagicMissile(LivingEntity owner, boolean evil) {
        super(ModEntities.MAGIC_MISSILE, owner, owner.f_19853_);
        this.setEvil(evil);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(EVIL, (Object)false);
        this.f_19804_.m_135372_(TARGET, (Object)0);
    }

    public void setEvil(boolean evil) {
        this.f_19804_.m_135381_(EVIL, (Object)evil);
    }

    public boolean isEvil() {
        return (Boolean)this.f_19804_.m_135370_(EVIL);
    }

    public void setTarget(LivingEntity e) {
        this.f_19804_.m_135381_(TARGET, (Object)(e == null ? -1 : e.m_142049_()));
    }

    public LivingEntity getTargetEntity() {
        int id = (Integer)this.f_19804_.m_135370_(TARGET);
        Entity e = this.f_19853_.m_6815_(id);
        if (e instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)e;
            return le;
        }
        return null;
    }

    public void m_8119_() {
        double lastTickPosX = this.f_19790_;
        double lastTickPosY = this.f_19791_;
        double lastTickPosZ = this.f_19792_;
        super.m_8119_();
        if (!(this.f_19853_.f_46443_ || this.findTarget() && this.time <= 40)) {
            this.m_146870_();
            return;
        }
        boolean evil = this.isEvil();
        Vec3 thisVec = VecHelper.fromEntityCenter((Entity)this);
        Vec3 oldPos = new Vec3(lastTickPosX, lastTickPosY, lastTickPosZ);
        Vec3 diff = thisVec.m_82546_(oldPos);
        Vec3 step = diff.m_82541_().m_82490_(0.05);
        int steps = (int)(diff.m_82553_() / step.m_82553_());
        Vec3 particlePos = oldPos;
        SparkleParticleData data = evil ? SparkleParticleData.corrupt(0.8f, 1.0f, 0.0f, 1.0f, 2) : SparkleParticleData.sparkle(0.8f, 1.0f, 0.4f, 1.0f, 2);
        for (int i = 0; i < steps; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)data, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            if (this.f_19853_.f_46441_.nextInt(steps) <= 1) {
                this.f_19853_.m_7106_((ParticleOptions)data, particlePos.f_82479_ + (Math.random() - 0.5) * 0.4, particlePos.f_82480_ + (Math.random() - 0.5) * 0.4, particlePos.f_82481_ + (Math.random() - 0.5) * 0.4, 0.0, 0.0, 0.0);
            }
            particlePos = particlePos.m_82549_(step);
        }
        LivingEntity target = this.getTargetEntity();
        if (target != null) {
            List targetList;
            if (this.lockY == -2.147483648E9) {
                this.lockX = target.m_20185_();
                this.lockY = target.m_20186_();
                this.lockZ = target.m_20189_();
            }
            Vec3 targetVec = evil ? new Vec3(this.lockX, this.lockY, this.lockZ) : VecHelper.fromEntityCenter((Entity)target);
            Vec3 diffVec = targetVec.m_82546_(thisVec);
            Vec3 motionVec = diffVec.m_82541_().m_82490_(evil ? 0.5 : 0.6);
            this.m_20256_(motionVec);
            if (this.time < 10) {
                this.m_20334_(this.m_20184_().m_7096_(), Math.abs(this.m_20184_().m_7098_()), this.m_20184_().m_7094_());
            }
            if ((targetList = this.f_19853_.m_45976_(LivingEntity.class, new AABB(this.m_20185_() - 0.5, this.m_20186_() - 0.5, this.m_20189_() - 0.5, this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5))).contains(target)) {
                Entity owner = this.m_37282_();
                if (owner instanceof LivingEntity) {
                    DamageSource damageSource;
                    LivingEntity livingOwner = (LivingEntity)owner;
                    if (owner instanceof Player) {
                        Player playerOwner = (Player)owner;
                        damageSource = DamageSource.m_19344_((Player)playerOwner);
                    } else {
                        damageSource = DamageSource.m_19370_((LivingEntity)livingOwner);
                    }
                    target.m_6469_(damageSource, evil ? 12.0f : 7.0f);
                } else {
                    target.m_6469_(DamageSource.f_19318_, evil ? 12.0f : 7.0f);
                }
                this.m_146870_();
            }
            if (evil && diffVec.m_82553_() < 1.0) {
                this.m_146870_();
            }
        }
        ++this.time;
    }

    public void m_7380_(CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_TIME, this.time);
    }

    public void m_7378_(CompoundTag cmp) {
        super.m_7378_(cmp);
        this.time = cmp.m_128451_(TAG_TIME);
    }

    public boolean findTarget() {
        List entities;
        LivingEntity target = this.getTargetEntity();
        if (target != null) {
            if (target.m_6084_()) {
                return true;
            }
            target = null;
            this.setTarget(null);
        }
        double range = 12.0;
        AABB bounds = new AABB(this.m_20185_() - range, this.m_20186_() - range, this.m_20189_() - range, this.m_20185_() + range, this.m_20186_() + range, this.m_20189_() + range);
        if (this.isEvil()) {
            entities = this.f_19853_.m_45976_(Player.class, bounds);
        } else {
            Entity owner = this.m_37282_();
            Predicate<Entity> pred = EntitySelector.f_20403_.and(EntityMagicMissile.targetPredicate(owner));
            entities = this.f_19853_.m_6443_(LivingEntity.class, bounds, pred);
        }
        if (entities.size() > 0) {
            target = (LivingEntity)entities.get(this.f_19853_.f_46441_.nextInt(entities.size()));
            this.setTarget(target);
        }
        return target != null;
    }

    public static Predicate<Entity> targetPredicate(Entity owner) {
        return target -> {
            LivingEntity living;
            return target instanceof LivingEntity && EntityMagicMissile.shouldTarget(owner, living = (LivingEntity)target);
        };
    }

    public static boolean shouldTarget(Entity owner, LivingEntity e) {
        AbstractHorse horse;
        TamableAnimal animal;
        Mob mob;
        if (e instanceof Mob && EntityMagicMissile.isHostile(owner, (Entity)(mob = (Mob)e).m_5448_())) {
            return true;
        }
        if (e instanceof TamableAnimal && (animal = (TamableAnimal)e).m_21824_() || e instanceof AbstractHorse && (horse = (AbstractHorse)e).m_30614_()) {
            return false;
        }
        return e instanceof Enemy;
    }

    public static boolean isHostile(Entity owner, Entity attackTarget) {
        if (owner instanceof Player) {
            Player targetedPlayer;
            Player ownerPlayer = (Player)owner;
            if (attackTarget instanceof Player && ownerPlayer.m_7099_(targetedPlayer = (Player)attackTarget)) {
                return owner == attackTarget;
            }
        }
        return attackTarget instanceof Player;
    }

    protected void m_8060_(@Nonnull BlockHitResult hit) {
        super.m_8060_(hit);
        BlockState state = this.f_19853_.m_8055_(hit.m_82425_());
        if (!(this.f_19853_.f_46443_ || state.m_60734_() instanceof BushBlock || state.m_60620_((Tag)BlockTags.f_13035_))) {
            this.m_146870_();
        }
    }

    protected void m_5790_(@Nonnull EntityHitResult hit) {
        super.m_5790_(hit);
        if (!this.f_19853_.f_46443_ && hit.m_82443_() == this.getTargetEntity()) {
            this.m_146870_();
        }
    }
}

