/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.item.brew.ItemBrewBase;

public class MergeVialRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<MergeVialRecipe> SERIALIZER = new SimpleRecipeSerializer(MergeVialRecipe::new);

    public MergeVialRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level worldIn) {
        int count = 0;
        Brew brew = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (!(item instanceof ItemBrewBase)) {
                return false;
            }
            ItemBrewBase vial = (ItemBrewBase)item;
            if (brew == null) {
                brew = vial.getBrew(stack);
            } else if (brew != vial.getBrew(stack)) {
                return false;
            }
            ++count;
        }
        return count > 1;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        ItemStack firstStack = ItemStack.f_41583_;
        ItemBrewBase brew = null;
        int swigs = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (brew == null) {
                firstStack = stack.m_41777_();
                brew = (ItemBrewBase)stack.m_41720_();
            }
            if ((swigs += brew.getSwigsLeft(stack)) < brew.getSwigs()) continue;
            swigs = brew.getSwigs();
            break;
        }
        ((ItemBrewBase)Objects.requireNonNull(brew)).setSwigsLeft(firstStack, swigs);
        return firstStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        boolean foundFirst = false;
        int swigs = 0;
        int maxSwigs = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            ItemBrewBase brew = (ItemBrewBase)stack.m_41720_();
            if (!foundFirst) {
                foundFirst = true;
                swigs = brew.getSwigsLeft(stack);
                maxSwigs = brew.getSwigs();
                continue;
            }
            if ((swigs += brew.getSwigsLeft(stack)) > maxSwigs) {
                brew.setSwigsLeft(stack, swigs - maxSwigs);
                swigs = maxSwigs;
                remaining.set(i, (Object)stack.m_41777_());
                continue;
            }
            remaining.set(i, (Object)brew.getBaseStack());
        }
        return remaining;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

