/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class RecipePetals
implements IPetalRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> inputs;

    public RecipePetals(ResourceLocation id, ItemStack output, Ingredient ... inputs) {
        Preconditions.checkArgument((inputs.length <= 16 ? 1 : 0) != 0, (Object)"Cannot have more than 16 ingredients");
        this.id = id;
        this.output = output;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputs);
    }

    public boolean m_5818_(Container inv, @Nonnull Level world) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.m_6643_() && !(input = inv.m_8020_(i)).m_41619_(); ++i) {
            int stackIndex = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        return ingredientsMissing.isEmpty();
    }

    @Nonnull
    public final ItemStack m_8043_() {
        return this.output;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inv) {
        return this.m_8043_().m_41777_();
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @Nonnull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.defaultAltar);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeTypes.PETAL_SERIALIZER;
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipePetals> {
        @Nonnull
        public RecipePetals fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new RecipePetals(id, output, inputs.toArray(new Ingredient[0]));
        }

        public RecipePetals fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.m_130242_()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            ItemStack output = buf.m_130267_();
            return new RecipePetals(id, output, inputs);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull RecipePetals recipe) {
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_());
        }
    }
}

