/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.IRuneAltarRecipe;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.crafting.LexiconElvenTradeRecipe;
import vazkii.botania.common.crafting.RecipeBrew;
import vazkii.botania.common.crafting.RecipeElvenTrade;
import vazkii.botania.common.crafting.RecipeManaInfusion;
import vazkii.botania.common.crafting.RecipeMarimorphosis;
import vazkii.botania.common.crafting.RecipeOrechid;
import vazkii.botania.common.crafting.RecipeOrechidIgnem;
import vazkii.botania.common.crafting.RecipePetals;
import vazkii.botania.common.crafting.RecipePureDaisy;
import vazkii.botania.common.crafting.RecipeRuneAltar;
import vazkii.botania.common.crafting.RecipeTerraPlate;
import vazkii.botania.common.crafting.recipe.HeadRecipe;
import vazkii.botania.common.crafting.recipe.StateCopyPureDaisyRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorRecipeManager;

public class ModRecipeTypes {
    public static final RecipeType<IManaInfusionRecipe> MANA_INFUSION_TYPE = new ModRecipeType<IManaInfusionRecipe>();
    public static final RecipeSerializer<RecipeManaInfusion> MANA_INFUSION_SERIALIZER = new RecipeManaInfusion.Serializer();
    public static final RecipeType<IElvenTradeRecipe> ELVEN_TRADE_TYPE = new ModRecipeType<IElvenTradeRecipe>();
    public static final RecipeSerializer<RecipeElvenTrade> ELVEN_TRADE_SERIALIZER = new RecipeElvenTrade.Serializer();
    public static final SimpleRecipeSerializer<LexiconElvenTradeRecipe> LEXICON_ELVEN_TRADE_SERIALIZER = new SimpleRecipeSerializer(LexiconElvenTradeRecipe::new);
    public static final RecipeType<IPureDaisyRecipe> PURE_DAISY_TYPE = new ModRecipeType<IPureDaisyRecipe>();
    public static final RecipeSerializer<RecipePureDaisy> PURE_DAISY_SERIALIZER = new RecipePureDaisy.Serializer();
    public static final RecipeSerializer<StateCopyPureDaisyRecipe> COPYING_PURE_DAISY_SERIALIZER = new StateCopyPureDaisyRecipe.Serializer();
    public static final RecipeType<IBrewRecipe> BREW_TYPE = new ModRecipeType<IBrewRecipe>();
    public static final RecipeSerializer<RecipeBrew> BREW_SERIALIZER = new RecipeBrew.Serializer();
    public static final RecipeType<IPetalRecipe> PETAL_TYPE = new ModRecipeType<IPetalRecipe>();
    public static final RecipeSerializer<RecipePetals> PETAL_SERIALIZER = new RecipePetals.Serializer();
    public static final RecipeType<IRuneAltarRecipe> RUNE_TYPE = new ModRecipeType<IRuneAltarRecipe>();
    public static final RecipeSerializer<RecipeRuneAltar> RUNE_SERIALIZER = new RecipeRuneAltar.Serializer();
    public static final RecipeSerializer<HeadRecipe> RUNE_HEAD_SERIALIZER = new HeadRecipe.Serializer();
    public static final RecipeType<ITerraPlateRecipe> TERRA_PLATE_TYPE = new ModRecipeType<ITerraPlateRecipe>();
    public static final RecipeSerializer<RecipeTerraPlate> TERRA_PLATE_SERIALIZER = new RecipeTerraPlate.Serializer();
    public static final RecipeType<IOrechidRecipe> ORECHID_TYPE = new ModRecipeType<IOrechidRecipe>();
    public static final RecipeSerializer<RecipeOrechid> ORECHID_SERIALIZER = new RecipeOrechid.Serializer();
    public static final RecipeType<IOrechidRecipe> ORECHID_IGNEM_TYPE = new ModRecipeType<IOrechidRecipe>();
    public static final RecipeSerializer<RecipeOrechidIgnem> ORECHID_IGNEM_SERIALIZER = new RecipeOrechidIgnem.Serializer();
    public static final RecipeType<IOrechidRecipe> MARIMORPHOSIS_TYPE = new ModRecipeType<IOrechidRecipe>();
    public static final RecipeSerializer<RecipeMarimorphosis> MARIMORPHOSIS_SERIALIZER = new RecipeMarimorphosis.Serializer();

    public static void registerRecipeTypes(BiConsumer<RecipeSerializer<?>, ResourceLocation> r) {
        ResourceLocation id = IElvenTradeRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, ELVEN_TRADE_TYPE);
        r.accept(ELVEN_TRADE_SERIALIZER, id);
        r.accept((RecipeSerializer<?>)LEXICON_ELVEN_TRADE_SERIALIZER, ResourceLocationHelper.prefix("elven_trade_lexicon"));
        id = IManaInfusionRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, MANA_INFUSION_TYPE);
        r.accept(MANA_INFUSION_SERIALIZER, id);
        id = IPureDaisyRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, PURE_DAISY_TYPE);
        r.accept(PURE_DAISY_SERIALIZER, id);
        r.accept(COPYING_PURE_DAISY_SERIALIZER, ResourceLocationHelper.prefix("state_copying_pure_daisy"));
        id = IBrewRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, BREW_TYPE);
        r.accept(BREW_SERIALIZER, id);
        id = IPetalRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, PETAL_TYPE);
        r.accept(PETAL_SERIALIZER, id);
        id = IRuneAltarRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, RUNE_TYPE);
        r.accept(RUNE_SERIALIZER, id);
        r.accept(RUNE_HEAD_SERIALIZER, ResourceLocationHelper.prefix("runic_altar_head"));
        id = ITerraPlateRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, TERRA_PLATE_TYPE);
        r.accept(TERRA_PLATE_SERIALIZER, id);
        id = IOrechidRecipe.TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, ORECHID_TYPE);
        r.accept(ORECHID_SERIALIZER, id);
        id = IOrechidRecipe.IGNEM_TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, ORECHID_IGNEM_TYPE);
        r.accept(ORECHID_IGNEM_SERIALIZER, id);
        id = IOrechidRecipe.MARIMORPHOSIS_TYPE_ID;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)id, MARIMORPHOSIS_TYPE);
        r.accept(MARIMORPHOSIS_SERIALIZER, id);
    }

    public static <C extends Container, T extends Recipe<C>> Map<ResourceLocation, Recipe<C>> getRecipes(Level world, RecipeType<T> type) {
        return ((AccessorRecipeManager)world.m_7465_()).botania_getAll(type);
    }

    private static class ModRecipeType<T extends Recipe<?>>
    implements RecipeType<T> {
        private ModRecipeType() {
        }

        public String toString() {
            return Registry.f_122864_.m_7981_((Object)this).toString();
        }
    }
}

