/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IManaDissolvable;
import vazkii.botania.api.mana.IKeyLocked;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.spark.IManaSpark;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.IThrottledPacket;
import vazkii.botania.common.block.tile.mana.TileBellows;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.proxy.IProxy;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class TilePool
extends TileMod
implements IManaPool,
IKeyLocked,
ISparkAttachable,
IThrottledPacket,
IWandable {
    public static final int PARTICLE_COLOR = 50943;
    public static final int MAX_MANA = 1000000;
    private static final int MAX_MANA_DILLUTED = 10000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_OUTPUTTING = "outputting";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA_CAP = "manaCap";
    private static final String TAG_CAN_ACCEPT = "canAccept";
    private static final String TAG_CAN_SPARE = "canSpare";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    private boolean outputting = false;
    private DyeColor color = DyeColor.WHITE;
    private int mana;
    public int manaCap = -1;
    private int soundTicks = 0;
    private boolean canAccept = true;
    private boolean canSpare = true;
    boolean isDoingTransfer = false;
    int ticksDoingTransfer = 0;
    private String inputKey = "";
    private final String outputKey = "";
    private int ticks = 0;
    private boolean sendPacket = false;

    public TilePool(BlockPos pos, BlockState state) {
        super(ModTiles.POOL, pos, state);
    }

    @Override
    public boolean isFull() {
        BlockState stateBelow = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
        return !stateBelow.m_60713_(ModBlocks.manaVoid) && this.getCurrentMana() >= this.manaCap;
    }

    @Override
    public void receiveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.manaCap));
        if (old != this.mana) {
            this.m_6596_();
            this.markDispatchable();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        IXplatAbstractions.INSTANCE.fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
    }

    public static int calculateComparatorLevel(int mana, int max) {
        int val = (int)((double)mana / (double)max * 15.0);
        if (mana > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    public static List<IManaInfusionRecipe> manaInfusionRecipes(Level world) {
        return ModRecipeTypes.getRecipes(world, ModRecipeTypes.MANA_INFUSION_TYPE).values().stream().filter(r -> r instanceof IManaInfusionRecipe).map(r -> (IManaInfusionRecipe)r).collect(Collectors.toList());
    }

    public IManaInfusionRecipe getMatchingRecipe(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        ArrayList<IManaInfusionRecipe> matchingNonCatRecipes = new ArrayList<IManaInfusionRecipe>();
        ArrayList<IManaInfusionRecipe> matchingCatRecipes = new ArrayList<IManaInfusionRecipe>();
        for (IManaInfusionRecipe recipe : TilePool.manaInfusionRecipes(this.f_58857_)) {
            if (!recipe.matches(stack)) continue;
            if (recipe.getRecipeCatalyst() == null) {
                matchingNonCatRecipes.add(recipe);
                continue;
            }
            if (!recipe.getRecipeCatalyst().test(state)) continue;
            matchingCatRecipes.add(recipe);
        }
        return !matchingCatRecipes.isEmpty() ? (IManaInfusionRecipe)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (IManaInfusionRecipe)matchingNonCatRecipes.get(0) : null);
    }

    public boolean collideEntityItem(ItemEntity item) {
        if (this.f_58857_.f_46443_ || !item.m_6084_() || item.m_32055_().m_41619_()) {
            return false;
        }
        ItemStack stack = item.m_32055_();
        Item item2 = stack.m_41720_();
        if (item2 instanceof IManaDissolvable) {
            IManaDissolvable dissolvable = (IManaDissolvable)item2;
            dissolvable.onDissolveTick(this, stack, item);
        }
        if (IXplatAbstractions.INSTANCE.itemFlagsComponent(item).getManaInfusionCooldown() > 0) {
            return false;
        }
        IManaInfusionRecipe recipe = this.getMatchingRecipe(stack, this.f_58857_.m_8055_(this.f_58858_.m_7495_()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.receiveMana(-mana);
                ItemStack output = recipe.getRecipeOutput(stack);
                stack.m_41774_(1);
                item.m_6853_(false);
                ItemEntity outputItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, output);
                IXplatAbstractions.INSTANCE.itemFlagsComponent(outputItem).markNewlyInfused();
                this.f_58857_.m_7967_((Entity)outputItem);
                this.craftingFanciness();
                return true;
            }
        }
        return false;
    }

    private void craftingFanciness() {
        if (this.soundTicks == 0) {
            this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.manaPoolCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.soundTicks = 6;
        }
        this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 0);
    }

    public boolean m_7531_(int event, int param) {
        switch (event) {
            case 0: {
                if (this.f_58857_.f_46443_) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.f_58858_.m_123342_() + 0.75, (double)this.f_58858_.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
            case 1: {
                if (this.f_58857_.f_46443_ && BotaniaConfig.common().chargingAnimationEnabled()) {
                    boolean outputting = param == 1;
                    Vec3 itemVec = Vec3.m_82528_((Vec3i)this.f_58858_).m_82520_(0.5, 0.5 + Math.random() * 0.3, 0.5);
                    Vec3 tileVec = Vec3.m_82528_((Vec3i)this.f_58858_).m_82520_(0.2 + Math.random() * 0.6, 0.0, 0.2 + Math.random() * 0.6);
                    IProxy.INSTANCE.lightningFX(outputting ? tileVec : itemVec, outputting ? itemVec : tileVec, 80.0f, this.f_58857_.f_46441_.nextLong(), 1140881820, 1140901631);
                }
                return true;
            }
        }
        return super.m_7531_(event, param);
    }

    private void initManaCapAndNetwork() {
        if (this.manaCap == -1) {
            int n = this.manaCap = ((BlockPool)this.m_58900_().m_60734_()).variant == BlockPool.Variant.DILUTED ? 10000 : 1000000;
        }
        if (!ManaNetworkHandler.instance.isPoolIn(this) && !this.m_58901_()) {
            IXplatAbstractions.INSTANCE.fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, TilePool self) {
        self.initManaCapAndNetwork();
        double particleChance = 1.0 - (double)self.getCurrentMana() / (double)self.manaCap * 0.1;
        if (Math.random() > particleChance) {
            float red = 0.0f;
            float green = 0.7764706f;
            float blue = 1.0f;
            WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, red, green, blue, 2.0f);
            level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + 0.3 + Math.random() * 0.5, (double)worldPosition.m_123342_() + 0.6 + Math.random() * 0.25, (double)worldPosition.m_123343_() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, TilePool self) {
        self.initManaCapAndNetwork();
        boolean wasDoingTransfer = self.isDoingTransfer;
        self.isDoingTransfer = false;
        if (self.soundTicks > 0) {
            --self.soundTicks;
        }
        if (self.sendPacket && self.ticks % 10 == 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            self.sendPacket = false;
        }
        List items = level.m_45976_(ItemEntity.class, new AABB(worldPosition, worldPosition.m_142082_(1, 1, 1)));
        for (ItemEntity item : items) {
            Item item2;
            ItemStack stack;
            if (!item.m_6084_() || (stack = item.m_32055_()).m_41619_() || !((item2 = stack.m_41720_()) instanceof IManaItem)) continue;
            IManaItem mana = (IManaItem)item2;
            if ((!self.outputting || !mana.canReceiveManaFromPool(stack, self)) && (self.outputting || !mana.canExportManaToPool(stack, self))) continue;
            boolean didSomething = false;
            int bellowCount = 0;
            if (self.outputting) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    TileBellows bellows;
                    BlockEntity tile = level.m_7702_(worldPosition.m_142300_(dir));
                    if (!(tile instanceof TileBellows) || (bellows = (TileBellows)tile).getLinkedTile() != self) continue;
                    ++bellowCount;
                }
            }
            int transfRate = 1000 * (bellowCount + 1);
            if (self.outputting) {
                if (self.canSpare) {
                    if (self.getCurrentMana() > 0 && mana.getMana(stack) < mana.getMaxMana(stack)) {
                        didSomething = true;
                    }
                    int manaVal = Math.min(transfRate, Math.min(self.getCurrentMana(), mana.getMaxMana(stack) - mana.getMana(stack)));
                    mana.addMana(stack, manaVal);
                    self.receiveMana(-manaVal);
                }
            } else if (self.canAccept) {
                int manaVal;
                if (mana.getMana(stack) > 0 && !self.isFull()) {
                    didSomething = true;
                }
                if ((manaVal = Math.min(transfRate, Math.min(self.manaCap - self.getCurrentMana(), mana.getMana(stack)))) == 0 && self.f_58857_.m_8055_(worldPosition.m_7495_()).m_60713_(ModBlocks.manaVoid)) {
                    manaVal = Math.min(transfRate, mana.getMana(stack));
                }
                mana.addMana(stack, -manaVal);
                self.receiveMana(manaVal);
            }
            if (!didSomething) continue;
            if (BotaniaConfig.common().chargingAnimationEnabled() && level.f_46441_.nextInt(20) == 0) {
                level.m_7696_(worldPosition, state.m_60734_(), 1, self.outputting ? 1 : 0);
            }
            self.isDoingTransfer = self.outputting;
        }
        if (self.isDoingTransfer) {
            ++self.ticksDoingTransfer;
        } else {
            self.ticksDoingTransfer = 0;
            if (wasDoingTransfer) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        }
        ++self.ticks;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_MANA, this.mana);
        cmp.m_128379_(TAG_OUTPUTTING, this.outputting);
        cmp.m_128405_(TAG_COLOR, this.color.m_41060_());
        cmp.m_128405_(TAG_MANA_CAP, this.manaCap);
        cmp.m_128379_(TAG_CAN_ACCEPT, this.canAccept);
        cmp.m_128379_(TAG_CAN_SPARE, this.canSpare);
        cmp.m_128359_(TAG_INPUT_KEY, this.inputKey);
        cmp.m_128359_(TAG_OUTPUT_KEY, "");
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.mana = cmp.m_128451_(TAG_MANA);
        this.outputting = cmp.m_128471_(TAG_OUTPUTTING);
        this.color = DyeColor.m_41053_((int)cmp.m_128451_(TAG_COLOR));
        if (cmp.m_128441_(TAG_MANA_CAP)) {
            this.manaCap = cmp.m_128451_(TAG_MANA_CAP);
        }
        if (cmp.m_128441_(TAG_CAN_ACCEPT)) {
            this.canAccept = cmp.m_128471_(TAG_CAN_ACCEPT);
        }
        if (cmp.m_128441_(TAG_CAN_SPARE)) {
            this.canSpare = cmp.m_128471_(TAG_CAN_SPARE);
        }
        if (cmp.m_128441_(TAG_INPUT_KEY)) {
            this.inputKey = cmp.m_128461_(TAG_INPUT_KEY);
        }
        if (cmp.m_128441_(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.m_128461_(TAG_OUTPUT_KEY);
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.m_6144_()) {
            this.outputting = !this.outputting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public int getCurrentMana() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof BlockPool) {
            BlockPool pool = (BlockPool)block;
            return pool.variant == BlockPool.Variant.CREATIVE ? 1000000 : this.mana;
        }
        return 0;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    @Override
    public IManaSpark getAttachedSpark() {
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_142082_(1, 1, 1)), (Predicate)Predicates.instanceOf(IManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (IManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int getAvailableSpaceForMana() {
        int space = Math.max(0, this.manaCap - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60713_(ModBlocks.manaVoid)) {
            return this.manaCap;
        }
        return 0;
    }

    @Override
    public DyeColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(DyeColor color) {
        this.color = color;
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Override
    public void markDispatchable() {
        this.sendPacket = true;
    }

    public static class WandHud
    implements IWandHUD {
        private final TilePool pool;

        public WandHud(TilePool pool) {
            this.pool = pool;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            ItemStack poolStack = new ItemStack((ItemLike)this.pool.m_58900_().m_60734_());
            String name = poolStack.m_41786_().getString();
            int color = 0x4444FF;
            BotaniaAPIClient.instance().drawSimpleManaHUD(ms, color, this.pool.getCurrentMana(), this.pool.manaCap, name);
            int x = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - 11;
            int y = Minecraft.m_91087_().m_91268_().m_85446_() / 2 + 30;
            int u = this.pool.outputting ? 22 : 0;
            int v = 38;
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            RenderSystem.m_157456_((int)0, (ResourceLocation)HUDHandler.manaBar);
            RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 22, 15);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ItemStack tablet = new ItemStack((ItemLike)ModItems.manaTablet);
            ItemManaTablet.setStackCreative(tablet);
            mc.m_91291_().m_115203_(tablet, x - 20, y);
            mc.m_91291_().m_115203_(poolStack, x + 26, y);
            RenderSystem.m_69461_();
        }
    }
}

