/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.ModStats;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TileTinyPotato
extends TileExposedSimpleInventory
implements Nameable {
    private static final String TAG_NAME = "name";
    private static final int JUMP_EVENT = 0;
    public int jumpTicks = 0;
    public Component name = new TextComponent("");
    private int nextDoIt = 0;

    public TileTinyPotato(BlockPos pos, BlockState state) {
        super(ModTiles.TINY_POTATO, pos, state);
    }

    public void interact(Player player, InteractionHand hand, ItemStack stack, Direction side) {
        int index = side.m_122411_();
        if (index >= 0) {
            ItemStack stackAt = this.getItemHandler().m_8020_(index);
            if (!stackAt.m_41619_() && stack.m_41619_()) {
                player.m_21008_(hand, stackAt);
                this.getItemHandler().m_6836_(index, ItemStack.f_41583_);
            } else if (!stack.m_41619_()) {
                ItemStack copy = stack.m_41620_(1);
                if (stack.m_41619_()) {
                    player.m_21008_(hand, stackAt);
                } else if (!stackAt.m_41619_()) {
                    player.m_150109_().m_150079_(stackAt);
                }
                this.getItemHandler().m_6836_(index, copy);
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.jump();
            if (this.name.getString().toLowerCase(Locale.ROOT).trim().endsWith("shia labeouf") && this.nextDoIt == 0) {
                this.nextDoIt = 40;
                this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.doit, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            for (int i = 0; i < this.inventorySize(); ++i) {
                ItemStack stackAt = this.getItemHandler().m_8020_(i);
                if (stackAt.m_41619_() || !stackAt.m_150930_(ModBlocks.tinyPotato.m_5456_())) continue;
                player.m_6352_((Component)new TextComponent("Don't talk to me or my son ever again."), Util.f_137441_);
                return;
            }
            player.m_36220_(ModStats.TINY_POTATOES_PETTED);
            PlayerHelper.grantCriterion((ServerPlayer)player, ResourceLocationHelper.prefix("main/tiny_potato_pet"), "code_triggered");
        }
    }

    private void jump() {
        if (this.jumpTicks == 0) {
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 0, 20);
        }
    }

    public boolean m_7531_(int id, int param) {
        if (id == 0) {
            this.jumpTicks = param;
            return true;
        }
        return super.m_7531_(id, param);
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileTinyPotato self) {
        if (self.jumpTicks > 0) {
            --self.jumpTicks;
        }
        if (!level.f_46443_) {
            if (level.f_46441_.nextInt(100) == 0) {
                self.jump();
            }
            if (self.nextDoIt > 0) {
                --self.nextDoIt;
            }
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        super.writePacketNBT(cmp);
        cmp.m_128359_(TAG_NAME, Component.Serializer.m_130703_((Component)this.name));
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        super.readPacketNBT(cmp);
        this.name = Component.Serializer.m_130701_((String)cmp.m_128461_(TAG_NAME));
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(6);
    }

    @Nonnull
    public Component m_7755_() {
        return new TranslatableComponent(ModBlocks.tinyPotato.m_7705_());
    }

    @Nullable
    public Component m_7770_() {
        return this.name.getString().isEmpty() ? null : this.name;
    }

    @Nonnull
    public Component m_5446_() {
        return this.m_8077_() ? this.m_7770_() : this.m_7755_();
    }
}

