/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.lib.ModTags;

public class TileCocoon
extends TileMod {
    private static final String TAG_TIME_PASSED = "timePassed";
    private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
    private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
    private static final String TAG_GAIA_SPIRIT_GIVEN = "gaiaSpiritGiven";
    public static final int TOTAL_TIME = 2400;
    public static final int MAX_EMERALDS = 20;
    public static final int MAX_CHORUS_FRUITS = 20;
    private static final float SPECIAL_CHANCE = 0.075f;
    public int timePassed;
    public int emeraldsGiven;
    public int chorusFruitGiven;
    public boolean gaiaSpiritGiven;

    public TileCocoon(BlockPos pos, BlockState state) {
        super(ModTiles.COCOON, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileCocoon self) {
        ++self.timePassed;
        if (self.timePassed >= 2400) {
            self.hatch();
        }
    }

    private void hatch() {
        if (!this.f_58857_.f_46443_) {
            this.timePassed = 0;
            this.f_58857_.m_46961_(this.f_58858_, false);
            Mob entity = null;
            BlockPos placePos = this.f_58858_;
            float rareChance = this.gaiaSpiritGiven ? 1.0f : 0.075f;
            float villagerChance = Math.min(1.0f, (float)this.emeraldsGiven / 20.0f);
            float shulkerChance = Math.min(1.0f, (float)this.chorusFruitGiven / 20.0f);
            ArrayList<BlockPos> validWater = new ArrayList<BlockPos>();
            for (Direction d : Direction.values()) {
                BlockPos blockPos;
                BlockPos blockPos2 = blockPos = d == Direction.UP ? this.f_58858_ : this.f_58858_.m_142300_(d);
                if (!this.f_58857_.m_46805_(blockPos) || !this.f_58857_.m_8055_(blockPos).m_60713_(Blocks.f_49990_)) continue;
                validWater.add(blockPos);
            }
            if (Math.random() < (double)shulkerChance) {
                entity = (Mob)EntityType.f_20521_.m_20615_(this.f_58857_);
            } else if (Math.random() < (double)villagerChance) {
                Villager villager = (Villager)EntityType.f_20492_.m_20615_(this.f_58857_);
                if (villager != null) {
                    VillagerType type = VillagerType.m_35835_((Optional)this.f_58857_.m_45837_(this.f_58858_));
                    villager.m_141967_(villager.m_7141_().m_35567_(type));
                }
                entity = villager;
            } else if (!validWater.isEmpty()) {
                placePos = (BlockPos)validWater.get(this.f_58857_.f_46441_.nextInt(validWater.size()));
                entity = Math.random() < (double)rareChance ? this.random((Tag<EntityType<?>>)ModTags.Entities.COCOON_RARE_AQUATIC) : this.random((Tag<EntityType<?>>)ModTags.Entities.COCOON_COMMON_AQUATIC);
            } else {
                entity = Math.random() < (double)rareChance ? this.random((Tag<EntityType<?>>)ModTags.Entities.COCOON_RARE) : this.random((Tag<EntityType<?>>)ModTags.Entities.COCOON_COMMON);
            }
            if (entity != null) {
                if ((double)this.f_58857_.f_46441_.nextFloat() < 0.01) {
                    TextComponent name = new TextComponent("Jeanne d'");
                    name.m_7220_(entity.m_7755_());
                    name.m_7220_((Component)new TextComponent(" [SSR]"));
                    entity.m_6593_((Component)name.m_130940_(ChatFormatting.GOLD));
                    entity.m_20340_(true);
                }
                entity.m_6034_((double)placePos.m_123341_() + 0.5, (double)placePos.m_123342_() + 0.5, (double)placePos.m_123343_() + 0.5);
                if (entity instanceof AgeableMob) {
                    AgeableMob ageable = (AgeableMob)entity;
                    ageable.m_146762_(-24000);
                }
                entity.m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(this.m_58899_()), MobSpawnType.EVENT, null, null);
                entity.m_21530_();
                this.f_58857_.m_7967_((Entity)entity);
                entity.m_21373_();
            }
        }
    }

    public void forceRare() {
        this.gaiaSpiritGiven = true;
        this.timePassed = Math.max(this.timePassed, 1200);
    }

    private Mob random(Tag<EntityType<?>> tag) {
        Entity entity;
        EntityType type = (EntityType)tag.m_13288_(this.f_58857_.f_46441_);
        if (type == EntityType.f_20557_ && (double)this.f_58857_.f_46441_.nextFloat() < 0.01) {
            type = EntityType.f_20504_;
        }
        return (entity = type.m_20615_(this.f_58857_)) instanceof Mob ? (Mob)entity : null;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_TIME_PASSED, this.timePassed);
        cmp.m_128405_(TAG_EMERALDS_GIVEN, this.emeraldsGiven);
        cmp.m_128405_(TAG_CHORUS_FRUIT_GIVEN, this.chorusFruitGiven);
        cmp.m_128379_(TAG_GAIA_SPIRIT_GIVEN, this.gaiaSpiritGiven);
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.timePassed = cmp.m_128451_(TAG_TIME_PASSED);
        this.emeraldsGiven = cmp.m_128451_(TAG_EMERALDS_GIVEN);
        this.chorusFruitGiven = cmp.m_128451_(TAG_CHORUS_FRUIT_GIVEN);
        this.gaiaSpiritGiven = cmp.m_128471_(TAG_GAIA_SPIRIT_GIVEN);
    }
}

