/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.block.subtile.generating.SubTileDandelifeon;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TileCell
extends TileMod {
    private static final String TAG_GENERATION = "generation";
    private static final String TAG_TICKED = "ticked";
    private static final String TAG_FLOWER_X = "flowerX";
    private static final String TAG_FLOWER_Y = "flowerY";
    private static final String TAG_FLOWER_Z = "flowerZ";
    private static final String TAG_VALID_X = "validX";
    private static final String TAG_VALID_Y = "validY";
    private static final String TAG_VALID_Z = "validZ";
    private int generation;
    private boolean ticked;
    private BlockPos flowerCoords = new BlockPos(0, Integer.MIN_VALUE, 0);
    private BlockPos validCoords = new BlockPos(0, Integer.MIN_VALUE, 0);

    public TileCell(BlockPos pos, BlockState state) {
        super(ModTiles.CELL_BLOCK, pos, state);
    }

    public void setGeneration(SubTileDandelifeon flower, int gen) {
        this.generation = gen;
        if (!this.ticked) {
            this.flowerCoords = flower.getEffectivePos();
            this.validCoords = this.m_58899_();
            this.ticked = true;
        } else if (!this.validCoords.equals((Object)this.m_58899_()) || !this.flowerCoords.equals((Object)flower.getEffectivePos())) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public boolean isSameFlower(SubTileDandelifeon flower) {
        return this.validCoords.equals((Object)this.m_58899_()) && this.flowerCoords.equals((Object)flower.getEffectivePos());
    }

    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_GENERATION, this.generation);
        cmp.m_128379_(TAG_TICKED, this.ticked);
        if (this.ticked) {
            cmp.m_128405_(TAG_FLOWER_X, this.flowerCoords.m_123341_());
            cmp.m_128405_(TAG_FLOWER_Y, this.flowerCoords.m_123342_());
            cmp.m_128405_(TAG_FLOWER_Z, this.flowerCoords.m_123343_());
            cmp.m_128405_(TAG_VALID_X, this.validCoords.m_123341_());
            cmp.m_128405_(TAG_VALID_Y, this.validCoords.m_123342_());
            cmp.m_128405_(TAG_VALID_Z, this.validCoords.m_123343_());
        }
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.generation = cmp.m_128451_(TAG_GENERATION);
        this.ticked = cmp.m_128471_(TAG_TICKED);
        if (this.ticked) {
            this.flowerCoords = new BlockPos(cmp.m_128451_(TAG_FLOWER_X), cmp.m_128451_(TAG_FLOWER_Y), cmp.m_128451_(TAG_FLOWER_Z));
            this.validCoords = new BlockPos(cmp.m_128451_(TAG_VALID_X), cmp.m_128451_(TAG_VALID_Y), cmp.m_128451_(TAG_VALID_Z));
        }
    }
}

