/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TilePlatform;

public class BlockPlatform
extends BlockMod
implements IManaCollisionGhost,
EntityBlock {
    private final Variant variant;

    public BlockPlatform(@Nonnull Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    public Variant getVariant() {
        return this.variant;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        TilePlatform platform;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TilePlatform && (platform = (TilePlatform)te).getCamoState() != null) {
            return platform.getCamoState().m_60808_(world, pos);
        }
        return super.m_5940_(state, world, pos, context);
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext context) {
        if (this.variant.collide.test(pos, context)) {
            return super.m_5940_(state, world, pos, context);
        }
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TilePlatform(pos, state);
    }

    @Override
    public boolean isGhost(BlockState state, Level world, BlockPos pos) {
        return true;
    }

    public static boolean isValidBlock(@Nullable BlockState state, Level world, BlockPos pos) {
        return state != null && (state.m_60804_((BlockGetter)world, pos) || state.m_60799_() == RenderShape.MODEL);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.variant.indestructible) {
            tooltip.add((Component)new TranslatableComponent("botaniamisc.creative").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.m_7702_(pos);
        ItemStack currentStack = player.m_21120_(hand);
        if (this.variant.indestructible && !player.m_7500_()) {
            return InteractionResult.PASS;
        }
        if (!currentStack.m_41619_() && Block.m_49814_((Item)currentStack.m_41720_()) != Blocks.f_50016_ && tile instanceof TilePlatform) {
            TilePlatform camo = (TilePlatform)tile;
            BlockPlaceContext ctx = new BlockPlaceContext(player, hand, currentStack, hit);
            BlockState changeState = Block.m_49814_((Item)currentStack.m_41720_()).m_5573_(ctx);
            if (BlockPlatform.isValidBlock(changeState, world, pos) && !(changeState.m_60734_() instanceof BlockPlatform) && changeState.m_60767_() != Material.f_76296_) {
                if (!world.f_46443_) {
                    camo.setCamoState(changeState);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static enum Variant {
        ABSTRUSE(false, (pos, context) -> {
            if (context instanceof EntityCollisionContext) {
                EntityCollisionContext econtext = (EntityCollisionContext)context;
                Entity e = econtext.m_193113_();
                return e == null || e.m_20186_() > (double)pos.m_123342_() + 0.9 && !context.m_6226_();
            }
            return true;
        }),
        SPECTRAL(false, (pos, context) -> false),
        INFRANGIBLE(true, (pos, context) -> true);

        public final boolean indestructible;
        public final BiPredicate<BlockPos, CollisionContext> collide;

        private Variant(boolean i, BiPredicate<BlockPos, CollisionContext> p) {
            this.indestructible = i;
            this.collide = p;
        }
    }
}

