/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileHourglass;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.item.ModItems;

public class BlockHourglass
extends BlockModWaterloggable
implements IManaTrigger,
EntityBlock {
    private static final VoxelShape SHAPE = BlockHourglass.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)18.4, (double)12.0);

    protected BlockHourglass(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61448_});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileHourglass hourglass = (TileHourglass)world.m_7702_(pos);
        ItemStack hgStack = hourglass.getItemHandler().m_8020_(0);
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_150930_(ModItems.twigWand)) {
            return InteractionResult.PASS;
        }
        if (hourglass.lock) {
            if (!player.f_19853_.f_46443_ && hand == InteractionHand.OFF_HAND) {
                player.m_6352_((Component)new TranslatableComponent("botaniamisc.hourglassLock"), Util.f_137441_);
            }
            return InteractionResult.FAIL;
        }
        if (hgStack.m_41619_() && TileHourglass.getStackItemTime(stack) > 0) {
            hourglass.getItemHandler().m_6836_(0, stack.m_41777_());
            stack.m_41764_(0);
            return InteractionResult.SUCCESS;
        }
        if (!hgStack.m_41619_()) {
            player.m_150109_().m_150079_(hgStack);
            hourglass.getItemHandler().m_6836_(0, ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? 15 : 0;
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileHourglass(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockHourglass.createTickerHelper(type, ModTiles.HOURGLASS, TileHourglass::commonTick);
    }

    @Override
    public void onBurstCollision(IManaBurst burst, Level world, BlockPos pos) {
        if (!burst.isFake()) {
            TileHourglass tile = (TileHourglass)world.m_7702_(pos);
            tile.onManaCollide();
        }
    }
}

