/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.ModelHourglass;
import vazkii.botania.common.block.tile.TileHourglass;

public class RenderTileHourglass
implements BlockEntityRenderer<TileHourglass> {
    final ResourceLocation texture = new ResourceLocation("botania:textures/model/hourglass.png");
    private final ModelHourglass model;

    public RenderTileHourglass(BlockEntityRendererProvider.Context ctx) {
        this.model = new ModelHourglass(ctx.m_173582_(ModModelLayers.HOURGLASS));
    }

    public void render(@Nullable TileHourglass hourglass, float ticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        float rot;
        int wtime;
        ms.m_85836_();
        boolean hasWorld = hourglass != null && hourglass.m_58904_() != null;
        int n = wtime = !hasWorld ? 0 : ClientTickHandler.ticksInGame;
        if (wtime != 0) {
            wtime += new Random(hourglass.m_58899_().hashCode()).nextInt(360);
        }
        float time = wtime == 0 ? 0.0f : (float)wtime + ticks;
        float x = 0.5f + (float)Math.cos(time * 0.05f) * 0.025f;
        float y = 0.55f + (float)(Math.sin(time * 0.04f) + 1.0) * 0.05f;
        float z = 0.5f + (float)Math.sin(time * 0.05f) * 0.025f;
        ItemStack stack = hasWorld ? hourglass.getItemHandler().m_8020_(0) : ItemStack.f_41583_;
        float activeFraction = stack.m_41619_() ? 0.0f : hourglass.lastFraction + (hourglass.timeFraction - hourglass.lastFraction) * ticks;
        float fract1 = stack.m_41619_() ? 0.0f : activeFraction;
        float fract2 = stack.m_41619_() ? 0.0f : 1.0f - activeFraction;
        ms.m_85837_((double)x, (double)y, (double)z);
        float f = rot = hasWorld && hourglass.flip ? 180.0f : 1.0f;
        if (hasWorld && hourglass.flipTicks > 0) {
            rot += ((float)hourglass.flipTicks - ticks) * 45.0f;
        }
        ms.m_85845_(Vector3f.f_122227_.m_122240_(rot));
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        int color = hasWorld ? hourglass.getColor() : 0;
        float r = (float)(color >> 16) / 255.0f;
        float g = (float)(color >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        VertexConsumer buffer = buffers.m_6299_(this.model.m_103119_(this.texture));
        this.model.render(ms, buffer, light, overlay, r, g, b, 1.0f, fract1, fract2, hasWorld && hourglass.flip);
        ms.m_85849_();
    }
}

