/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import vazkii.botania.api.block.IPetalApothecary;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.TileAltar;

public class RenderTileAltar
implements BlockEntityRenderer<TileAltar> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public RenderTileAltar(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.m_173584_();
    }

    public void render(@Nonnull TileAltar altar, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        boolean lava;
        ms.m_85836_();
        ms.m_85837_(0.5, 1.5, 0.5);
        boolean water = altar.getFluid() == IPetalApothecary.State.WATER;
        boolean bl = lava = altar.getFluid() == IPetalApothecary.State.LAVA;
        if (water || lava) {
            ms.m_85836_();
            float s = 0.0390625f;
            float v = 0.125f;
            float w = -v * 2.5f;
            if (water) {
                int petals = 0;
                for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().m_8020_(i).m_41619_(); ++i) {
                    ++petals;
                }
                if (petals > 0) {
                    float modifier = 6.0f;
                    float rotationModifier = 0.25f;
                    float radiusBase = 1.2f;
                    float radiusMod = 0.1f;
                    double ticks = (double)((float)ClientTickHandler.ticksInGame + pticks) * 0.5;
                    float offsetPerPetal = 360 / petals;
                    ms.m_85836_();
                    ms.m_85837_((double)-0.05f, -0.5, 0.0);
                    ms.m_85841_(v, v, v);
                    for (int i = 0; i < petals; ++i) {
                        float offset = offsetPerPetal * (float)i;
                        float deg = (int)(ticks / 0.25 % 360.0 + (double)offset);
                        float rad = deg * (float)Math.PI / 180.0f;
                        float radiusX = (float)((double)1.2f + (double)0.1f * Math.sin(ticks / 6.0));
                        float radiusZ = (float)((double)1.2f + (double)0.1f * Math.cos(ticks / 6.0));
                        float x = (float)((double)radiusX * Math.cos(rad));
                        float z = (float)((double)radiusZ * Math.sin(rad));
                        float y = (float)Math.cos((ticks + (double)(50 * i)) / 5.0) / 10.0f;
                        ms.m_85836_();
                        ms.m_85837_((double)x, (double)y, (double)z);
                        float xRotate = (float)Math.sin(ticks * 0.25) / 2.0f;
                        float yRotate = (float)Math.max((double)0.6f, Math.sin(ticks * (double)0.1f) / 2.0 + 0.5);
                        float zRotate = (float)Math.cos(ticks * 0.25) / 2.0f;
                        ms.m_85837_((double)(v /= 2.0f), (double)v, (double)v);
                        ms.m_85845_(new Vector3f(xRotate, yRotate, zRotate).m_122240_(deg));
                        ms.m_85837_((double)(-v), (double)(-v), (double)(-v));
                        v *= 2.0f;
                        ItemStack stack = altar.getItemHandler().m_8020_(i);
                        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, light, overlay, ms, buffers, 0);
                        ms.m_85849_();
                    }
                    ms.m_85849_();
                }
            }
            float alpha = lava ? 1.0f : 0.7f;
            ms.m_85837_((double)w, (double)-0.3f, (double)w);
            ms.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            ms.m_85841_(s, s, s);
            TextureAtlasSprite sprite = lava ? this.blockRenderDispatcher.m_110910_(Blocks.f_49991_.m_49966_()).m_6160_() : this.blockRenderDispatcher.m_110910_(Blocks.f_49990_.m_49966_()).m_6160_();
            int color = lava ? -1 : BiomeColors.m_108811_((BlockAndTintGetter)altar.m_58904_(), (BlockPos)altar.m_58899_());
            VertexConsumer buffer = buffers.m_6299_(Sheets.m_110792_());
            this.renderIcon(ms, buffer, sprite, color, alpha, overlay, lava ? 0xF000F0 : light);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    private void renderIcon(PoseStack ms, VertexConsumer builder, TextureAtlasSprite sprite, int color, float alpha, int overlay, int light) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f mat = ms.m_85850_().m_85861_();
        builder.m_85982_(mat, 0.0f, 16.0f, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(mat, 16.0f, 16.0f, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(mat, 16.0f, 0.0f, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_6122_(red, green, blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }
}

