/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.FloatingFlowerImpl;
import vazkii.botania.api.block.IFloatingFlower;
import vazkii.botania.api.block.IFloatingFlowerProvider;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.tile.string.TileRedStringRelay;
import vazkii.botania.common.lib.ModTags;

public abstract class TileEntitySpecialFlower
extends BlockEntity
implements IFloatingFlowerProvider {
    public static final int PODZOL_DELAY = 5;
    public static final int MYCELIUM_DELAY = 10;
    private final IFloatingFlower floatingData = new FloatingFlowerImpl(){

        @Override
        public ItemStack getDisplayStack() {
            ResourceLocation id = Registry.f_122830_.m_7981_((Object)TileEntitySpecialFlower.this.m_58903_());
            return Registry.f_122827_.m_6612_(id).map(ItemStack::new).orElse(super.getDisplayStack());
        }
    };
    public int ticksExisted = 0;
    public boolean overgrowth = false;
    public boolean overgrowthBoost = false;
    private BlockPos positionOverride;
    private boolean isFloating;
    public static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_FLOATING_DATA = "floating";

    public TileEntitySpecialFlower(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileEntitySpecialFlower self) {
        BlockEntity tileBelow;
        if (self.isFloating != state.m_60620_(ModTags.Blocks.FLOATING_FLOWERS)) {
            BotaniaAPI.LOGGER.error("Special flower changed floating state, this is not supported!", new Throwable());
            boolean bl = self.isFloating = !self.isFloating;
        }
        if ((tileBelow = level.m_7702_(worldPosition.m_7495_())) instanceof TileRedStringRelay) {
            TileRedStringRelay relay = (TileRedStringRelay)tileBelow;
            BlockPos coords = relay.getBinding();
            if (coords != null) {
                self.positionOverride = coords;
                self.tickFlower();
                return;
            }
            self.positionOverride = null;
        } else {
            self.positionOverride = null;
        }
        boolean special = self.isOnSpecialSoil();
        if (special) {
            self.overgrowth = true;
            if (self.isOvergrowthAffected()) {
                self.tickFlower();
                self.overgrowthBoost = true;
            }
        }
        self.tickFlower();
        self.overgrowth = false;
        self.overgrowthBoost = false;
    }

    @Override
    @Nullable
    public IFloatingFlower getFloatingData() {
        if (this.m_58898_() && this.isFloating()) {
            return this.floatingData;
        }
        return null;
    }

    public final boolean isFloating() {
        return this.isFloating;
    }

    public final void setFloating(boolean floating) {
        this.isFloating = floating;
    }

    private boolean isOnSpecialSoil() {
        if (this.isFloating()) {
            return false;
        }
        return this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60713_(ModBlocks.enchantedSoil);
    }

    public final BlockPos getEffectivePos() {
        return this.positionOverride != null ? this.positionOverride : this.m_58899_();
    }

    protected void tickFlower() {
        ++this.ticksExisted;
    }

    public final void m_142466_(CompoundTag cmp) {
        super.m_142466_(cmp);
        if (cmp.m_128441_(TAG_TICKS_EXISTED)) {
            this.ticksExisted = cmp.m_128451_(TAG_TICKS_EXISTED);
        }
        if (this.m_58900_().m_60734_() instanceof BlockFloatingFlower) {
            this.setFloating(true);
        }
        IFloatingFlower.IslandType oldType = this.floatingData.getIslandType();
        this.readFromPacketNBT(cmp);
        if (this.isFloating() && oldType != this.floatingData.getIslandType() && this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
        }
    }

    public final void m_183515_(CompoundTag cmp) {
        super.m_183515_(cmp);
        cmp.m_128405_(TAG_TICKS_EXISTED, this.ticksExisted);
        this.writeToPacketNBT(cmp);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeToPacketNBT(tag);
        return tag;
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        if (this.isFloating()) {
            cmp.m_128365_(TAG_FLOATING_DATA, this.floatingData.writeNBT());
        }
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        if (cmp.m_128441_(TAG_FLOATING_DATA)) {
            this.floatingData.readNBT(cmp.m_128469_(TAG_FLOATING_DATA));
        }
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    @Nullable
    public abstract RadiusDescriptor getRadius();

    @Nullable
    public RadiusDescriptor getSecondaryRadius() {
        return null;
    }

    public boolean isOvergrowthAffected() {
        return true;
    }

    public int getModulatedDelay() {
        if (this.isFloating()) {
            IFloatingFlower.IslandType type = this.floatingData.getIslandType();
            if (type == IFloatingFlower.IslandType.MYCEL) {
                return 10;
            }
            if (type == IFloatingFlower.IslandType.PODZOL) {
                return 5;
            }
        } else {
            BlockState below = this.f_58857_.m_8055_(this.m_58899_().m_7495_());
            if (below.m_60713_(Blocks.f_50195_)) {
                return 10;
            }
            if (below.m_60713_(Blocks.f_50599_)) {
                return 5;
            }
        }
        return 0;
    }

    @Nullable
    public Object getRenderAttachmentData() {
        if (this.isFloating()) {
            return this.floatingData.getIslandType();
        }
        return null;
    }

    public void emitParticle(ParticleOptions options, double xOffset, double yOffset, double zOffset, double xSpeed, double ySpeed, double zSpeed) {
        if (!this.f_58857_.f_46443_) {
            return;
        }
        Vec3 offset = this.f_58857_.m_8055_(this.getEffectivePos()).m_60824_((BlockGetter)this.f_58857_, this.getEffectivePos());
        this.f_58857_.m_7106_(options, (double)this.getEffectivePos().m_123341_() + offset.f_82479_ + xOffset, (double)this.getEffectivePos().m_123342_() + offset.f_82480_ + yOffset, (double)this.getEffectivePos().m_123343_() + offset.f_82481_ + zOffset, xSpeed, ySpeed, zSpeed);
    }
}

