/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.BufferBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.client.BotaniaItemProperties;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.core.handler.DebugHandler;
import vazkii.botania.client.core.handler.KonamiHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.proxy.ClientProxy;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.gui.ManaBarTooltipComponent;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.client.gui.bag.GuiFlowerBag;
import vazkii.botania.client.gui.box.GuiBaubleBox;
import vazkii.botania.client.model.ModLayerDefinitions;
import vazkii.botania.client.render.BlockRenderLayers;
import vazkii.botania.client.render.ColorHandler;
import vazkii.botania.client.render.entity.EntityRenderers;
import vazkii.botania.client.render.world.WorldOverlays;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.client.ForgeFloatingFlowerModel;
import vazkii.botania.forge.mixin.client.ForgeAccessorModelBakery;
import vazkii.botania.mixin.client.AccessorRenderBuffers;
import vazkii.botania.xplat.IClientXplatAbstractions;

@Mod.EventBusSubscriber(modid="botania", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeClientInitializer {
    private static final Supplier<Map<BlockEntityType<?>, Function<BlockEntity, IWandHUD>>> WAND_HUD = Suppliers.memoize(() -> {
        IdentityHashMap ret = new IdentityHashMap();
        ModTiles.registerWandHudCaps((factory, types) -> {
            for (BlockEntityType type : types) {
                ret.put(type, factory);
            }
        });
        ModSubtiles.registerWandHudCaps((factory, types) -> {
            for (BlockEntityType type : types) {
                ret.put(type, factory);
            }
        });
        return Collections.unmodifiableMap(ret);
    });

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent evt) {
        evt.enqueueWork(() -> {
            MenuScreens.m_96206_(ModItems.FLOWER_BAG_CONTAINER, GuiFlowerBag::new);
            MenuScreens.m_96206_(ModItems.BAUBLE_BOX_CONTAINER, GuiBaubleBox::new);
        });
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(e -> KonamiHandler.renderBook(e.getBook(), e.getScreen(), e.getMouseX(), e.getMouseY(), e.getPartialTicks(), e.getPoseStack()));
        bus.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                ClientTickHandler.clientTickEnd(Minecraft.m_91087_());
                KonamiHandler.clientTick(Minecraft.m_91087_());
            }
        });
        bus.addListener(e -> {
            if (e.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                HUDHandler.onDrawScreenPost(e.getMatrixStack(), e.getPartialTicks());
            }
        });
        bus.addListener(e -> TooltipHandler.onTooltipEvent(e.getItemStack(), e.getFlags(), e.getToolTip()));
        bus.addListener(e -> CorporeaInputHandler.buttonPressed(e.getKeyCode(), e.getScanCode()));
        bus.addListener(e -> DebugHandler.onDrawDebugText(e.getLeft()));
        bus.addListener(e -> WorldOverlays.renderWorldLast(e.getPartialTick(), e.getPoseStack()));
        bus.addListener(e -> {
            ItemDodgeRing.ClientLogic.onKeyDown();
            KonamiHandler.handleInput(e.getKey(), e.getAction(), e.getModifiers());
        });
        bus.addListener(e -> {
            if (e.phase == TickEvent.Phase.START) {
                ClientTickHandler.renderTick(e.renderTickTime);
            }
        });
        bus.addListener(EventPriority.LOWEST, e -> {
            if (!(e.getItemStack().m_41720_() instanceof IManaItem)) {
                return;
            }
            int width = 0;
            ManaBarTooltipComponent manaBar = null;
            for (ClientTooltipComponent component : e.getComponents()) {
                ManaBarTooltipComponent c;
                width = Math.max(width, component.m_142069_(e.getFont()));
                if (!(component instanceof ManaBarTooltipComponent)) continue;
                manaBar = c = (ManaBarTooltipComponent)component;
            }
            if (manaBar != null) {
                manaBar.setContext(e.getX(), e.getY(), width);
            }
        });
        MinecraftForgeClient.registerTooltipComponentFactory(ManaBarTooltip.class, ManaBarTooltipComponent::new);
        ClientProxy.initSeasonal();
        ClientProxy.initKeybindings(ClientRegistry::registerKeyBinding);
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, ForgeClientInitializer::attachBeCapabilities);
    }

    private static void attachBeCapabilities(AttachCapabilitiesEvent<BlockEntity> e) {
        BlockEntity be = (BlockEntity)e.getObject();
        Function<BlockEntity, IWandHUD> makeWandHud = WAND_HUD.get().get(be.m_58903_());
        if (makeWandHud != null) {
            e.addCapability(ResourceLocationHelper.prefix("wand_hud"), CapabilityUtil.makeProvider(BotaniaForgeClientCapabilities.WAND_HUD, makeWandHud.apply(be)));
        }
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent evt) {
        SortedMap<RenderType, BufferBuilder> layers = ((AccessorRenderBuffers)Minecraft.m_91087_().m_91269_()).getEntityBuilders();
        layers.put(RenderHelper.MANA_POOL_WATER, new BufferBuilder(RenderHelper.MANA_POOL_WATER.m_110507_()));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent evt) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)IClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID, (IModelLoader)ForgeFloatingFlowerModel.Loader.INSTANCE);
        ResourceManager resourceManager = ((ForgeAccessorModelBakery)ForgeModelBakery.instance()).getResourceManager();
        MiscellaneousModels.INSTANCE.onModelRegister(resourceManager, ForgeModelBakery::addSpecialModel);
        BlockRenderLayers.init(ItemBlockRenderTypes::setRenderLayer);
        BotaniaItemProperties.init((item, id, prop) -> ItemProperties.register((Item)item.m_5456_(), (ResourceLocation)id, (ItemPropertyFunction)prop));
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions evt) {
        ModLayerDefinitions.init((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)evt).registerLayerDefinition(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        EntityRenderers.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerBlockEntityRenderer(arg_0, arg_1));
        EntityRenderers.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerParticleFactories(ParticleFactoryRegisterEvent evt) {
        ModParticles.FactoryHandler.registerFactories(new ModParticles.FactoryHandler.Consumer(){

            @Override
            public <T extends ParticleOptions> void register(ParticleType<T> type, Function<SpriteSet, ParticleProvider<T>> constructor) {
                Minecraft.m_91087_().f_91061_.m_107378_(type, constructor::apply);
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockColors(ColorHandlerEvent.Block evt) {
        ColorHandler.submitBlocks((arg_0, arg_1) -> ((BlockColors)evt.getBlockColors()).m_92589_(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item evt) {
        ColorHandler.submitItems((arg_0, arg_1) -> ((ItemColors)evt.getItemColors()).m_92689_(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void initAuxiliaryRender(EntityRenderersEvent.AddLayers evt) {
        for (String playerModelType : evt.getSkins()) {
            LivingEntityRenderer livingEntityRenderer = evt.getSkin(playerModelType);
            if (!(livingEntityRenderer instanceof PlayerRenderer)) continue;
            PlayerRenderer renderer = (PlayerRenderer)livingEntityRenderer;
            EntityRenderers.addAuxiliaryPlayerRenders(renderer, arg_0 -> ((PlayerRenderer)renderer).m_115326_(arg_0));
        }
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent evt) throws IOException {
        CoreShaders.init(evt.getResourceManager(), p -> evt.registerShader((ShaderInstance)p.getFirst(), (Consumer)p.getSecond()));
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent evt) {
        MiscellaneousModels.INSTANCE.onModelBake((ModelBakery)evt.getModelLoader(), evt.getModelRegistry());
    }
}

