/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.block.IHornHarvestable;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.common.ModStats;
import vazkii.botania.common.PlayerAccess;
import vazkii.botania.common.advancements.ModCriteriaTriggers;
import vazkii.botania.common.block.BlockPistonRelay;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.string.BlockRedStringInterceptor;
import vazkii.botania.common.block.subtile.functional.SubTileDaffomill;
import vazkii.botania.common.block.subtile.functional.SubTileLoonuim;
import vazkii.botania.common.block.subtile.functional.SubTileTigerseye;
import vazkii.botania.common.block.subtile.functional.SubTileVinculotus;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileAlfPortal;
import vazkii.botania.common.block.tile.TileAnimatedTorch;
import vazkii.botania.common.block.tile.TileCraftCrate;
import vazkii.botania.common.block.tile.TileEnchanter;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TileRFGenerator;
import vazkii.botania.common.block.tile.string.TileRedStringContainer;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.brew.ModPotions;
import vazkii.botania.common.command.SkyblockCommand;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.handler.CommonTickHandler;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ExoflameFurnaceHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.common.handler.PaintableData;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.handler.SleepingHandler;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.impl.DefaultHornHarvestable;
import vazkii.botania.common.impl.corporea.DefaultCorporeaMatchers;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.ItemBlackHoleTalisman;
import vazkii.botania.common.item.ItemCraftingHalo;
import vazkii.botania.common.item.ItemEnderHand;
import vazkii.botania.common.item.ItemFlowerBag;
import vazkii.botania.common.item.ItemGrassSeeds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.ItemManaMirror;
import vazkii.botania.common.item.ItemSpellCloth;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelHelm;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.item.equipment.bauble.ItemDivaCharm;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.bauble.ItemGoddessCharm;
import vazkii.botania.common.item.equipment.bauble.ItemHolyCloak;
import vazkii.botania.common.item.equipment.bauble.ItemMagnetRing;
import vazkii.botania.common.item.equipment.bauble.ItemTravelBelt;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.item.material.ItemEnderAir;
import vazkii.botania.common.item.relic.ItemFlugelEye;
import vazkii.botania.common.item.relic.ItemLokiRing;
import vazkii.botania.common.item.relic.ItemOdinRing;
import vazkii.botania.common.item.rod.ItemCobbleRod;
import vazkii.botania.common.item.rod.ItemDirtRod;
import vazkii.botania.common.item.rod.ItemDiviningRod;
import vazkii.botania.common.item.rod.ItemExchangeRod;
import vazkii.botania.common.item.rod.ItemFireRod;
import vazkii.botania.common.item.rod.ItemMissileRod;
import vazkii.botania.common.item.rod.ItemRainbowRod;
import vazkii.botania.common.item.rod.ItemTerraformRod;
import vazkii.botania.common.item.rod.ItemTornadoRod;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.LootHandler;
import vazkii.botania.common.loot.ModLootModifiers;
import vazkii.botania.common.world.ModFeatures;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.ForgeBotaniaConfig;
import vazkii.botania.forge.integration.corporea.ForgeCapCorporeaNodeDetector;
import vazkii.botania.forge.integration.curios.CurioIntegration;
import vazkii.botania.forge.internal_caps.RedStringContainerCapProvider;
import vazkii.botania.forge.network.ForgePacketHandler;
import vazkii.botania.forge.xplat.ForgeXplatImpl;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;
import vazkii.patchouli.api.PatchouliAPI;

@Mod(value="botania")
public class ForgeCommonInitializer {
    private static final Supplier<Map<Item, Function<ItemStack, IAvatarWieldable>>> AVATAR_WIELDABLES = Suppliers.memoize(() -> Map.of(ModItems.dirtRod, s -> new ItemDirtRod.AvatarBehavior(), ModItems.diviningRod, s -> new ItemDiviningRod.AvatarBehavior(), ModItems.fireRod, s -> new ItemFireRod.AvatarBehavior(), ModItems.missileRod, s -> new ItemMissileRod.AvatarBehavior(), ModItems.rainbowRod, s -> new ItemRainbowRod.AvatarBehavior(), ModItems.tornadoRod, s -> new ItemTornadoRod.AvatarBehavior()));
    private static final Supplier<Map<Item, Function<ItemStack, IBlockProvider>>> BLOCK_PROVIDER = Suppliers.memoize(() -> Map.of(ModItems.dirtRod, ItemDirtRod.BlockProvider::new, ModItems.blackHoleTalisman, ItemBlackHoleTalisman.BlockProvider::new, ModItems.cobbleRod, s -> new ItemCobbleRod.BlockProvider(), ModItems.enderHand, ItemEnderHand.BlockProvider::new, ModItems.terraformRod, s -> new ItemTerraformRod.BlockProvider()));
    private static final Supplier<Map<Item, Function<ItemStack, ICoordBoundItem>>> COORD_BOUND_ITEM = Suppliers.memoize(() -> Map.of(ModItems.flugelEye, ItemFlugelEye.CoordBoundItem::new, ModItems.manaMirror, ItemManaMirror.CoordBoundItem::new, ModItems.twigWand, ItemTwigWand.CoordBoundItem::new));
    private static final Supplier<Set<BlockEntityType<?>>> SELF_WANDADBLE_BES = Suppliers.memoize(() -> ImmutableSet.of(ModTiles.ALF_PORTAL, ModTiles.ANIMATED_TORCH, ModTiles.CORPOREA_CRYSTAL_CUBE, ModTiles.CORPOREA_RETAINER, ModTiles.CRAFT_CRATE, ModTiles.ENCHANTER, (Object[])new BlockEntityType[]{ModTiles.HOURGLASS, ModTiles.PLATFORM, ModTiles.POOL, ModTiles.RUNE_ALTAR, ModTiles.SPREADER, ModTiles.TURNTABLE, ModSubtiles.DAFFOMILL, ModSubtiles.HOPPERHOCK, ModSubtiles.HOPPERHOCK_CHIBI, ModSubtiles.RANNUNCARPUS, ModSubtiles.RANNUNCARPUS_CHIBI}));

    public ForgeCommonInitializer() {
        this.coreInit();
        this.registryInit();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent evt) {
        ForgePacketHandler.init();
        this.registerEvents();
        evt.enqueueWork(ModBlocks::addDispenserBehaviours);
        ModBlocks.addAxeStripping();
        PaintableData.init();
        DefaultCorporeaMatchers.init();
        PatchouliAPI.get().registerMultiblock(Registry.f_122824_.m_7981_((Object)ModBlocks.alfPortal), TileAlfPortal.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(Registry.f_122824_.m_7981_((Object)ModBlocks.terraPlate), TileTerraPlate.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(Registry.f_122824_.m_7981_((Object)ModBlocks.enchanter), TileEnchanter.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(ResourceLocationHelper.prefix("gaia_ritual"), EntityDoppleganger.ARENA_MULTIBLOCK.get());
        OrechidManager.registerListener();
        TileCraftCrate.registerListener();
        CorporeaNodeDetectors.register(new ForgeCapCorporeaNodeDetector());
    }

    private void coreInit() {
        ForgeBotaniaConfig.setup();
        EquipmentHandler.init();
    }

    private void registryInit() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeCommonInitializer.bind(ForgeRegistries.SOUND_EVENTS, ModSounds::init);
        ForgeCommonInitializer.bind(ForgeRegistries.BLOCKS, ModBlocks::registerBlocks);
        ForgeCommonInitializer.bind(ForgeRegistries.ITEMS, ModBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(ForgeRegistries.BLOCKS, ModFluffBlocks::registerBlocks);
        ForgeCommonInitializer.bind(ForgeRegistries.ITEMS, ModFluffBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(ForgeRegistries.BLOCK_ENTITIES, ModTiles::registerTiles);
        ForgeCommonInitializer.bind(ForgeRegistries.ITEMS, ModItems::registerItems);
        ForgeCommonInitializer.bind(ForgeRegistries.BLOCKS, ModSubtiles::registerBlocks);
        ForgeCommonInitializer.bind(ForgeRegistries.ITEMS, ModSubtiles::registerItemBlocks);
        ForgeCommonInitializer.bind(ForgeRegistries.BLOCK_ENTITIES, ModSubtiles::registerTEs);
        ForgeCommonInitializer.bind(ForgeRegistries.CONTAINERS, ModItems::registerMenuTypes);
        ForgeCommonInitializer.bind(ForgeRegistries.RECIPE_SERIALIZERS, ModItems::registerRecipeSerializers);
        ForgeCommonInitializer.bind(ForgeRegistries.RECIPE_SERIALIZERS, ModRecipeTypes::registerRecipeTypes);
        ForgeCommonInitializer.bind(ForgeRegistries.ENTITIES, ModEntities::registerEntities);
        modBus.addListener(e -> ModEntities.registerAttributes((type, builder) -> e.put(type, builder.m_22265_())));
        modBus.addListener(e -> e.add(EntityType.f_20532_, PixieHandler.PIXIE_SPAWN_CHANCE));
        ForgeCommonInitializer.bind(ForgeRegistries.ATTRIBUTES, PixieHandler::registerAttribute);
        ForgeCommonInitializer.bind(ForgeRegistries.MOB_EFFECTS, ModPotions::registerPotions);
        ModBrews.registerBrews();
        ForgeCommonInitializer.bind(ForgeRegistries.FEATURES, ModFeatures::registerFeatures);
        SkyblockChunkGenerator.init();
        if (IXplatAbstractions.INSTANCE.gogLoaded()) {
            modBus.addGenericListener(ForgeWorldPreset.class, e -> {
                ForgeWorldPreset preset = new ForgeWorldPreset(SkyblockChunkGenerator::createForWorldType){

                    public String getTranslationKey() {
                        return "generator.botania-skyblock";
                    }
                };
                preset.setRegistryName(ResourceLocationHelper.prefix("gardenofglass"));
                e.getRegistry().register((IForgeRegistryEntry)preset);
            });
        }
        ModCriteriaTriggers.init();
        ModLootModifiers.init();
        ForgeCommonInitializer.bind(ForgeRegistries.PARTICLE_TYPES, ModParticles::registerParticles);
        ModStats.init();
    }

    private static <T extends IForgeRegistryEntry<T>> void bind(IForgeRegistry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(registry.getRegistrySuperType(), event -> {
            IForgeRegistry forgeRegistry = event.getRegistry();
            source.accept((t, rl) -> {
                t.setRegistryName(rl);
                forgeRegistry.register(t);
            });
        });
    }

    private void registerEvents() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        this.registerBlockLookasides();
        bus.addGenericListener(ItemStack.class, this::attachItemCaps);
        bus.addGenericListener(BlockEntity.class, this::attachBeCaps);
        if (BotaniaConfig.common().worldgenEnabled()) {
            bus.addListener(e -> {
                Biome.BiomeCategory category = e.getCategory();
                if (!ModFeatures.TYPE_BLACKLIST.contains(category)) {
                    e.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.MYSTICAL_FLOWERS_PLACED);
                }
                if (category != Biome.BiomeCategory.THEEND) {
                    e.getGeneration().m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, ModFeatures.MYSTICAL_MUSHROOMS_PLACED);
                }
            });
        }
        int blazeTime = 2400 * (IXplatAbstractions.INSTANCE.gogLoaded() ? 5 : 10);
        bus.addListener(e -> {
            if (e.getItemStack().m_150930_(ModBlocks.blazeBlock.m_5456_())) {
                e.setBurnTime(blazeTime);
            }
        });
        if (IXplatAbstractions.INSTANCE.gogLoaded()) {
            bus.addListener(e -> {
                InteractionResult result = SkyblockWorldEvents.onPlayerInteract(e.getPlayer(), e.getWorld(), e.getHand(), e.getHitVec());
                if (result == InteractionResult.SUCCESS) {
                    e.setCanceled(true);
                    e.setCancellationResult(InteractionResult.SUCCESS);
                }
            });
        }
        bus.addListener(e -> ((ItemExchangeRod)ModItems.exchangeRod).onLeftClick(e.getPlayer(), e.getWorld(), e.getHand(), e.getPos(), e.getFace()));
        bus.addListener(e -> ItemTerraSword.leftClick(e.getItemStack()));
        bus.addListener(e -> ItemTerraSword.attackEntity(e.getPlayer(), e.getPlayer().f_19853_, InteractionHand.MAIN_HAND, e.getTarget(), null));
        bus.addListener(e -> this.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getEnvironment() == Commands.CommandSelection.DEDICATED));
        bus.addListener(e -> {
            Player.BedSleepingProblem problem = SleepingHandler.trySleep(e.getPlayer(), e.getPos());
            if (problem != null) {
                e.setResult(problem);
            }
        });
        bus.addListener(e -> SubTileDaffomill.onItemTrack(e.getEntity(), (ServerPlayer)e.getPlayer()));
        bus.addListener(e -> LootHandler.lootLoad(e.getName(), arg_0 -> ((LootTable)e.getTable()).addPool(arg_0)));
        bus.addListener(e -> ManaNetworkHandler.instance.onNetworkEvent(e.getBlockEntity(), e.getType(), e.getAction()));
        bus.addListener(e -> {
            if (!e.getWorld().f_46443_) {
                SubTileTigerseye.pacifyAfterLoad(e.getEntity(), (ServerLevel)e.getWorld());
            }
        });
        bus.addListener(e -> this.serverAboutToStart(e.getServer()));
        bus.addListener(e -> this.serverStopping(e.getServer()));
        bus.addListener(e -> ItemFlightTiara.playerLoggedOut((ServerPlayer)e.getPlayer()));
        bus.addListener(e -> ItemKeepIvy.onPlayerRespawn(e.getPlayer(), e.getPlayer(), e.isEndConquered()));
        bus.addListener(e -> {
            Level patt14247$temp;
            if (e.phase == TickEvent.Phase.END && (patt14247$temp = e.world) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)patt14247$temp;
                CommonTickHandler.onTick(level);
                ItemGrassSeeds.onTickEnd(level);
                ItemTerraAxe.onTickEnd(level);
            }
        });
        bus.addListener(e -> {
            BlockRedStringInterceptor.onInteract(e.getPlayer(), e.getWorld(), e.getHand(), e.getHitVec());
            ItemLokiRing.onPlayerInteract(e.getPlayer(), e.getWorld(), e.getHand(), e.getHitVec());
        });
        bus.addListener(e -> {
            InteractionResultHolder<ItemStack> result = ItemEnderAir.onPlayerInteract(e.getPlayer(), e.getWorld(), e.getHand());
            if (result.m_19089_().m_19077_()) {
                e.setCanceled(true);
                e.setCancellationResult(result.m_19089_());
            }
        });
        bus.addListener(e -> {
            if (ItemSpellCloth.shouldDenyAnvil(e.getLeft(), e.getRight())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> {
            BlockState input;
            Block output;
            if (e.getToolAction() == ToolActions.AXE_STRIP && (output = ForgeXplatImpl.CUSTOM_STRIPPABLES.get((input = e.getState()).m_60734_())) != null) {
                e.setFinalState(output.m_152465_(input));
            }
        });
        bus.addListener(e -> {
            EnderMan em;
            Vec3 newPos;
            LivingEntity patt15621$temp = e.getEntityLiving();
            if (patt15621$temp instanceof EnderMan && (newPos = SubTileVinculotus.onEndermanTeleport(em = (EnderMan)patt15621$temp, e.getTargetX(), e.getTargetY(), e.getTargetZ())) != null) {
                e.setTargetX(newPos.m_7096_());
                e.setTargetY(newPos.m_7098_());
                e.setTargetZ(newPos.m_7094_());
            }
        });
        bus.addListener(e -> {
            if (ItemGoddessCharm.shouldProtectExplosion(e.getWorld(), e.getExplosion().getPosition())) {
                e.getExplosion().m_46080_();
            }
        });
        bus.addListener(e -> {
            if (ItemFlowerBag.onPickupItem(e.getItem(), e.getPlayer())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> {
            LivingEntity living = e.getEntityLiving();
            ItemElementiumAxe.onEntityDrops(e.isRecentlyHit(), e.getSource(), e.getEntityLiving(), stack -> {
                ItemEntity ent = new ItemEntity(living.f_19853_, living.m_20185_(), living.m_20186_(), living.m_20189_(), stack);
                ent.m_32060_();
                e.getDrops().add(ent);
            });
            SubTileLoonuim.dropLooniumItems(living, stack -> {
                e.getDrops().clear();
                ItemEntity ent = new ItemEntity(living.f_19853_, living.m_20185_(), living.m_20186_(), living.m_20189_(), stack);
                ent.m_32060_();
                e.getDrops().add(ent);
            });
        });
        bus.addListener(e -> ItemTravelBelt.onPlayerJump(e.getEntityLiving()));
        bus.addListener(e -> {
            Player player;
            LivingEntity patt17069$temp = e.getEntityLiving();
            if (patt17069$temp instanceof Player && ItemOdinRing.onPlayerAttacked(player = (Player)patt17069$temp, e.getSource())) {
                e.setCanceled(true);
            }
        });
        bus.addListener(e -> ItemMagnetRing.onTossItem(e.getPlayer()));
        bus.addListener(e -> {
            Entity patt17796$temp;
            Player player;
            LivingEntity patt17353$temp = e.getEntityLiving();
            if (patt17353$temp instanceof Player) {
                player = (Player)patt17353$temp;
                Container worn = EquipmentHandler.getAllWorn((LivingEntity)player);
                for (int i = 0; i < worn.m_6643_(); ++i) {
                    ItemStack stack = worn.m_8020_(i);
                    Item patt17564$temp = stack.m_41720_();
                    if (!(patt17564$temp instanceof ItemHolyCloak)) continue;
                    ItemHolyCloak cloak = (ItemHolyCloak)patt17564$temp;
                    e.setAmount(cloak.onPlayerDamage(player, e.getSource(), e.getAmount()));
                }
                PixieHandler.onDamageTaken(player, e.getSource());
            }
            if ((patt17796$temp = e.getSource().m_7640_()) instanceof Player) {
                player = (Player)patt17796$temp;
                ItemDivaCharm.onEntityDamaged(player, e.getEntity());
            }
        });
        bus.addListener(e -> {
            LivingEntity patt17982$temp = e.getEntityLiving();
            if (patt17982$temp instanceof Player) {
                Player player = (Player)patt17982$temp;
                ItemFlightTiara.updatePlayerFlyStatus(player);
                ItemTravelBelt.tickBelt(player);
            }
        });
        bus.addListener(e -> {
            LivingEntity patt18185$temp = e.getEntityLiving();
            if (patt18185$temp instanceof Player) {
                Player player = (Player)patt18185$temp;
                e.setDistance(ItemTravelBelt.onPlayerFall(player, e.getDistance()));
            }
        });
        bus.addListener(EventPriority.LOW, e -> {
            Entity patt18654$temp;
            Event.Result result = e.getResult();
            if (e.getPlayer().f_19853_.f_46443_ || result == Event.Result.DENY || result == Event.Result.DEFAULT && !e.isVanillaCritical() || !ItemTerrasteelHelm.hasTerraArmorSet(e.getPlayer()) || !((patt18654$temp = e.getTarget()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity target = (LivingEntity)patt18654$temp;
            e.setDamageModifier(e.getDamageModifier() * ItemTerrasteelHelm.getCritDamageMult(e.getPlayer()));
            ((PlayerAccess)e.getPlayer()).botania$setCritTarget(target);
        });
        bus.addListener(e -> ItemCraftingHalo.onItemCrafted(e.getPlayer(), e.getInventory()));
        bus.addListener(EventPriority.HIGH, e -> {
            if (TileCorporeaIndex.getInputHandler().onChatMessage(e.getPlayer(), e.getMessage())) {
                e.setCanceled(true);
            }
        });
    }

    private void attachItemCaps(AttachCapabilitiesEvent<ItemStack> e) {
        Function<ItemStack, ICoordBoundItem> makeCoordBoundItem;
        Function<ItemStack, IBlockProvider> makeBlockProvider;
        Function<ItemStack, IAvatarWieldable> makeAvatarWieldable;
        EquipmentHandler equipmentHandler;
        ItemStack stack = (ItemStack)e.getObject();
        if (stack.m_41720_() instanceof ItemBauble && (equipmentHandler = EquipmentHandler.instance) instanceof CurioIntegration) {
            CurioIntegration ci = (CurioIntegration)equipmentHandler;
            e.addCapability(ResourceLocationHelper.prefix("curio"), ci.initCapability(stack));
        }
        if (stack.m_150930_(ModItems.waterBowl)) {
            e.addCapability(ResourceLocationHelper.prefix("water_bowl"), (ICapabilityProvider)new CapabilityUtil.WaterBowlFluidHandler(stack));
        }
        if ((makeAvatarWieldable = AVATAR_WIELDABLES.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("avatar_wieldable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.AVATAR_WIELDABLE, makeAvatarWieldable.apply(stack)));
        }
        if ((makeBlockProvider = BLOCK_PROVIDER.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("block_provider"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.BLOCK_PROVIDER, makeBlockProvider.apply(stack)));
        }
        if ((makeCoordBoundItem = COORD_BOUND_ITEM.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("coord_bound_item"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.COORD_BOUND_ITEM, makeCoordBoundItem.apply(stack)));
        }
    }

    private void registerBlockLookasides() {
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> (world, pos, stack, hornType) -> hornType == IHornHarvestable.EnumHornType.CANOPY, Blocks.f_50191_, Blocks.f_152538_, Blocks.f_152539_, Blocks.f_50704_, Blocks.f_50653_, Blocks.f_50702_, Blocks.f_50703_);
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> DefaultHornHarvestable.INSTANCE, (Block[])Arrays.stream(DyeColor.values()).map(ModBlocks::getMushroom).toArray(Block[]::new));
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.HORN_HARVEST, (w, p, s) -> DefaultHornHarvestable.INSTANCE, (Block[])Arrays.stream(DyeColor.values()).map(ModBlocks::getShinyFlower).toArray(Block[]::new));
        CapabilityUtil.registerBlockLookaside(BotaniaForgeCapabilities.WANDABLE, (world, pos, state) -> (player, stack, side) -> ((BlockPistonRelay)state.m_60734_()).onUsedByWand(player, stack, world, pos), ModBlocks.pistonRelay);
    }

    private void attachBeCaps(AttachCapabilitiesEvent<BlockEntity> e) {
        BlockEntity be = (BlockEntity)e.getObject();
        if (be instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)be;
            e.addCapability(ResourceLocationHelper.prefix("exoflame_heatable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.EXOFLAME_HEATABLE, new ExoflameFurnaceHandler.FurnaceExoflameHeatable(furnace)));
        }
        if (be instanceof TileExposedSimpleInventory) {
            TileExposedSimpleInventory inv = (TileExposedSimpleInventory)be;
            e.addCapability(ResourceLocationHelper.prefix("inv"), CapabilityUtil.makeProvider(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, new SidedInvWrapper((WorldlyContainer)inv, null)));
        }
        if (be instanceof TileRFGenerator) {
            final TileRFGenerator gen = (TileRFGenerator)be;
            IEnergyStorage energyStorage = new IEnergyStorage(){

                public int getEnergyStored() {
                    return gen.getEnergy();
                }

                public int getMaxEnergyStored() {
                    return TileRFGenerator.MAX_ENERGY;
                }

                public boolean canExtract() {
                    return false;
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return 0;
                }

                public boolean canReceive() {
                    return false;
                }
            };
            e.addCapability(ResourceLocationHelper.prefix("fe"), CapabilityUtil.makeProvider(CapabilityEnergy.ENERGY, energyStorage));
        }
        if (be.m_58903_() == ModTiles.ANIMATED_TORCH) {
            e.addCapability(ResourceLocationHelper.prefix("hourglass_trigger"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.HOURGLASS_TRIGGER, hourglass -> ((TileAnimatedTorch)be).toggle()));
        }
        if (SELF_WANDADBLE_BES.get().contains(be.m_58903_())) {
            e.addCapability(ResourceLocationHelper.prefix("wandable"), CapabilityUtil.makeProvider(BotaniaForgeCapabilities.WANDABLE, (IWandable)be));
        }
        if (be instanceof TileRedStringContainer) {
            TileRedStringContainer container = (TileRedStringContainer)be;
            e.addCapability(ResourceLocationHelper.prefix("red_string"), (ICapabilityProvider)new RedStringContainerCapProvider(container));
        }
    }

    private void serverAboutToStart(MinecraftServer server) {
        if (BotaniaAPI.instance().getClass() != BotaniaAPIImpl.class) {
            String clname = BotaniaAPI.instance().getClass().getName();
            throw new IllegalAccessError("The Botania API has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Actual classname: " + clname + ")");
        }
        if (server.m_6982_()) {
            ContributorList.firstStart();
        }
    }

    private void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, boolean dedicated) {
        if (IXplatAbstractions.INSTANCE.gogLoaded()) {
            SkyblockCommand.register(dispatcher);
        }
    }

    private void serverStopping(MinecraftServer server) {
        ManaNetworkHandler.instance.clear();
        TileCorporeaIndex.clearIndexCache();
    }
}

