/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.AlfPortalState;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockAltar;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockBuriedPetals;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.decor.panes.BlockModPane;
import vazkii.botania.common.block.string.BlockRedString;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorBlockModelGenerators;
import vazkii.botania.mixin.AccessorTextureSlot;

public class BlockstateProvider
implements DataProvider {
    private final DataGenerator generator;
    private final List<BlockStateGenerator> blockstates = new ArrayList<BlockStateGenerator>();
    private final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
    private final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = this.models::put;

    public BlockstateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    @Nonnull
    public String m_6055_() {
        return "Botania Blockstates and Models";
    }

    public void m_6865_(HashCache hashCache) throws IOException {
        Path path;
        try {
            this.registerStatesAndModels();
        }
        catch (Exception e) {
            BotaniaAPI.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        Path root = this.generator.m_123916_();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        for (BlockStateGenerator blockStateGenerator : this.blockstates) {
            ResourceLocation id = Registry.f_122824_.m_7981_((Object)blockStateGenerator.m_6968_());
            path = root.resolve("assets/" + id.m_135827_() + "/blockstates/" + id.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)gson, (HashCache)hashCache, (JsonElement)((JsonElement)blockStateGenerator.get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating blockstate file for {}", (Object)id, (Object)ex);
            }
        }
        for (Map.Entry entry : this.models.entrySet()) {
            ResourceLocation modelId = (ResourceLocation)entry.getKey();
            path = root.resolve("assets/" + modelId.m_135827_() + "/models/" + modelId.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)gson, (HashCache)hashCache, (JsonElement)((JsonElement)((Supplier)entry.getValue()).get()), (Path)path);
            }
            catch (IOException ex) {
                BotaniaAPI.LOGGER.error("Error generating model file {}", (Object)modelId, (Object)ex);
            }
        }
    }

    private void registerStatesAndModels() {
        Set<Block> remainingBlocks = Registry.f_122824_.m_123024_().filter(b -> "botania".equals(Registry.f_122824_.m_7981_(b).m_135827_())).collect(Collectors.toSet());
        remainingBlocks.remove(ModBlocks.ghostRail);
        remainingBlocks.remove(ModBlocks.solidVines);
        this.manualModel(remainingBlocks, ModBlocks.cocoon);
        this.manualModel(remainingBlocks, ModBlocks.corporeaCrystalCube);
        this.manualModel(remainingBlocks, ModBlocks.distributor);
        this.manualModel(remainingBlocks, ModBlocks.prism);
        this.manualModel(remainingBlocks, ModBlocks.runeAltar);
        this.manualModel(remainingBlocks, ModBlocks.spawnerClaw);
        ResourceLocation alfPortalModel = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125576_((Block)ModBlocks.alfPortal), TextureMapping.m_125748_((Block)ModBlocks.alfPortal), this.modelOutput);
        ResourceLocation alfPortalActivatedModel = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)ModBlocks.alfPortal, (String)"_activated"), TextureMapping.m_125776_((ResourceLocation)ModelLocationUtils.m_125578_((Block)ModBlocks.alfPortal, (String)"_activated")), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)ModBlocks.alfPortal).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_(BotaniaStateProps.ALFPORTAL_STATE).m_125329_((Comparable)((Object)AlfPortalState.OFF), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)alfPortalModel)).m_125329_((Comparable)((Object)AlfPortalState.ON_X), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)alfPortalActivatedModel)).m_125329_((Comparable)((Object)AlfPortalState.ON_Z), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)alfPortalActivatedModel))));
        remainingBlocks.remove(ModBlocks.alfPortal);
        this.singleVariantBlockState(ModBlocks.bifrostPerm, ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125576_((Block)ModBlocks.bifrostPerm), TextureMapping.m_125748_((Block)ModBlocks.bifrost), this.modelOutput));
        remainingBlocks.remove(ModBlocks.bifrostPerm);
        this.singleVariantBlockState(ModBlocks.cacophonium, ModelTemplates.f_125696_.m_125592_(ModBlocks.cacophonium, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)Blocks.f_50065_)).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)ModBlocks.cacophonium, (String)"_top")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.cacophonium);
        ModelTemplate crateTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/crate")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125875_});
        ResourceLocation craftCrateBottomTex = TextureMapping.m_125753_((Block)ModBlocks.craftCrate, (String)"_bottom");
        PropertyDispatch.C1 crateDispatch = PropertyDispatch.m_125294_(BotaniaStateProps.CRATE_PATTERN);
        for (CratePattern pattern : CratePattern.values()) {
            String suffix = pattern == CratePattern.NONE ? "" : "_" + pattern.m_7912_().substring("crafty_".length());
            ResourceLocation model = crateTemplate.m_125612_(ModelLocationUtils.m_125578_((Block)ModBlocks.craftCrate, (String)suffix), new TextureMapping().m_125758_(TextureSlot.f_125871_, craftCrateBottomTex).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)ModBlocks.craftCrate, (String)suffix)), this.modelOutput);
            crateDispatch = crateDispatch.m_125329_((Comparable)((Object)pattern), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model));
        }
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)ModBlocks.craftCrate).m_125271_((PropertyDispatch)crateDispatch));
        remainingBlocks.remove(ModBlocks.craftCrate);
        ResourceLocation corpSlabSide = ResourceLocationHelper.prefix("block/corporea_slab_side");
        ResourceLocation corpBlock = TextureMapping.m_125740_((Block)ModBlocks.corporeaBlock);
        ResourceLocation corpSlabBottomModel = ModelTemplates.f_125627_.m_125592_((Block)ModBlocks.corporeaSlab, new TextureMapping().m_125758_(TextureSlot.f_125871_, corpBlock).m_125758_(TextureSlot.f_125872_, corpBlock).m_125758_(TextureSlot.f_125875_, corpBlock), this.modelOutput);
        ResourceLocation corpSlabTopModel = ModelTemplates.f_125628_.m_125612_(ModelLocationUtils.m_125578_((Block)ModBlocks.corporeaSlab, (String)"_top"), new TextureMapping().m_125758_(TextureSlot.f_125871_, corpBlock).m_125758_(TextureSlot.f_125872_, corpBlock).m_125758_(TextureSlot.f_125875_, corpBlock), this.modelOutput);
        ResourceLocation corpSlabDoubleModel = ModelTemplates.f_125697_.m_125612_(ResourceLocationHelper.prefix("block/corporea_double_slab"), new TextureMapping().m_125758_(TextureSlot.f_125875_, corpSlabSide).m_125758_(TextureSlot.f_125871_, corpBlock).m_125758_(TextureSlot.f_125872_, corpBlock), this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeSlabState((Block)ModBlocks.corporeaSlab, corpSlabBottomModel, corpSlabTopModel, corpSlabDoubleModel));
        remainingBlocks.remove(ModBlocks.corporeaSlab);
        this.stairsBlock(remainingBlocks, (Block)ModBlocks.corporeaStairs, corpBlock, corpBlock, corpBlock);
        this.wallBlock(remainingBlocks, ModBlocks.corporeaBrickWall, TextureMapping.m_125740_((Block)ModBlocks.corporeaBrick));
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125259_((Block)ModBlocks.elfGlass, (Variant[])((Variant[])IntStream.rangeClosed(0, 3).mapToObj(i -> {
            ResourceLocation model = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)ModBlocks.elfGlass, (String)("_" + i)), TextureMapping.m_125776_((ResourceLocation)TextureMapping.m_125753_((Block)ModBlocks.elfGlass, (String)("_" + i))), this.modelOutput);
            return Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model);
        }).toArray(Variant[]::new))));
        remainingBlocks.remove(ModBlocks.elfGlass);
        this.singleVariantBlockState(ModBlocks.enchantedSoil, ModelTemplates.f_125697_.m_125592_(ModBlocks.enchantedSoil, TextureMapping.m_125826_((Block)ModBlocks.enchantedSoil).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125740_((Block)Blocks.f_50493_)), this.modelOutput));
        remainingBlocks.remove(ModBlocks.enchantedSoil);
        ResourceLocation pumpkinModel = ModelTemplates.f_125698_.m_125592_(ModBlocks.felPumpkin, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)Blocks.f_50133_, (String)"_side")).m_125758_(TextureSlot.f_125873_, TextureMapping.m_125740_((Block)ModBlocks.felPumpkin)).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)Blocks.f_50133_, (String)"_top")), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)ModBlocks.felPumpkin, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)pumpkinModel)).m_125271_(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.felPumpkin);
        ModelTemplate eightByEightTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/eightbyeight")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125876_, TextureSlot.f_125877_, TextureSlot.f_125879_, TextureSlot.f_125878_});
        this.singleVariantBlockState(ModBlocks.forestEye, eightByEightTemplate.m_125592_(ModBlocks.forestEye, new TextureMapping().m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)ModBlocks.forestEye, (String)"_bottom")).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)ModBlocks.forestEye, (String)"_top")).m_125758_(TextureSlot.f_125876_, TextureMapping.m_125753_((Block)ModBlocks.forestEye, (String)"_north")).m_125758_(TextureSlot.f_125877_, TextureMapping.m_125753_((Block)ModBlocks.forestEye, (String)"_south")).m_125758_(TextureSlot.f_125879_, TextureMapping.m_125753_((Block)ModBlocks.forestEye, (String)"_west")).m_125758_(TextureSlot.f_125878_, TextureMapping.m_125753_((Block)ModBlocks.forestEye, (String)"_east")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.forestEye);
        ResourceLocation plateFile = ModelLocationUtils.m_125576_((Block)ModBlocks.incensePlate);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)ModBlocks.incensePlate, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)plateFile)).m_125271_(AccessorBlockModelGenerators.horizontalDispatch()));
        remainingBlocks.remove(ModBlocks.incensePlate);
        ModelTemplate fourHighBottomTopTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/four_high_bottom_top")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_});
        this.singleVariantBlockState(ModBlocks.lightLauncher, fourHighBottomTopTemplate.m_125592_(ModBlocks.lightLauncher, new TextureMapping().m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)ModBlocks.lightLauncher, (String)"_end")).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)ModBlocks.lightLauncher, (String)"_end")).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)ModBlocks.lightLauncher, (String)"_side")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.lightLauncher);
        this.singleVariantBlockState(ModBlocks.openCrate, crateTemplate.m_125592_(ModBlocks.openCrate, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)ModBlocks.openCrate)).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)ModBlocks.openCrate, (String)"_bottom")), this.modelOutput));
        remainingBlocks.remove(ModBlocks.openCrate);
        ModelTemplate threeHighBottomTopTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/three_high_bottom_top")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125871_, TextureSlot.f_125872_, TextureSlot.f_125875_});
        this.singleVariantBlockState(ModBlocks.sparkChanger, threeHighBottomTopTemplate.m_125592_(ModBlocks.sparkChanger, TextureMapping.m_125826_((Block)ModBlocks.sparkChanger), this.modelOutput));
        remainingBlocks.remove(ModBlocks.sparkChanger);
        this.singleVariantBlockState(ModBlocks.starfield, fourHighBottomTopTemplate.m_125592_(ModBlocks.starfield, TextureMapping.m_125826_((Block)ModBlocks.starfield), this.modelOutput));
        remainingBlocks.remove(ModBlocks.starfield);
        this.singleVariantBlockState(ModBlocks.terraPlate, threeHighBottomTopTemplate.m_125592_(ModBlocks.terraPlate, TextureMapping.m_125826_((Block)ModBlocks.terraPlate), this.modelOutput));
        remainingBlocks.remove(ModBlocks.terraPlate);
        ModelTemplate tenByTenAllTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/tenbyten_all")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
        this.singleVariantBlockState(ModBlocks.tinyPlanet, tenByTenAllTemplate.m_125592_(ModBlocks.tinyPlanet, TextureMapping.m_125748_((Block)ModBlocks.tinyPlanet), this.modelOutput));
        remainingBlocks.remove(ModBlocks.tinyPlanet);
        this.singleVariantBlockState(ModBlocks.turntable, ModelTemplates.f_125697_.m_125592_(ModBlocks.turntable, TextureMapping.m_125826_((Block)ModBlocks.turntable), this.modelOutput));
        remainingBlocks.remove(ModBlocks.turntable);
        ResourceLocation[] topTexs = new ResourceLocation[6];
        ResourceLocation[] sideTexs = new ResourceLocation[6];
        ResourceLocation[] topStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] sideStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] sideGlimmeringTexs = new ResourceLocation[6];
        ResourceLocation[] sideGlimmeringStrippedTexs = new ResourceLocation[6];
        ResourceLocation[] logModels = new ResourceLocation[6];
        ResourceLocation[] strippedLogModels = new ResourceLocation[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            int index = i2 + 1;
            sideTexs[i2] = TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLog, (String)("/" + index));
            topTexs[i2] = TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLog, (String)"_top");
            sideStrippedTexs[i2] = TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLogStripped, (String)("/" + index));
            topStrippedTexs[i2] = TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLogStripped, (String)"_top");
            sideGlimmeringTexs[i2] = TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLogGlimmering, (String)("/" + index));
            sideGlimmeringStrippedTexs[i2] = TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLogStrippedGlimmering, (String)("/" + index));
            logModels[i2] = ModelLocationUtils.m_125578_((Block)ModBlocks.dreamwood, (String)("_" + index));
            strippedLogModels[i2] = ModelLocationUtils.m_125578_((Block)ModBlocks.dreamwoodStripped, (String)("_" + index));
        }
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLog, topTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwood, sideTexs, sideTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogStripped, topStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodStripped, sideStrippedTexs, sideStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogGlimmering, topTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodGlimmering, sideGlimmeringTexs, sideGlimmeringTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodLogStrippedGlimmering, topStrippedTexs, sideGlimmeringStrippedTexs);
        this.pillarWithVariants(remainingBlocks, ModBlocks.dreamwoodStrippedGlimmering, sideGlimmeringStrippedTexs, sideGlimmeringStrippedTexs);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStairs, sideTexs, sideTexs, sideTexs);
        this.stairsBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedStairs, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodSlab, logModels, sideTexs, sideTexs, sideTexs);
        this.slabBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedSlab, strippedLogModels, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodWall, sideTexs);
        this.wallBlockWithVariants(remainingBlocks, ModFluffBlocks.dreamwoodStrippedWall, sideStrippedTexs);
        this.pillar(remainingBlocks, ModBlocks.livingwoodLog, TextureMapping.m_125753_((Block)ModBlocks.livingwoodLog, (String)"_top"), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog));
        this.pillar(remainingBlocks, ModBlocks.livingwood, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogStripped, TextureMapping.m_125753_((Block)ModBlocks.livingwoodLogStripped, (String)"_top"), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, ModBlocks.livingwoodStripped, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogGlimmering, TextureMapping.m_125753_((Block)ModBlocks.livingwoodLog, (String)"_top"), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodGlimmering, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogGlimmering), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodLogStrippedGlimmering, TextureMapping.m_125753_((Block)ModBlocks.livingwoodLogStripped, (String)"_top"), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStrippedGlimmering));
        this.pillar(remainingBlocks, ModBlocks.livingwoodStrippedGlimmering, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStrippedGlimmering), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStrippedGlimmering));
        this.pillarAlt(remainingBlocks, ModBlocks.livingwoodFramed, TextureMapping.m_125740_((Block)ModBlocks.livingwoodPatternFramed), TextureMapping.m_125740_((Block)ModBlocks.livingwoodFramed));
        this.pillarAlt(remainingBlocks, ModBlocks.dreamwoodFramed, TextureMapping.m_125740_((Block)ModBlocks.dreamwoodPatternFramed), TextureMapping.m_125740_((Block)ModBlocks.dreamwoodFramed));
        this.stairsBlock(remainingBlocks, ModFluffBlocks.livingwoodStairs, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog));
        this.stairsBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedStairs, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped));
        this.slabBlock(remainingBlocks, ModFluffBlocks.livingwoodSlab, ModelLocationUtils.m_125576_((Block)ModBlocks.livingwood), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog));
        this.slabBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedSlab, ModelLocationUtils.m_125576_((Block)ModBlocks.livingwoodStripped), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped), TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingwoodWall, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingwoodStrippedWall, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingrockWall, TextureMapping.m_125740_((Block)ModBlocks.livingrock));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingrockBrickWall, TextureMapping.m_125740_((Block)ModBlocks.livingrockBrick));
        this.wallBlock(remainingBlocks, ModFluffBlocks.livingrockBrickMossyWall, TextureMapping.m_125740_((Block)ModBlocks.livingrockBrickMossy));
        this.fenceBlock(ModFluffBlocks.dreamwoodFence, TextureMapping.m_125740_((Block)ModBlocks.dreamwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.dreamwoodFenceGate, TextureMapping.m_125740_((Block)ModBlocks.dreamwoodPlanks));
        this.fenceBlock(ModFluffBlocks.livingwoodFence, TextureMapping.m_125740_((Block)ModBlocks.livingwoodPlanks));
        this.fenceGateBlock(ModFluffBlocks.livingwoodFenceGate, TextureMapping.m_125740_((Block)ModBlocks.livingwoodPlanks));
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFence);
        remainingBlocks.remove(ModFluffBlocks.dreamwoodFenceGate);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFence);
        remainingBlocks.remove(ModFluffBlocks.livingwoodFenceGate);
        this.particleOnly(remainingBlocks, ModBlocks.animatedTorch, TextureMapping.m_125740_((Block)Blocks.f_50174_));
        this.particleOnly(remainingBlocks, ModBlocks.avatar, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, ModBlocks.bellows, TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog));
        this.particleOnly(remainingBlocks, ModBlocks.brewery, TextureMapping.m_125740_((Block)ModBlocks.livingrock));
        this.particleOnly(remainingBlocks, ModBlocks.corporeaIndex, TextureMapping.m_125740_((Block)ModBlocks.corporeaBlock));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDetector, TextureMapping.m_125740_((Block)ModBlocks.lightRelayDetector));
        this.singleVariantBlockState(ModBlocks.fakeAir, new ModelTemplate(Optional.empty(), Optional.empty(), new TextureSlot[0]).m_125592_(ModBlocks.fakeAir, new TextureMapping(), this.modelOutput));
        remainingBlocks.remove(ModBlocks.fakeAir);
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayFork, TextureMapping.m_125740_((Block)ModBlocks.lightRelayFork));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHead, TextureMapping.m_125740_((Block)Blocks.f_50135_));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaHeadWall, TextureMapping.m_125740_((Block)Blocks.f_50135_));
        this.particleOnly(remainingBlocks, ModBlocks.gaiaPylon, TextureMapping.m_125740_((Block)ModBlocks.elementiumBlock));
        this.particleOnly(remainingBlocks, ModBlocks.hourglass, TextureMapping.m_125740_((Block)ModBlocks.manaGlass));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayDefault, TextureMapping.m_125740_((Block)ModBlocks.lightRelayDefault));
        this.particleOnly(remainingBlocks, ModBlocks.manaFlame, new ResourceLocation("block/fire_0"));
        this.particleOnly(remainingBlocks, ModBlocks.manaPylon, TextureMapping.m_125740_((Block)ModBlocks.manasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.naturaPylon, TextureMapping.m_125740_((Block)ModBlocks.terrasteelBlock));
        this.particleOnly(remainingBlocks, ModBlocks.teruTeruBozu, TextureMapping.m_125740_((Block)Blocks.f_50041_));
        this.particleOnly(remainingBlocks, ModBlocks.lightRelayToggle, TextureMapping.m_125740_((Block)ModBlocks.lightRelayToggle));
        Predicate<Block> flowers = b -> b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockModFlower;
        ModelTemplate crossTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cross")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125882_});
        BlockstateProvider.takeAll(remainingBlocks, flowers).forEach(b -> this.singleVariantBlockState((Block)b, crossTemplate.m_125592_(b, TextureMapping.m_125780_((Block)b), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockMotifFlower).forEach(b -> {
            String name = Registry.f_122824_.m_7981_(b).m_135815_().replace("_motif", "");
            this.singleVariantBlockState((Block)b, crossTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125882_, ResourceLocationHelper.prefix("block/" + name)), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.corporeaFunnel, ModBlocks.corporeaInterceptor, ModBlocks.corporeaRetainer).forEach(b -> this.singleVariantBlockState((Block)b, ModelTemplates.f_125694_.m_125592_(b, TextureMapping.m_125763_((ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_side"), (ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_end")), this.modelOutput)));
        ModelTemplate drumModelTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/drum")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125875_});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.gatheringDrum, ModBlocks.canopyDrum, ModBlocks.wildDrum).forEach(b -> this.singleVariantBlockState((Block)b, drumModelTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125872_, ResourceLocationHelper.prefix("block/drum_top")).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125740_((Block)b)), this.modelOutput)));
        TextureSlot outsideSlot = AccessorTextureSlot.make("outside");
        TextureSlot coreSlot = AccessorTextureSlot.make("core");
        ModelTemplate spreaderTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125874_, TextureSlot.f_176491_, outsideSlot});
        ModelTemplate spreaderCoreTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_core")), Optional.of("_core"), new TextureSlot[]{coreSlot});
        ModelTemplate spreaderPaddingTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_padding")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaSpreader, ModBlocks.redstoneSpreader, ModBlocks.gaiaSpreader, ModBlocks.elvenSpreader).forEach(b -> {
            ResourceLocation outside = b == ModBlocks.redstoneSpreader || b == ModBlocks.manaSpreader ? TextureMapping.m_125740_((Block)ModBlocks.livingwoodLog) : (b == ModBlocks.elvenSpreader ? TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLog, (String)"/4") : TextureMapping.m_125753_((Block)b, (String)"_outside"));
            ResourceLocation inside = b == ModBlocks.redstoneSpreader || b == ModBlocks.manaSpreader ? TextureMapping.m_125740_((Block)ModBlocks.livingwoodLogStripped) : (b == ModBlocks.elvenSpreader ? TextureMapping.m_125753_((Block)ModBlocks.dreamwoodLogStripped, (String)"/4") : TextureMapping.m_125753_((Block)b, (String)"_inside"));
            this.singleVariantBlockState((Block)b, spreaderTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_side")).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125753_((Block)b, (String)"_back")).m_125758_(TextureSlot.f_176491_, inside).m_125758_(outsideSlot, outside), this.modelOutput));
            spreaderCoreTemplate.m_125592_(b, new TextureMapping().m_125758_(coreSlot, TextureMapping.m_125753_((Block)b, (String)"_core")), this.modelOutput);
        });
        for (DyeColor color : DyeColor.values()) {
            String[] wool = ColorHelper.WOOL_MAP.apply(color);
            spreaderPaddingTemplate.m_125612_(ResourceLocationHelper.prefix("block/" + color.m_41065_() + "_spreader_padding"), new TextureMapping().m_125758_(TextureSlot.f_125867_, TextureMapping.m_125740_((Block)wool)), this.modelOutput);
        }
        TextureSlot liquidSlot = AccessorTextureSlot.make("liquid");
        ModelTemplate poolTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_});
        ModelTemplate poolFullTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/pool_full")), Optional.of("_full"), new TextureSlot[]{TextureSlot.f_125867_, liquidSlot});
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.manaPool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.creativePool).forEach(b -> {
            ResourceLocation tex = b == ModBlocks.manaPool || b == ModBlocks.fabulousPool ? TextureMapping.m_125740_((Block)ModBlocks.livingrock) : TextureMapping.m_125740_((Block)b);
            poolFullTemplate.m_125592_(b, TextureMapping.m_125776_((ResourceLocation)tex).m_125758_(liquidSlot, ResourceLocationHelper.prefix("block/mana_water")), this.modelOutput);
            this.singleVariantBlockState((Block)b, poolTemplate.m_125592_(b, TextureMapping.m_125776_((ResourceLocation)tex), this.modelOutput));
        });
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.pump, ModBlocks.tinyPotato).forEach(b -> this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)b, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)ModelLocationUtils.m_125576_((Block)b))).m_125271_(AccessorBlockModelGenerators.horizontalDispatch())));
        BlockstateProvider.takeAll(remainingBlocks, ModBlocks.enderEye, ModBlocks.manaDetector).forEach(b -> {
            ResourceLocation offModel = ModelTemplates.f_125692_.m_125592_(b, TextureMapping.m_125748_((Block)b), this.modelOutput);
            ResourceLocation onModel = ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)b, (String)"_powered"), TextureMapping.m_125776_((ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_powered")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)b).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)offModel)).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)onModel))));
        });
        ResourceLocation petalBlockModel = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_all_tinted")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125867_}).m_125612_(ResourceLocationHelper.prefix("block/petal_block"), new TextureMapping().m_125758_(TextureSlot.f_125867_, ResourceLocationHelper.prefix("block/petal_block")), this.modelOutput);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockPetalBlock).forEach(b -> this.singleVariantBlockState((Block)b, petalBlockModel));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltGrass).forEach(b -> {
            ResourceLocation model = ModelTemplates.f_125697_.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_side")).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125740_((Block)Blocks.f_50493_)).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125259_((Block)b, (Variant[])AccessorBlockModelGenerators.createRotatedVariants(model)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockRedString).forEach(this::redStringBlock);
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModDoubleFlower).forEach(b -> {
            ResourceLocation bottom = ModelTemplates.f_125639_.m_125592_(b, TextureMapping.m_125780_((Block)b), this.modelOutput);
            ResourceLocation top = ModelTemplates.f_125639_.m_125612_(ModelLocationUtils.m_125578_((Block)b, (String)"_top"), TextureMapping.m_125788_((ResourceLocation)TextureMapping.m_125753_((Block)b, (String)"_top")), this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)b).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)TallFlowerBlock.f_52858_).m_125329_((Comparable)DoubleBlockHalf.LOWER, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottom)).m_125329_((Comparable)DoubleBlockHalf.UPPER, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)top))));
        });
        for (String variant : new String[]{"desert", "forest", "fungal", "mesa", "mountain", "plains", "swamp", "taiga"}) {
            ResourceLocation baseId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone");
            Block base = (Block)Registry.f_122824_.m_6612_(baseId).get();
            this.cubeAll(base);
            ResourceLocation cobbleId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone");
            Block cobble = (Block)Registry.f_122824_.m_6612_(cobbleId).get();
            this.cubeAll(cobble);
            ResourceLocation cobbleWallId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone_wall");
            Block cobbleWall = (Block)Registry.f_122824_.m_6612_(cobbleWallId).get();
            this.wallBlock(remainingBlocks, cobbleWall, TextureMapping.m_125740_((Block)cobble));
            ResourceLocation brickId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks");
            Block brick = (Block)Registry.f_122824_.m_6612_(brickId).get();
            this.cubeAll(brick);
            ResourceLocation brickWallId = ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks_wall");
            Block brickWall = (Block)Registry.f_122824_.m_6612_(brickWallId).get();
            this.wallBlock(remainingBlocks, brickWall, TextureMapping.m_125740_((Block)brick));
            ResourceLocation chiseledBricksId = ResourceLocationHelper.prefix("chiseled_metamorphic_" + variant + "_bricks");
            Block chiseledBricks = (Block)Registry.f_122824_.m_6612_(chiseledBricksId).get();
            this.cubeAll(chiseledBricks);
            remainingBlocks.removeAll(Arrays.asList(base, cobble, brick, chiseledBricks));
        }
        for (String variant : new String[]{"dark", "mana", "blaze", "lavender", "red", "elf", "sunny"}) {
            ResourceLocation quartzId = ResourceLocationHelper.prefix(variant + "_quartz");
            Block quartz = (Block)Registry.f_122824_.m_6612_(quartzId).get();
            this.singleVariantBlockState(quartz, ModelTemplates.f_125697_.m_125592_(quartz, TextureMapping.m_125826_((Block)quartz), this.modelOutput));
            ResourceLocation pillarId = ResourceLocationHelper.prefix(variant + "_quartz_pillar");
            Block pillar = (Block)Registry.f_122824_.m_6612_(pillarId).get();
            ResourceLocation pillarModel = ModelTemplates.f_125694_.m_125592_(pillar, TextureMapping.m_125763_((ResourceLocation)TextureMapping.m_125753_((Block)pillar, (String)"_side"), (ResourceLocation)TextureMapping.m_125753_((Block)pillar, (String)"_end")), this.modelOutput);
            this.blockstates.add(AccessorBlockModelGenerators.createAxisAlignedPillarBlock(pillar, pillarModel));
            ResourceLocation chiseledId = ResourceLocationHelper.prefix("chiseled_" + variant + "_quartz");
            Block chiseled = (Block)Registry.f_122824_.m_6612_(chiseledId).get();
            this.singleVariantBlockState(chiseled, ModelTemplates.f_125694_.m_125592_(chiseled, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)chiseled, (String)"_side")).m_125758_(TextureSlot.f_125870_, TextureMapping.m_125753_((Block)chiseled, (String)"_end")), this.modelOutput));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
        }
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockBuriedPetals).forEach(b -> {
            DyeColor color = ((BlockBuriedPetals)b).color;
            ResourceLocation wool = new ResourceLocation("block/" + color.m_7912_() + "_wool");
            this.particleOnly(remainingBlocks, (Block)b, wool);
        });
        TextureSlot gobletSlot = AccessorTextureSlot.make("goblet");
        TextureSlot topBottomSlot = AccessorTextureSlot.make("top_bottom");
        ModelTemplate apothecaryTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/petal_apothecary")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_, gobletSlot, topBottomSlot});
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockAltar).forEach(b -> this.singleVariantBlockState((Block)b, apothecaryTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_side")).m_125758_(gobletSlot, TextureMapping.m_125753_((Block)b, (String)"_goblet")).m_125758_(topBottomSlot, TextureMapping.m_125753_((Block)b, (String)"_top_bottom")), this.modelOutput)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockFloatingFlower).forEach(b -> this.singleVariantBlockState((Block)b, ModelLocationUtils.m_125576_((Block)b)));
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof BlockModPane).forEach(b -> {
            String name = Registry.f_122824_.m_7981_(b).m_135815_();
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125889_, TextureMapping.m_125740_((Block)b)).m_125758_(TextureSlot.f_125888_, ResourceLocationHelper.prefix("block/" + name.substring(0, name.length() - "_pane".length())));
            ResourceLocation postModel = ModelTemplates.f_125673_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation sideModel = ModelTemplates.f_125674_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation sideAltModel = ModelTemplates.f_125675_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation noSideModel = ModelTemplates.f_125671_.m_125592_(b, mapping, this.modelOutput);
            ResourceLocation noSideAltModel = ModelTemplates.f_125672_.m_125592_(b, mapping, this.modelOutput);
            this.blockstates.add((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)b).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)postModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideAltModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)sideAltModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideAltModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideAltModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)noSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)));
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof StairBlock).forEach(b -> {
            String name = Registry.f_122824_.m_7981_(b).m_135815_();
            String baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = ResourceLocationHelper.prefix("block/" + baseName + "_side");
                ResourceLocation bottom = ResourceLocationHelper.prefix("block/" + baseName + "_bottom");
                ResourceLocation top = ResourceLocationHelper.prefix("block/" + baseName + "_top");
                this.stairsBlock((Set<Block>)new HashSet<Block>(), (Block)b, side, bottom, top);
            } else {
                ResourceLocation tex = ResourceLocationHelper.prefix("block/" + baseName);
                this.stairsBlock((Set<Block>)new HashSet<Block>(), (Block)b, tex, tex, tex);
            }
        });
        BlockstateProvider.takeAll(remainingBlocks, b -> b instanceof SlabBlock).forEach(slabBlock -> {
            String name = Registry.f_122824_.m_7981_(slabBlock).m_135815_();
            String baseName = name.substring(0, name.length() - "_slab".length());
            Block base = (Block)Registry.f_122824_.m_6612_(ResourceLocationHelper.prefix(baseName)).get();
            boolean quartz = name.contains("quartz");
            if (quartz) {
                ResourceLocation side = TextureMapping.m_125753_((Block)base, (String)"_side");
                ResourceLocation bottom = TextureMapping.m_125753_((Block)base, (String)"_bottom");
                ResourceLocation top = TextureMapping.m_125753_((Block)base, (String)"_top");
                ResourceLocation doubleModel = ModelLocationUtils.m_125576_((Block)base);
                this.slabBlock((Set<Block>)new HashSet<Block>(), (Block)slabBlock, doubleModel, side, bottom, top);
            } else {
                ResourceLocation baseTex = TextureMapping.m_125740_((Block)base);
                ResourceLocation doubleModel = ModelLocationUtils.m_125576_((Block)base);
                this.slabBlock((Set<Block>)new HashSet<Block>(), (Block)slabBlock, doubleModel, baseTex, baseTex, baseTex);
            }
        });
        remainingBlocks.forEach(this::cubeAll);
    }

    protected void particleOnly(Set<Block> blocks, Block b, ResourceLocation particle) {
        this.singleVariantBlockState(b, ModelTemplates.f_125626_.m_125592_(b, TextureMapping.m_125812_((ResourceLocation)particle), this.modelOutput));
        blocks.remove(b);
    }

    protected void manualModel(Set<Block> blocks, Block b) {
        this.singleVariantBlockState(b, ModelLocationUtils.m_125576_((Block)b));
        blocks.remove(b);
    }

    protected void stairsBlock(Set<Block> blocks, Block block, ResourceLocation sideTex, ResourceLocation bottomTex, ResourceLocation topTex) {
        this.stairsBlockWithVariants(blocks, block, new ResourceLocation[]{sideTex}, new ResourceLocation[]{bottomTex}, new ResourceLocation[]{topTex});
    }

    protected void stairsBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] innerModels = new ResourceLocation[length];
        ResourceLocation[] straightModels = new ResourceLocation[length];
        ResourceLocation[] outerModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, sideTextures[i]).m_125758_(TextureSlot.f_125871_, bottomTextures[i]).m_125758_(TextureSlot.f_125872_, topTextures[i]);
            ResourceLocation modelIdInner = ModelLocationUtils.m_125578_((Block)block, (String)("_inner" + suffix));
            ResourceLocation modelIdStraight = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdOuter = ModelLocationUtils.m_125578_((Block)block, (String)("_outer" + suffix));
            innerModels[i] = ModelTemplates.f_125631_.m_125612_(modelIdInner, mapping, this.modelOutput);
            straightModels[i] = ModelTemplates.f_125630_.m_125612_(modelIdStraight, mapping, this.modelOutput);
            outerModels[i] = ModelTemplates.f_125632_.m_125612_(modelIdOuter, mapping, this.modelOutput);
        }
        this.stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels);
    }

    protected void stairsBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] innerModels, ResourceLocation[] straightModels, ResourceLocation[] outerModels) {
        PropertyDispatch.C3 propertyDispatch = PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61398_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            for (Half half : Half.values()) {
                for (StairsShape stairsShape : StairsShape.values()) {
                    boolean isRight;
                    boolean isLeft = stairsShape == StairsShape.INNER_LEFT || stairsShape == StairsShape.OUTER_LEFT;
                    boolean bl = isRight = stairsShape == StairsShape.INNER_RIGHT || stairsShape == StairsShape.OUTER_RIGHT;
                    int rotationOffset = isLeft && half == Half.BOTTOM ? -1 : (isRight && half == Half.TOP ? 1 : 0);
                    VariantProperties.Rotation[] rotations = VariantProperties.Rotation.values();
                    VariantProperties.Rotation yRot = switch (direction) {
                        case Direction.EAST -> rotations[(4 + rotationOffset) % 4];
                        case Direction.WEST -> rotations[(2 + rotationOffset) % 4];
                        case Direction.SOUTH -> rotations[(1 + rotationOffset) % 4];
                        case Direction.NORTH -> rotations[(3 + rotationOffset) % 4];
                        default -> throw new IllegalStateException();
                    };
                    VariantProperties.Rotation xRot = switch (half) {
                        default -> throw new IncompatibleClassChangeError();
                        case Half.BOTTOM -> VariantProperties.Rotation.R0;
                        case Half.TOP -> VariantProperties.Rotation.R180;
                    };
                    ResourceLocation[] models = switch (stairsShape) {
                        default -> throw new IncompatibleClassChangeError();
                        case StairsShape.STRAIGHT -> straightModels;
                        case StairsShape.OUTER_RIGHT, StairsShape.OUTER_LEFT -> outerModels;
                        case StairsShape.INNER_RIGHT, StairsShape.INNER_LEFT -> innerModels;
                    };
                    propertyDispatch.m_125396_((Comparable)direction, (Comparable)half, (Comparable)stairsShape, Stream.of(models).map(rl -> {
                        Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl);
                        if (xRot != VariantProperties.Rotation.R0) {
                            variant.m_125511_(VariantProperties.f_125518_, (Object)xRot);
                        }
                        if (yRot != VariantProperties.Rotation.R0) {
                            variant.m_125511_(VariantProperties.f_125519_, (Object)yRot);
                        }
                        variant.m_125511_(VariantProperties.f_125521_, (Object)true);
                        return variant;
                    }).toList());
                }
            }
        }
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)propertyDispatch));
        blocks.remove(block);
    }

    protected void slabBlock(Set<Block> blocks, Block block, ResourceLocation doubleModel, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlockWithVariants(blocks, block, new ResourceLocation[]{doubleModel}, new ResourceLocation[]{side}, new ResourceLocation[]{bottom}, new ResourceLocation[]{top});
    }

    protected void slabBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] doubleModels, ResourceLocation[] sideTextures, ResourceLocation[] bottomTextures, ResourceLocation[] topTextures) {
        int length = sideTextures.length;
        if (length != topTextures.length || length != bottomTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] bottomModels = new ResourceLocation[length];
        ResourceLocation[] topModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125875_, sideTextures[i]).m_125758_(TextureSlot.f_125871_, bottomTextures[i]).m_125758_(TextureSlot.f_125872_, topTextures[i]);
            ResourceLocation modelIdBottom = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdTop = ModelLocationUtils.m_125578_((Block)block, (String)("_top" + suffix));
            bottomModels[i] = ModelTemplates.f_125627_.m_125612_(modelIdBottom, mapping, this.modelOutput);
            topModels[i] = ModelTemplates.f_125628_.m_125612_(modelIdTop, mapping, this.modelOutput);
        }
        this.slabBlockWithModels(blocks, block, bottomModels, topModels, doubleModels);
    }

    protected void slabBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] bottomModels, ResourceLocation[] topModels, ResourceLocation[] doubleModels) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61397_).m_125332_((Comparable)SlabType.BOTTOM, Stream.of(bottomModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList()).m_125332_((Comparable)SlabType.TOP, Stream.of(topModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList()).m_125332_((Comparable)SlabType.DOUBLE, Stream.of(doubleModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList())));
        blocks.remove(block);
    }

    protected void wallBlock(Set<Block> blocks, Block block, ResourceLocation texture) {
        this.wallBlockWithVariants(blocks, block, new ResourceLocation[]{texture});
    }

    protected void wallBlockWithVariants(Set<Block> blocks, Block block, ResourceLocation[] sideTextures) {
        int length = sideTextures.length;
        ResourceLocation[] postModels = new ResourceLocation[length];
        ResourceLocation[] lowModels = new ResourceLocation[length];
        ResourceLocation[] tallModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            TextureMapping mapping = new TextureMapping().m_125758_(TextureSlot.f_125884_, sideTextures[i]);
            ResourceLocation modelIdPost = ModelLocationUtils.m_125578_((Block)block, (String)("_post" + suffix));
            ResourceLocation modelIdLow = ModelLocationUtils.m_125578_((Block)block, (String)("_side" + suffix));
            ResourceLocation modelIdTall = ModelLocationUtils.m_125578_((Block)block, (String)("_side_tall" + suffix));
            postModels[i] = ModelTemplates.f_125711_.m_125612_(modelIdPost, mapping, this.modelOutput);
            lowModels[i] = ModelTemplates.f_125712_.m_125612_(modelIdLow, mapping, this.modelOutput);
            tallModels[i] = ModelTemplates.f_125713_.m_125612_(modelIdTall, mapping, this.modelOutput);
        }
        this.wallBlockWithModels(blocks, block, postModels, lowModels, tallModels);
    }

    protected void wallBlockWithModels(Set<Block> blocks, Block block, ResourceLocation[] postModels, ResourceLocation[] lowModels, ResourceLocation[] tallModels) {
        MultiPartGenerator multiPartGenerator = MultiPartGenerator.m_125204_((Block)block);
        multiPartGenerator.m_125212_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true)), Stream.of(postModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList());
        List<EnumProperty> wallSides = List.of(BlockStateProperties.f_61378_, BlockStateProperties.f_61381_, BlockStateProperties.f_61380_, BlockStateProperties.f_61379_);
        for (EnumProperty wallSide : wallSides) {
            VariantProperties.Rotation yRot = wallSide == BlockStateProperties.f_61378_ ? VariantProperties.Rotation.R90 : (wallSide == BlockStateProperties.f_61381_ ? VariantProperties.Rotation.R270 : (wallSide == BlockStateProperties.f_61380_ ? VariantProperties.Rotation.R180 : VariantProperties.Rotation.R0));
            multiPartGenerator.m_125212_((Condition)Condition.m_125135_().m_125176_((Property)wallSide, (Comparable)WallSide.LOW), Stream.of(lowModels).map(rl -> {
                Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl);
                if (yRot != VariantProperties.Rotation.R0) {
                    variant.m_125511_(VariantProperties.f_125519_, (Object)yRot);
                }
                variant.m_125511_(VariantProperties.f_125521_, (Object)true);
                return variant;
            }).toList()).m_125212_((Condition)Condition.m_125135_().m_125176_((Property)wallSide, (Comparable)WallSide.TALL), Stream.of(tallModels).map(rl -> {
                Variant variant = Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl);
                if (yRot != VariantProperties.Rotation.R0) {
                    variant.m_125511_(VariantProperties.f_125519_, (Object)yRot);
                }
                variant.m_125511_(VariantProperties.f_125521_, (Object)true);
                return variant;
            }).toList());
        }
        this.blockstates.add((BlockStateGenerator)multiPartGenerator);
        blocks.remove(block);
    }

    protected void fenceBlock(Block block, ResourceLocation tex) {
        TextureMapping mapping = TextureMapping.m_125761_((ResourceLocation)tex);
        ResourceLocation postModel = ModelTemplates.f_125708_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation sideModel = ModelTemplates.f_125709_.m_125592_(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceState(block, postModel, sideModel));
    }

    protected void fenceGateBlock(Block block, ResourceLocation tex) {
        TextureMapping mapping = TextureMapping.m_125761_((ResourceLocation)tex);
        ResourceLocation openModel = ModelTemplates.f_125621_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation closedModel = ModelTemplates.f_125715_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation openWallModel = ModelTemplates.f_125623_.m_125592_(block, mapping, this.modelOutput);
        ResourceLocation closedWallModel = ModelTemplates.f_125622_.m_125592_(block, mapping, this.modelOutput);
        this.blockstates.add(AccessorBlockModelGenerators.makeFenceGateState(block, openModel, closedModel, openWallModel, closedWallModel));
    }

    protected void cubeAll(Block b) {
        ResourceLocation model = ModelTemplates.f_125692_.m_125592_(b, TextureMapping.m_125748_((Block)b), this.modelOutput);
        this.singleVariantBlockState(b, model);
    }

    protected void singleVariantBlockState(Block b, ResourceLocation model) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)b, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)));
    }

    protected void pillar(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation side) {
        this.pillarWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void pillarWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures) {
        int length = topTextures.length;
        if (length != sideTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalModels = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            ResourceLocation modelIdTop = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontal = ModelLocationUtils.m_125578_((Block)block, (String)("_horizontal" + suffix));
            topModels[i] = ModelTemplates.f_125694_.m_125612_(modelIdTop, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalModels[i] = ModelTemplates.f_125695_.m_125612_(modelIdHorizontal, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
        }
        this.pillarWithModels(blocks, block, topModels, horizontalModels);
    }

    protected void pillarWithModels(Set<Block> blocks, Block block, ResourceLocation[] topModels, ResourceLocation[] horizontalModels) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125332_((Comparable)Direction.Axis.Y, Stream.of(topModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList()).m_125332_((Comparable)Direction.Axis.Z, Stream.of(horizontalModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).toList()).m_125332_((Comparable)Direction.Axis.X, Stream.of(horizontalModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).toList())));
        blocks.remove(block);
    }

    protected void pillarAlt(Set<Block> blocks, Block block, ResourceLocation top, ResourceLocation side) {
        this.pillarAltWithVariants(blocks, block, new ResourceLocation[]{top}, new ResourceLocation[]{side});
    }

    protected void pillarAltWithVariants(Set<Block> blocks, Block block, ResourceLocation[] topTextures, ResourceLocation[] sideTextures) {
        int length = topTextures.length;
        if (length != sideTextures.length) {
            throw new IllegalArgumentException("Arrays must have equal length");
        }
        ResourceLocation[] topModels = new ResourceLocation[length];
        ResourceLocation[] horizontalXModels = new ResourceLocation[length];
        ResourceLocation[] horizontalZModels = new ResourceLocation[length];
        ModelTemplate horizontalXTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_x")), Optional.of("_horizontal_x"), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
        ModelTemplate horizontalZTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/cube_column_horizontal_z")), Optional.of("_horizontal_z"), new TextureSlot[]{TextureSlot.f_125870_, TextureSlot.f_125875_});
        for (int i = 0; i < length; ++i) {
            String suffix = length == 1 ? "" : "_" + (i + 1);
            ResourceLocation modelIdTop = ModelLocationUtils.m_125578_((Block)block, (String)suffix);
            ResourceLocation modelIdHorizontalX = ModelLocationUtils.m_125578_((Block)block, (String)("_horizontal_x" + suffix));
            ResourceLocation modelIdHorizontalZ = ModelLocationUtils.m_125578_((Block)block, (String)("_horizontal_z" + suffix));
            topModels[i] = ModelTemplates.f_125694_.m_125612_(modelIdTop, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalXModels[i] = horizontalXTemplate.m_125612_(modelIdHorizontalX, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
            horizontalZModels[i] = horizontalZTemplate.m_125612_(modelIdHorizontalZ, TextureMapping.m_125763_((ResourceLocation)sideTextures[i], (ResourceLocation)topTextures[i]), this.modelOutput);
        }
        this.pillarAltWithModels(blocks, block, topModels, horizontalXModels, horizontalZModels);
    }

    protected void pillarAltWithModels(Set<Block> blocks, Block block, ResourceLocation[] yModels, ResourceLocation[] xModels, ResourceLocation[] zModels) {
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)block).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125332_((Comparable)Direction.Axis.Y, Stream.of(yModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList()).m_125332_((Comparable)Direction.Axis.X, Stream.of(xModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList()).m_125332_((Comparable)Direction.Axis.Z, Stream.of(zModels).map(rl -> Variant.m_125501_().m_125511_(VariantProperties.f_125520_, rl)).toList())));
        blocks.remove(block);
    }

    @SafeVarargs
    public static <T> Collection<T> takeAll(Set<? extends T> src, T ... items) {
        List<T> ret = Arrays.asList(items);
        for (T item : items) {
            if (src.contains(item)) continue;
            BotaniaAPI.LOGGER.warn("Item {} not found in set", item);
        }
        if (!src.removeAll(ret)) {
            BotaniaAPI.LOGGER.warn("takeAll array didn't yield anything ({})", (Object)Arrays.toString(items));
        }
        return ret;
    }

    public static <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!pred.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            BotaniaAPI.LOGGER.warn("takeAll predicate yielded nothing", new Throwable());
        }
        return ret;
    }

    protected void redStringBlock(Block b) {
        ResourceLocation selfName = TextureMapping.m_125740_((Block)b);
        ResourceLocation front = ResourceLocationHelper.prefix("block/red_string_sender");
        ResourceLocation model = ModelTemplates.f_125698_.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125872_, selfName).m_125758_(TextureSlot.f_125873_, front).m_125758_(TextureSlot.f_125875_, selfName), this.modelOutput);
        this.blockstates.add((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)b, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)).m_125271_(AccessorBlockModelGenerators.facingDispatch()));
    }
}

