/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import vazkii.botania.common.world.IslandPos;
import vazkii.botania.xplat.BotaniaConfig;

public class SkyblockSavedData
extends SavedData {
    private static final String NAME = "gog_skyblock_islands";
    private static final int OFFSET = 1;
    public final BiMap<IslandPos, UUID> skyblocks;
    private final Spiral spiral;

    public SkyblockSavedData(CompoundTag nbt) {
        HashBiMap map = HashBiMap.create();
        for (Tag inbt : nbt.m_128437_("Islands", 10)) {
            CompoundTag tag = (CompoundTag)inbt;
            map.put((Object)IslandPos.fromTag(tag), (Object)tag.m_128342_("Player"));
        }
        this.skyblocks = map;
        this.spiral = nbt.m_128425_("SpiralState", 11) ? Spiral.fromArray(nbt.m_128465_("SpiralState")) : new Spiral();
    }

    public static SkyblockSavedData get(ServerLevel world) {
        return (SkyblockSavedData)world.m_8895_().m_164861_(SkyblockSavedData::new, () -> new SkyblockSavedData(new CompoundTag()), NAME);
    }

    public IslandPos getSpawn() {
        if (this.skyblocks.containsValue((Object)Util.f_137441_)) {
            return (IslandPos)this.skyblocks.inverse().get((Object)Util.f_137441_);
        }
        IslandPos pos = new IslandPos(1, 1);
        this.skyblocks.put((Object)pos, (Object)Util.f_137441_);
        this.m_77762_();
        return pos;
    }

    public IslandPos create(UUID playerId) {
        int[] pos;
        IslandPos islandPos;
        int scale = BotaniaConfig.common().gogIslandScaleMultiplier();
        while (this.skyblocks.containsKey((Object)(islandPos = new IslandPos((pos = this.spiral.next())[0] * scale + 1, pos[1] * scale + 1)))) {
        }
        this.skyblocks.put((Object)islandPos, (Object)playerId);
        this.m_77762_();
        return islandPos;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        ListTag list = new ListTag();
        for (Map.Entry entry : this.skyblocks.entrySet()) {
            CompoundTag entryTag = ((IslandPos)entry.getKey()).toTag();
            entryTag.m_128362_("Player", (UUID)entry.getValue());
            list.add((Object)entryTag);
        }
        nbt.m_128385_("SpiralState", this.spiral.toIntArray());
        nbt.m_128365_("Islands", (Tag)list);
        return nbt;
    }

    private static class Spiral {
        private int x = 0;
        private int y = 0;
        private int dx = 0;
        private int dy = -1;

        Spiral() {
        }

        Spiral(int x, int y, int dx, int dy) {
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
        }

        int[] next() {
            if (this.x == this.y || this.x < 0 && this.x == -this.y || this.x > 0 && this.x == 1 - this.y) {
                int t = this.dx;
                this.dx = -this.dy;
                this.dy = t;
            }
            this.x += this.dx;
            this.y += this.dy;
            return new int[]{this.x, this.y};
        }

        int[] toIntArray() {
            return new int[]{this.x, this.y, this.dx, this.dy};
        }

        static Spiral fromArray(int[] ints) {
            return new Spiral(ints[0], ints[1], ints[2], ints[3]);
        }
    }
}

