/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.LensMine;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.BotaniaConfig;

public class LensWeight
extends Lens {
    @Override
    public boolean collideBurst(IManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        if (!entity.f_19853_.f_46443_ && !burst.isFake() && pos.m_6662_() == HitResult.Type.BLOCK) {
            int harvestLevel = BotaniaConfig.common().harvestLevelWeight();
            ServerLevel level = (ServerLevel)entity.f_19853_;
            BlockPos bPos = ((BlockHitResult)pos).m_82425_();
            BlockState state = level.m_8055_(bPos);
            if (FallingBlock.m_53241_((BlockState)level.m_8055_(bPos.m_7495_())) && state.m_60800_((BlockGetter)level, bPos) != -1.0f && level.m_7702_(bPos) == null && LensWeight.canSilkTouch(level, bPos, state, harvestLevel, entity.m_37282_())) {
                FallingBlockEntity falling = new FallingBlockEntity((Level)level, (double)bPos.m_123341_() + 0.5, (double)bPos.m_123342_(), (double)bPos.m_123343_() + 0.5, state);
                falling.f_31942_ = 1;
                level.m_7471_(bPos, false);
                level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), (double)bPos.m_123341_() + 0.5, (double)bPos.m_123342_() + 0.5, (double)bPos.m_123343_() + 0.5, 10, 0.45, 0.45, 0.45, 5.0);
                level.m_7967_((Entity)falling);
            }
        }
        return shouldKill;
    }

    private static boolean canSilkTouch(ServerLevel level, BlockPos pos, BlockState state, int harvestLevel, @Nullable Entity owner) {
        if (state.m_60620_(ModTags.Blocks.WEIGHT_LENS_WHITELIST)) {
            return true;
        }
        ItemStack harvestToolStack = LensMine.getHarvestToolStack(harvestLevel, state).m_41777_();
        if (harvestToolStack.m_41619_()) {
            return false;
        }
        harvestToolStack.m_41663_(Enchantments.f_44985_, 1);
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, null, (Entity)owner, (ItemStack)harvestToolStack);
        Item blockItem = state.m_60734_().m_5456_();
        return drops.stream().anyMatch(s -> s.m_41720_() == blockItem);
    }
}

