/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ICompositableLens;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ILensControl;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.Lens;
import vazkii.botania.common.item.lens.LensStorm;

public class ItemLens
extends Item
implements ILensControl,
ICompositableLens,
ITinyPlanetExcempt {
    public static final int PROP_NONE = 0;
    public static final int PROP_POWER = 1;
    public static final int PROP_ORIENTATION = 2;
    public static final int PROP_TOUCH = 4;
    public static final int PROP_INTERACTION = 8;
    public static final int PROP_DAMAGE = 16;
    public static final int PROP_CONTROL = 32;
    private static final String TAG_COLOR = "color";
    private static final String TAG_COMPOSITE_LENS = "compositeLens";
    private final Lens lens;
    private final int props;

    public ItemLens(Item.Properties builder, Lens lens, int props) {
        super(builder);
        this.lens = lens;
        this.props = props;
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor != -1) {
            TranslatableComponent colorName = new TranslatableComponent((String)(storedColor == 16 ? "botania.color.rainbow" : "color.minecraft." + DyeColor.m_41053_((int)storedColor)));
            TextColor realColor = TextColor.m_131266_((int)this.getLensColor(stack, world));
            stacks.add((Component)new TranslatableComponent("botaniamisc.color", new Object[]{colorName}).m_130938_(s -> s.m_131148_(realColor)));
        }
        if (this.lens instanceof LensStorm) {
            stacks.add((Component)new TranslatableComponent("botaniamisc.creative").m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens.m_41619_()) {
            return super.m_7626_(stack);
        }
        String shortKeyA = stack.m_41778_() + ".short";
        String shortKeyB = compositeLens.m_41778_() + ".short";
        return new TranslatableComponent("item.botania.composite_lens", new Object[]{new TranslatableComponent(shortKeyA), new TranslatableComponent(shortKeyB)});
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props, Level level) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor != -1) {
            props.color = this.getLensColor(stack, level);
        }
        ItemLens.getLens(stack).apply(stack, props);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.m_41619_() && compositeLens.m_41720_() instanceof ILens) {
            ((ILens)compositeLens.m_41720_()).apply(compositeLens, props, level);
        }
    }

    @Override
    public boolean collideBurst(IManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        shouldKill = ItemLens.getLens(stack).collideBurst(burst, pos, isManaBlock, shouldKill, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.m_41619_() && compositeLens.m_41720_() instanceof ILens) {
            shouldKill = ((ILens)compositeLens.m_41720_()).collideBurst(burst, pos, isManaBlock, shouldKill, compositeLens);
        }
        return shouldKill;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == 16 && burst.entity().f_19853_.f_46443_) {
            burst.setColor(this.getLensColor(stack, burst.entity().f_19853_));
        }
        ItemLens.getLens(stack).updateBurst(burst, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.m_41619_() && compositeLens.m_41720_() instanceof ILens) {
            ((ILens)compositeLens.m_41720_()).updateBurst(burst, compositeLens);
        }
    }

    @Override
    public int getLensColor(ItemStack stack, Level level) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == -1) {
            return 0xFFFFFF;
        }
        if (storedColor == 16) {
            if (level == null) {
                return 0xFFFFFF;
            }
            return Mth.m_14169_((float)((float)(level.m_46467_() * 2L % 360L) / 360.0f), (float)1.0f, (float)1.0f);
        }
        return ColorHelper.getColorValue(DyeColor.m_41053_((int)storedColor));
    }

    public static int getStoredColor(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COLOR, -1);
    }

    public static void setLensColor(ItemStack stack, int color) {
        ItemNBTHelper.setInt(stack, TAG_COLOR, color);
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    public static boolean isBlacklisted(ItemStack lens1, ItemStack lens2) {
        ICompositableLens item1 = (ICompositableLens)lens1.m_41720_();
        ICompositableLens item2 = (ICompositableLens)lens2.m_41720_();
        return (item1.getProps(lens1) & item2.getProps(lens2)) != 0;
    }

    public static Lens getLens(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemLens) {
            return ((ItemLens)stack.m_41720_()).lens;
        }
        return new Lens();
    }

    @Override
    public boolean canCombineLenses(ItemStack sourceLens, ItemStack compositeLens) {
        ICompositableLens compositeItem;
        ICompositableLens sourceItem = (ICompositableLens)sourceLens.m_41720_();
        if (sourceItem == (compositeItem = (ICompositableLens)compositeLens.m_41720_())) {
            return false;
        }
        if (!sourceItem.isCombinable(sourceLens) || !compositeItem.isCombinable(compositeLens)) {
            return false;
        }
        return !ItemLens.isBlacklisted(sourceLens, compositeLens);
    }

    @Override
    public ItemStack getCompositeLens(ItemStack stack) {
        CompoundTag cmp = ItemNBTHelper.getCompound(stack, TAG_COMPOSITE_LENS, true);
        if (cmp == null) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    @Override
    public ItemStack setCompositeLens(ItemStack sourceLens, ItemStack compositeLens) {
        if (compositeLens.m_41619_()) {
            ItemNBTHelper.removeEntry(sourceLens, TAG_COMPOSITE_LENS);
        } else {
            CompoundTag cmp = compositeLens.m_41739_(new CompoundTag());
            ItemNBTHelper.setCompound(sourceLens, TAG_COMPOSITE_LENS, cmp);
        }
        return sourceLens;
    }

    @Override
    public int getManaToTransfer(IManaBurst burst, ItemStack stack, IManaReceiver receiver) {
        return ItemLens.getLens(stack).getManaToTransfer(burst, stack, receiver);
    }

    @Override
    public boolean shouldPull(ItemStack stack) {
        return !stack.m_150930_(ModItems.lensStorm);
    }

    @Override
    public boolean isControlLens(ItemStack stack) {
        return (this.getProps(stack) & 0x20) != 0;
    }

    @Override
    public boolean allowBurstShooting(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        return ItemLens.getLens(stack).allowBurstShooting(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderTick(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        ItemLens.getLens(stack).onControlledSpreaderTick(stack, spreader, redstone);
    }

    @Override
    public void onControlledSpreaderPulse(ItemStack stack, IManaSpreader spreader) {
        ItemLens.getLens(stack).onControlledSpreaderPulse(stack, spreader);
    }

    @Override
    public int getProps(ItemStack stack) {
        return this.props;
    }

    @Override
    public boolean isCombinable(ItemStack stack) {
        return !stack.m_150930_(ModItems.lensNormal);
    }
}

