/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemManaRing
extends ItemBauble
implements IManaItem {
    protected static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";

    public ItemManaRing(Item.Properties props) {
        super(props);
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.m_41389_(tab)) {
            stacks.add((Object)new ItemStack((ItemLike)this));
            ItemStack full = new ItemStack((ItemLike)this);
            ItemManaRing.setMana(full, this.getMaxMana(full));
            stacks.add((Object)full);
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    @Override
    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0) * stack.m_41613_();
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return 500000 * stack.m_41613_();
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        ItemManaRing.setMana(stack, Math.min(this.getMana(stack) + mana, this.getMaxMana(stack)) / stack.m_41613_());
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, BlockEntity pool) {
        return true;
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, BlockEntity pool) {
        return true;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(this, stack));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(ManaBarTooltip.getFractionForDisplay(this, stack) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

