/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.mixin.AccessorItemEntity;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemMagnetRing
extends ItemBauble {
    private static final String TAG_COOLDOWN = "cooldown";
    private final int range;

    public ItemMagnetRing(Item.Properties props) {
        this(props, 6);
    }

    public ItemMagnetRing(Item.Properties props, int range) {
        super(props);
        this.range = range;
    }

    public static void onTossItem(Player player) {
        ItemStack ring = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof ItemMagnetRing, (LivingEntity)player);
        if (!ring.m_41619_()) {
            ItemMagnetRing.setCooldown(ring, 100);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        super.onWornTick(stack, living);
        if (living.m_5833_()) {
            return;
        }
        int cooldown = ItemMagnetRing.getCooldown(stack);
        if (BotaniaAPI.instance().hasSolegnoliaAround((Entity)living)) {
            if (cooldown < 0) {
                ItemMagnetRing.setCooldown(stack, 2);
            }
            return;
        }
        if (cooldown <= 0) {
            if (living.m_6144_() == BotaniaConfig.common().invertMagnetRing()) {
                double x = living.m_20185_();
                double y = living.m_20186_() + 0.75;
                double z = living.m_20189_();
                int range = ((ItemMagnetRing)stack.m_41720_()).range;
                List items = living.f_19853_.m_45976_(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
                int pulled = 0;
                for (ItemEntity item : items) {
                    if (!((ItemMagnetRing)stack.m_41720_()).canPullItem(item)) continue;
                    if (pulled <= 200) {
                        MathHelper.setEntityMotionFromVector((Entity)item, new Vec3(x, y, z), 0.45f);
                        if (living.f_19853_.f_46443_) {
                            boolean red = living.f_19853_.f_46441_.nextBoolean();
                            float r = red ? 1.0f : 0.0f;
                            float b = red ? 0.0f : 1.0f;
                            SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, 0.0f, b, 3);
                            living.f_19853_.m_7106_((ParticleOptions)data, item.m_20185_(), item.m_20186_(), item.m_20189_(), 0.0, 0.0, 0.0);
                        }
                        ++pulled;
                        continue;
                    }
                    break;
                }
            }
        } else {
            ItemMagnetRing.setCooldown(stack, cooldown - 1);
        }
    }

    private boolean canPullItem(ItemEntity item) {
        int pickupDelay = ((AccessorItemEntity)item).getPickupDelay();
        if (!item.m_6084_() || pickupDelay >= 40 || BotaniaAPI.instance().hasSolegnoliaAround((Entity)item) || IXplatAbstractions.INSTANCE.preventsRemoteMovement(item)) {
            return false;
        }
        ItemStack stack = item.m_32055_();
        if (stack.m_41619_() || stack.m_41720_() instanceof IManaItem || stack.m_41720_() instanceof IRelic || ModTags.Items.MAGNET_RING_BLACKLIST.m_8110_((Object)stack.m_41720_())) {
            return false;
        }
        BlockPos pos = item.m_142538_();
        if (ModTags.Blocks.MAGNET_RING_BLACKLIST.m_8110_((Object)item.f_19853_.m_8055_(pos).m_60734_())) {
            return false;
        }
        return !ModTags.Blocks.MAGNET_RING_BLACKLIST.m_8110_((Object)item.f_19853_.m_8055_(pos.m_7495_()).m_60734_());
    }

    public static int getCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_COOLDOWN, 0);
    }

    public static void setCooldown(ItemStack stack, int cooldown) {
        ItemNBTHelper.setInt(stack, TAG_COOLDOWN, cooldown);
    }
}

