/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ItemManaTablet
extends Item
implements IManaItem {
    public static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_CREATIVE = "creative";
    private static final String TAG_ONE_USE = "oneUse";

    public ItemManaTablet(Item.Properties props) {
        super(props);
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.m_41389_(tab)) {
            stacks.add((Object)new ItemStack((ItemLike)this));
            ItemStack fullPower = new ItemStack((ItemLike)this);
            ItemManaTablet.setMana(fullPower, 500000);
            stacks.add((Object)fullPower);
            ItemStack creative = new ItemStack((ItemLike)this);
            ItemManaTablet.setMana(creative, 500000);
            ItemManaTablet.setStackCreative(creative);
            stacks.add((Object)creative);
        }
    }

    @Nonnull
    public Rarity m_41460_(@Nonnull ItemStack stack) {
        return ItemManaTablet.isStackCreative(stack) ? Rarity.EPIC : super.m_41460_(stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        if (ItemManaTablet.isStackCreative(stack)) {
            stacks.add((Component)new TranslatableComponent("botaniamisc.creative").m_130940_(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt(stack, TAG_MANA, mana);
    }

    public static void setStackCreative(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
    }

    public static boolean isStackCreative(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
    }

    @Override
    public int getMana(ItemStack stack) {
        if (ItemManaTablet.isStackCreative(stack)) {
            return this.getMaxMana(stack);
        }
        return ItemNBTHelper.getInt(stack, TAG_MANA, 0) * stack.m_41613_();
    }

    @Override
    public int getMaxMana(ItemStack stack) {
        return (ItemManaTablet.isStackCreative(stack) ? 501000 : 500000) * stack.m_41613_();
    }

    @Override
    public void addMana(ItemStack stack, int mana) {
        if (!ItemManaTablet.isStackCreative(stack)) {
            ItemManaTablet.setMana(stack, Math.min(this.getMana(stack) + mana, this.getMaxMana(stack)) / stack.m_41613_());
        }
    }

    @Override
    public boolean canReceiveManaFromPool(ItemStack stack, BlockEntity pool) {
        return !ItemNBTHelper.getBoolean(stack, TAG_ONE_USE, false);
    }

    @Override
    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return !ItemManaTablet.isStackCreative(stack);
    }

    @Override
    public boolean canExportManaToPool(ItemStack stack, BlockEntity pool) {
        return true;
    }

    @Override
    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return true;
    }

    @Override
    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return !ItemManaTablet.isStackCreative(stack);
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(this, stack));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(ManaBarTooltip.getFractionForDisplay(this, stack) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

