/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumHelm;
import vazkii.botania.common.lib.ResourceLocationHelper;

public final class PixieHandler {
    public static final Attribute PIXIE_SPAWN_CHANCE = new RangedAttribute("attribute.name.botania.pixieSpawnChance", 0.0, 0.0, 1.0);
    private static final Map<EquipmentSlot, UUID> DEFAULT_MODIFIER_UUIDS = (Map)Util.m_137469_(new EnumMap(EquipmentSlot.class), m -> {
        m.put(EquipmentSlot.HEAD, UUID.fromString("3c1f559c-9ec4-412d-ada0-dbf3e714088e"));
        m.put(EquipmentSlot.CHEST, UUID.fromString("9631121c-16f0-4ed4-ba0a-0e7a063cb71c"));
        m.put(EquipmentSlot.LEGS, UUID.fromString("a87117a1-ac15-4b17-9fd5-e98d5fe31ff1"));
        m.put(EquipmentSlot.FEET, UUID.fromString("ff67d38a-c5be-4a00-90ed-76bb12c45523"));
        m.put(EquipmentSlot.MAINHAND, UUID.fromString("995829fa-94c0-41bd-b046-0468c509a488"));
        m.put(EquipmentSlot.OFFHAND, UUID.fromString("34f62de8-f652-4fe7-899f-a8fc938c4940"));
    });
    private static final MobEffect[] potions = new MobEffect[]{MobEffects.f_19610_, MobEffects.f_19615_, MobEffects.f_19597_, MobEffects.f_19613_};

    private PixieHandler() {
    }

    public static void registerAttribute(BiConsumer<Attribute, ResourceLocation> r) {
        r.accept(PIXIE_SPAWN_CHANCE, ResourceLocationHelper.prefix("pixie_spawn_chance"));
    }

    public static AttributeModifier makeModifier(EquipmentSlot slot, String name, double amount) {
        return new AttributeModifier(DEFAULT_MODIFIER_UUIDS.get(slot), name, amount, AttributeModifier.Operation.ADDITION);
    }

    public static void onDamageTaken(Player player, DamageSource source) {
        Entity entity;
        if (!player.f_19853_.f_46443_ && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity livingSource = (LivingEntity)entity;
            double chance = player.m_21133_(PIXIE_SPAWN_CHANCE);
            ItemStack sword = PlayerHelper.getFirstHeldItem((LivingEntity)player, s -> s.m_150930_(ModItems.elementiumSword));
            if (Math.random() < chance) {
                EntityPixie pixie = new EntityPixie(player.f_19853_);
                pixie.m_6034_(player.m_20185_(), player.m_20186_() + 2.0, player.m_20189_());
                if (((ItemElementiumHelm)ModItems.elementiumHelm).hasArmorSet(player)) {
                    pixie.setApplyPotionEffect(new MobEffectInstance(potions[player.f_19853_.f_46441_.nextInt(potions.length)], 40, 0));
                }
                float dmg = 4.0f;
                if (!sword.m_41619_()) {
                    dmg += 2.0f;
                }
                pixie.setProps(livingSource, (LivingEntity)player, 0, dmg);
                pixie.m_6518_((ServerLevelAccessor)player.f_19853_, player.f_19853_.m_6436_(pixie.m_142538_()), MobSpawnType.EVENT, null, null);
                player.f_19853_.m_7967_((Entity)pixie);
            }
        }
    }
}

