/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.common.helper.MathHelper;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final WeakHashMap<Level, Set<BlockEntity>> manaPools = new WeakHashMap();
    private final WeakHashMap<Level, Set<BlockEntity>> manaCollectors = new WeakHashMap();

    public void onNetworkEvent(BlockEntity be, ManaBlockType type, ManaNetworkAction action) {
        WeakHashMap<Level, Set<BlockEntity>> map;
        WeakHashMap<Level, Set<BlockEntity>> weakHashMap = map = type == ManaBlockType.COLLECTOR ? this.manaCollectors : this.manaPools;
        if (action == ManaNetworkAction.ADD) {
            this.add(map, be);
        } else {
            this.remove(map, be);
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public BlockEntity getClosestPool(BlockPos pos, Level world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public BlockEntity getClosestCollector(BlockPos pos, Level world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    public boolean isCollectorIn(BlockEntity tile) {
        return this.isIn(tile, this.manaCollectors);
    }

    public boolean isPoolIn(BlockEntity tile) {
        return this.isIn(tile, this.manaPools);
    }

    private boolean isIn(BlockEntity tile, Map<Level, Set<BlockEntity>> map) {
        Set<BlockEntity> set = map.get(tile.m_58904_());
        return set != null && set.contains(tile);
    }

    @Nullable
    private BlockEntity getClosest(Set<BlockEntity> tiles, BlockPos pos, int limit) {
        long minDist = Long.MAX_VALUE;
        long limitSquared = (long)limit * (long)limit;
        BlockEntity closest = null;
        for (BlockEntity te : tiles) {
            long distance;
            if (te.m_58901_() || (distance = MathHelper.distSqr((Vec3i)te.m_58899_(), (Vec3i)pos)) > limitSquared || distance >= minDist) continue;
            minDist = distance;
            closest = te;
        }
        return closest;
    }

    private void remove(Map<Level, Set<BlockEntity>> map, BlockEntity tile) {
        Level world = tile.m_58904_();
        if (!map.containsKey(world)) {
            return;
        }
        map.get(world).remove(tile);
    }

    private void add(Map<Level, Set<BlockEntity>> map, BlockEntity tile) {
        Level world = tile.m_58904_();
        map.computeIfAbsent(world, k -> new HashSet()).add(tile);
    }

    @Override
    public Set<BlockEntity> getAllCollectorsInWorld(Level world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<BlockEntity> getAllPoolsInWorld(Level world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    private Set<BlockEntity> getAllInWorld(Map<Level, Set<BlockEntity>> map, Level world) {
        Set<BlockEntity> ret = map.get(world);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }
}

