/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.entity.EntityManaSpark;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.entity.SparkArrayList;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;

public class EntityCorporeaSpark
extends EntitySparkBase
implements ICorporeaSpark {
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final String TAG_CREATIVE = "creative";
    private static final EntityDataAccessor<Boolean> MASTER = SynchedEntityData.m_135353_(EntityCorporeaSpark.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CREATIVE = SynchedEntityData.m_135353_(EntityCorporeaSpark.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ICorporeaSpark master;
    private List<ICorporeaSpark> connections = new SparkArrayList<ICorporeaSpark>();
    private List<ICorporeaSpark> relatives = new ArrayList<ICorporeaSpark>();
    private boolean firstTick = true;

    public EntityCorporeaSpark(EntityType<EntityCorporeaSpark> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MASTER, (Object)false);
        this.f_19804_.m_135372_(CREATIVE, (Object)false);
    }

    @Nonnull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)(this.isCreative() ? ModItems.corporeaSparkCreative : (this.isMaster() ? ModItems.corporeaSparkMaster : ModItems.corporeaSpark)));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        ICorporeaNode node = this.getSparkNode();
        if (node instanceof DummyCorporeaNode && !this.f_19853_.m_8055_(this.getAttachPos()).m_60620_(ModTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (!(this.master == null || this.master.entity().m_6084_() && this.master.getNetwork() == this.getNetwork())) {
            this.master = null;
        }
    }

    private void dropAndKill() {
        this.m_5552_(new ItemStack((ItemLike)(this.isCreative() ? ModItems.corporeaSparkCreative : (this.isMaster() ? ModItems.corporeaSparkMaster : ModItems.corporeaSpark))), 0.0f);
        this.m_146870_();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void registerConnections(ICorporeaSpark master, ICorporeaSpark referrer, List<ICorporeaSpark> connections) {
        this.relatives.clear();
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            if (spark == null || connections.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || !spark.entity().m_6084_()) continue;
            connections.add(spark);
            this.relatives.add(spark);
            spark.registerConnections(master, this, connections);
        }
        this.master = master;
        this.connections = connections;
    }

    private List<ICorporeaSpark> getNearbySparks() {
        return this.f_19853_.m_6443_(Entity.class, new AABB(this.m_20185_() - 8.0, this.m_20186_() - 8.0, this.m_20189_() - 8.0, this.m_20185_() + 8.0, this.m_20186_() + 8.0, this.m_20189_() + 8.0), (Predicate)Predicates.instanceOf(ICorporeaSpark.class));
    }

    private void restartNetwork() {
        this.connections = new SparkArrayList<ICorporeaSpark>();
        this.relatives = new ArrayList<ICorporeaSpark>();
        if (this.master != null) {
            ICorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.registerConnections(oldMaster, this, new SparkArrayList<ICorporeaSpark>());
        }
    }

    private void findNetwork() {
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            ICorporeaSpark master;
            if (spark.getNetwork() != this.getNetwork() || !spark.entity().m_6084_() || (master = spark.getMaster()) == null) continue;
            this.master = master;
            this.restartNetwork();
            break;
        }
    }

    private static void displayRelatives(Player player, List<ICorporeaSpark> checked, ICorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<ICorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            EntityManaSpark.particleBeam(player, spark.entity(), spark.getMaster().entity());
        } else {
            for (ICorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                EntityManaSpark.particleBeam(player, spark.entity(), endSpark.entity());
                checked.add(endSpark);
                EntityCorporeaSpark.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public ICorporeaNode getSparkNode() {
        return CorporeaNodeDetectors.findNode(this.f_19853_, this);
    }

    @Override
    public List<ICorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<ICorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(ItemStack stack) {
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.125, 0.125, 0.125, 0.05);
    }

    @Override
    public void onItemsRequested(List<ItemStack> stacks) {
        ArrayList<Item> shownItems = new ArrayList<Item>();
        for (ItemStack stack : stacks) {
            if (shownItems.contains(stack.m_41720_())) continue;
            shownItems.add(stack.m_41720_());
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.125, 0.125, 0.125, 0.05);
        }
    }

    @Override
    public ICorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.f_19804_.m_135381_(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.f_19804_.m_135370_(MASTER);
    }

    public void setCreative(boolean creative) {
        this.f_19804_.m_135381_(CREATIVE, (Object)creative);
    }

    @Override
    public boolean isCreative() {
        return (Boolean)this.f_19804_.m_135370_(CREATIVE);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6084_() && !stack.m_41619_()) {
            if (stack.m_150930_(ModItems.twigWand)) {
                if (!this.f_19853_.f_46443_) {
                    if (player.m_6144_()) {
                        this.dropAndKill();
                        if (this.isMaster()) {
                            this.restartNetwork();
                        }
                    } else {
                        EntityCorporeaSpark.displayRelatives(player, new ArrayList<ICorporeaSpark>(), this.master);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            Item item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                DyeColor color = dye.m_41089_();
                if (color != this.getNetwork()) {
                    if (!this.f_19853_.f_46443_) {
                        this.setNetwork(color);
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
            } else if (stack.m_150930_(ModItems.phantomInk)) {
                if (!this.f_19853_.f_46443_) {
                    this.m_6842_(true);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void setNetwork(DyeColor color) {
        if (color == this.getNetwork()) {
            return;
        }
        super.setNetwork(color);
        if (!this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
        }
    }

    @Override
    protected void m_7378_(@Nonnull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setMaster(cmp.m_128471_(TAG_MASTER));
        this.setCreative(cmp.m_128471_(TAG_CREATIVE));
    }

    @Override
    protected void m_7380_(@Nonnull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128379_(TAG_MASTER, this.isMaster());
        cmp.m_128379_(TAG_CREATIVE, this.isCreative());
    }
}

