/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class NbtOutputRecipe {
    public static RecipeSerializer<Recipe<?>> SERIALIZER = new Serializer();

    private static class Serializer
    extends RecipeSerializerBase<Recipe<?>> {
        private Serializer() {
        }

        @Nonnull
        public Recipe<?> m_6729_(@Nonnull ResourceLocation resourceLocation, @Nonnull JsonObject jsonObject) {
            Recipe recipe = RecipeManager.m_44045_((ResourceLocation)resourceLocation, (JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"recipe"));
            JsonElement nbt = jsonObject.get("nbt");
            if (nbt == null) {
                throw new JsonSyntaxException("No nbt tag");
            }
            try {
                CompoundTag tag = TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)nbt, (String)"nbt"));
                recipe.m_8043_().m_41751_(tag);
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid nbt tag: " + e.getMessage(), (Throwable)e);
            }
            return recipe;
        }

        @Nonnull
        public Recipe<?> m_8005_(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
        }

        public void m_6178_(@Nonnull FriendlyByteBuf buffer, @Nonnull Recipe<?> recipe) {
            throw new IllegalStateException("NbtOutputRecipe should not be sent over network");
        }
    }
}

