/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.crafting.StateIngredientBlocks;

public class StateIngredientTag
extends StateIngredientBlocks {
    private final ResourceLocation tag;

    public StateIngredientTag(ResourceLocation id) {
        super((Collection<Block>)ImmutableSet.of());
        this.tag = id;
    }

    @Nonnull
    protected Tag<Block> resolve() {
        return SerializationTags.m_13199_().m_144452_(Registry.f_122901_).m_7689_(this.tag);
    }

    @Override
    public boolean test(BlockState state) {
        return this.resolve().m_8110_((Object)state.m_60734_());
    }

    @Override
    public BlockState pick(Random random) {
        Tag<Block> tag = this.resolve();
        if (tag.m_6497_().isEmpty()) {
            return null;
        }
        return ((Block)tag.m_13288_(random)).m_49966_();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "tag");
        object.addProperty("tag", this.tag.toString());
        return object;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.resolve().m_6497_().stream().filter(b -> b.m_5456_() != Items.f_41852_).map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    protected List<Block> getBlocks() {
        return this.resolve().m_6497_();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.resolve().m_6497_().stream().map(Block::m_49966_).collect(Collectors.toList());
    }

    public ResourceLocation getTagId() {
        return this.tag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.tag.equals((Object)((StateIngredientTag)o).tag);
    }

    @Override
    public int hashCode() {
        return this.tag.hashCode();
    }

    @Override
    public String toString() {
        return "StateIngredientTag{" + this.tag + "}";
    }
}

