/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;

public class TilePrism
extends TileExposedSimpleInventory {
    public TilePrism(BlockPos pos, BlockState state) {
        super(ModTiles.PRISM, pos, state);
    }

    public void onBurstCollision(IManaBurst burst) {
        ITinyPlanetExcempt excempt;
        Item item;
        boolean valid;
        ItemStack lens = this.getItemHandler().m_8020_(0);
        boolean active = (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) == false;
        boolean bl = valid = !lens.m_41619_() && lens.m_41720_() instanceof ILens && (!((item = lens.m_41720_()) instanceof ITinyPlanetExcempt) || (excempt = (ITinyPlanetExcempt)item).shouldPull(lens));
        if (active) {
            burst.setSourceLens(valid ? lens.m_41777_() : ItemStack.f_41583_);
            burst.setColor(0xFFFFFF);
            burst.setGravity(0.0f);
            if (valid) {
                ThrowableProjectile burstEntity = burst.entity();
                BurstProperties properties = new BurstProperties(burst.getStartingMana(), burst.getMinManaLoss(), burst.getManaLossPerTick(), burst.getBurstGravity(), 1.0f, burst.getColor());
                ((ILens)lens.m_41720_()).apply(lens, properties, this.f_58857_);
                burst.setColor(properties.color);
                burst.setStartingMana(properties.maxMana);
                burst.setMinManaLoss(properties.ticksBeforeManaLoss);
                burst.setManaLossPerTick(properties.manaLossPerTick);
                burst.setGravity(properties.gravity);
                burstEntity.m_20256_(burstEntity.m_20184_().m_82490_((double)properties.motionModifier));
            }
        }
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public boolean m_7013_(int index, ItemStack stack) {
                return !stack.m_41619_() && stack.m_41720_() instanceof ILens;
            }

            public int m_6893_() {
                return 1;
            }
        };
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean hasLens;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            BlockState state = this.m_58900_();
            boolean bl = hasLens = !this.getItemHandler().m_8020_(0).m_41619_();
            if (!state.m_60713_(ModBlocks.prism) || (Boolean)state.m_61143_((Property)BotaniaStateProps.HAS_LENS) != hasLens) {
                BlockState base = state.m_60713_(ModBlocks.prism) ? state : ModBlocks.prism.m_49966_();
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)base.m_61124_((Property)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf(hasLens)));
            }
        }
    }

    public static class WandHud
    implements IWandHUD {
        private final TilePrism prism;

        public WandHud(TilePrism prism) {
            this.prism = prism;
        }

        @Override
        public void renderHUD(PoseStack ms, Minecraft mc) {
            ItemStack lens = this.prism.m_8020_(0);
            if (!lens.m_41619_()) {
                Component lensName = lens.m_41786_();
                int width = 16 + mc.f_91062_.m_92852_((FormattedText)lensName) / 2;
                int x = mc.m_91268_().m_85445_() / 2 - width;
                int y = mc.m_91268_().m_85446_() / 2;
                mc.f_91062_.m_92763_(ms, lensName, (float)(x + 20), (float)(y + 5), -1);
                mc.m_91291_().m_115203_(lens, x, y);
            }
        }
    }
}

