/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.xplat.IXplatAbstractions;

public class TileAvatar
extends TileSimpleInventory
implements IAvatarTile {
    private static final int MAX_MANA = 6400;
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    private static final String TAG_MANA = "mana";
    private static final String TAG_COOLDOWNS = "boostCooldowns";
    private boolean enabled;
    private int ticksElapsed;
    private int mana;
    private final Map<UUID, Integer> boostCooldowns = new HashMap<UUID, Integer>();

    public TileAvatar(BlockPos pos, BlockState state) {
        super(ModTiles.AVATAR, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileAvatar self) {
        IAvatarWieldable wieldable;
        self.enabled = !level.m_46753_(worldPosition);
        ItemStack stack = self.getItemHandler().m_8020_(0);
        if (!stack.m_41619_() && (wieldable = IXplatAbstractions.INSTANCE.findAvatarWieldable(stack)) != null) {
            wieldable.onAvatarUpdate(self);
        }
        if (self.enabled) {
            ++self.ticksElapsed;
        }
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.m_128379_(TAG_ENABLED, this.enabled);
        tag.m_128405_(TAG_TICKS_ELAPSED, this.ticksElapsed);
        tag.m_128405_(TAG_MANA, this.mana);
        ListTag boostCooldowns = new ListTag();
        for (Map.Entry<UUID, Integer> e : this.boostCooldowns.entrySet()) {
            CompoundTag cmp = new CompoundTag();
            cmp.m_128362_("id", e.getKey());
            cmp.m_128405_("cooldown", e.getValue().intValue());
            boostCooldowns.add((Object)cmp);
        }
        tag.m_128365_(TAG_COOLDOWNS, (Tag)boostCooldowns);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.enabled = tag.m_128471_(TAG_ENABLED);
        this.ticksElapsed = tag.m_128451_(TAG_TICKS_ELAPSED);
        this.mana = tag.m_128451_(TAG_MANA);
        this.boostCooldowns.clear();
        ListTag boostCooldowns = tag.m_128437_(TAG_COOLDOWNS, 10);
        for (Tag nbt : boostCooldowns) {
            CompoundTag cmp = (CompoundTag)nbt;
            UUID id = cmp.m_128342_("id");
            int cooldown = cmp.m_128451_("cooldown");
            this.boostCooldowns.put(id, cooldown);
        }
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        };
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean isFull() {
        return this.mana >= 6400;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(19200, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.getItemHandler().m_8020_(0).m_41619_();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public Container getInventory() {
        return this.getItemHandler();
    }

    @Override
    public Direction getAvatarFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    @Override
    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Map<UUID, Integer> getBoostCooldowns() {
        return this.boostCooldowns;
    }
}

