/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileBellethorn
extends TileEntityFunctionalFlower {
    public static final int RANGE = 6;
    public static final int RANGE_MINI = 1;

    protected SubTileBellethorn(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SubTileBellethorn(BlockPos pos, BlockState state) {
        this(ModSubtiles.BELLETHORNE, pos, state);
    }

    @Override
    public int getColor() {
        return 12203041;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_ || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        int manaToUse = this.getManaCost();
        if (this.ticksExisted % 5 == 0) {
            int range = this.getRange();
            List entities = this.m_58904_().m_6443_(LivingEntity.class, new AABB(this.getEffectivePos().m_142082_(-range, -range, -range), this.getEffectivePos().m_142082_(range + 1, range + 1, range + 1)), this.getSelector());
            for (LivingEntity entity : entities) {
                if (this.getMana() < manaToUse) break;
                if (entity.f_20916_ != 0) continue;
                int dmg = 4;
                if (entity instanceof Witch) {
                    dmg = 20;
                }
                entity.m_6469_(DamageSource.f_19319_, (float)dmg);
                this.addMana(-manaToUse);
            }
        }
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    public int getManaCost() {
        return 24;
    }

    public int getRange() {
        return 6;
    }

    public Predicate<Entity> getSelector() {
        return entity -> !(entity instanceof Player);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public static class Mini
    extends SubTileBellethorn {
        public Mini(BlockPos pos, BlockState state) {
            super(ModSubtiles.BELLETHORNE_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 1;
        }
    }
}

